/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.demo.HTMLJDocument;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;

class IndexJHTML {
    private static boolean deleting = false;
    private static IndexReader reader;
    private static IndexWriter writer;
    private static TermEnum uidIter;

    IndexJHTML() {
    }

    public static void main(String[] stringArray) {
        try {
            String string = "index";
            String string2 = System.getProperty("file.encoding");
            boolean bl = false;
            File file = null;
            String string3 = "IndexJHTML [-charset <default charset>] [-create] [-index <index>] <root_directory>";
            if (stringArray.length == 0) {
                System.err.println("Usage: " + string3);
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-index")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-charset")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-create")) {
                    bl = true;
                    continue;
                }
                if (i != stringArray.length - 1) {
                    System.err.println("Usage: " + string3);
                    return;
                }
                file = new File(stringArray[i]);
            }
            Date date = new Date();
            if (!bl) {
                deleting = true;
                IndexJHTML.indexDocs(file, string, bl, string2);
            }
            writer = new IndexWriter(string, (Analyzer)new JapaneseAnalyzer(), bl);
            IndexJHTML.writer.maxFieldLength = 1000000;
            IndexJHTML.indexDocs(file, string, bl, string2);
            System.out.println("Optimizing index...");
            writer.optimize();
            writer.close();
            Date date2 = new Date();
            System.out.print(date2.getTime() - date.getTime());
            System.out.println(" total milliseconds");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("a");
            System.out.println(" caught a " + exception.getClass() + "\n with message: " + exception.getMessage());
        }
    }

    private static void indexDocs(File file, String string, boolean bl, String string2) throws Exception {
        if (!bl) {
            reader = IndexReader.open((String)string);
            uidIter = reader.terms(new Term("uid", ""));
            IndexJHTML.indexDocs(file, string2);
            if (deleting) {
                while (uidIter.term() != null && uidIter.term().field() == "uid") {
                    System.out.println("deleting " + HTMLJDocument.uid2url(uidIter.term().text()));
                    reader.delete(uidIter.term());
                    uidIter.next();
                }
                deleting = false;
            }
            uidIter.close();
            reader.close();
        } else {
            IndexJHTML.indexDocs(file, string2);
        }
    }

    private static void indexDocs(File file, String string) throws Exception {
        if (file.isDirectory()) {
            Object[] objectArray = file.list();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    IndexJHTML.indexDocs(new File(file, (String)objectArray[i]), string);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("fail indexing: " + file.toString());
                    return;
                }
            }
        } else if (file.getPath().endsWith(".html") || file.getPath().endsWith(".htm") || file.getPath().endsWith(".txt")) {
            if (uidIter != null) {
                String string2 = HTMLJDocument.uid(file);
                while (uidIter.term() != null && uidIter.term().field() == "uid" && uidIter.term().text().compareTo(string2) < 0) {
                    if (deleting) {
                        System.out.println("deleting " + HTMLJDocument.uid2url(uidIter.term().text()));
                        reader.delete(uidIter.term());
                    }
                    uidIter.next();
                }
                if (uidIter.term() != null && uidIter.term().field() == "uid" && uidIter.term().text().compareTo(string2) == 0) {
                    uidIter.next();
                } else if (!deleting) {
                    Document document = HTMLJDocument.Document(file, string);
                    System.out.println("adding " + document.get("url"));
                    writer.addDocument(document);
                }
            } else {
                Document document = HTMLJDocument.Document(file, string);
                System.out.println("adding " + document.get("url"));
                writer.addDocument(document);
            }
        }
    }
}

