/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;

public abstract class Trigger
implements Serializable,
Cloneable,
Comparable {
    public static final int INSTRUCTION_NOOP = 0;
    public static final int INSTRUCTION_RE_EXECUTE_JOB = 1;
    public static final int INSTRUCTION_SET_TRIGGER_COMPLETE = 2;
    public static final int INSTRUCTION_DELETE_TRIGGER = 3;
    public static final int INSTRUCTION_SET_ALL_JOB_TRIGGERS_COMPLETE = 4;
    public static final int MISFIRE_INSTRUCTION_SMART_POLICY = 0;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_COMPLETE = 2;
    public static final int STATE_ERROR = 3;
    public static final int STATE_NONE = -1;
    private String name;
    private String group;
    private String jobName;
    private String jobGroup;
    private String description;
    private boolean volatility = false;
    private String calendarName = null;
    private String fireInstanceId = null;
    private int misfireInstruction = 0;
    private LinkedList triggerListeners = new LinkedList();

    public Trigger() {
    }

    public Trigger(String name, String group) {
        this.setName(name);
        this.setGroup(group);
    }

    public Trigger(String name, String group, String jobName, String jobGroup) {
        this.setName(name);
        this.setGroup(group);
        this.setJobName(jobName);
        this.setJobGroup(jobGroup);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Trigger name cannot be null or empty.");
        }
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        if (group == null || group.trim().length() == 0) {
            throw new IllegalArgumentException("Group name cannot be null or empty.");
        }
        this.group = group;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        if (jobName == null || jobName.trim().length() == 0) {
            throw new IllegalArgumentException("Job name cannot be null or empty.");
        }
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        if (jobGroup == null || jobGroup.trim().length() == 0) {
            throw new IllegalArgumentException("Group name cannot be null or empty.");
        }
        this.jobGroup = jobGroup;
    }

    public String getFullName() {
        return this.group + "." + this.name;
    }

    public String getFullJobName() {
        return this.jobGroup + "." + this.jobName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVolatility(boolean volatility) {
        this.volatility = volatility;
    }

    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    public String getCalendarName() {
        return this.calendarName;
    }

    public boolean isVolatile() {
        return this.volatility;
    }

    public void addTriggerListener(String name) {
        this.triggerListeners.add(name);
    }

    public boolean removeTriggerListener(String name) {
        return this.triggerListeners.remove(name);
    }

    public String[] getTriggerListenerNames() {
        String[] outNames = new String[this.triggerListeners.size()];
        return this.triggerListeners.toArray(outNames);
    }

    public abstract void triggered(Calendar var1);

    public abstract Date computeFirstFireTime(Calendar var1);

    public abstract int executionComplete(JobExecutionContext var1, JobExecutionException var2);

    public abstract boolean mayFireAgain();

    public abstract Date getStartTime();

    public abstract Date getEndTime();

    public abstract Date getNextFireTime();

    public abstract Date getPreviousFireTime();

    public abstract Date getFireTimeAfter(Date var1);

    public abstract Date getFinalFireTime();

    public void setMisfireInstruction(int misfireInstruction) {
        if (!this.validateMisfireInstruction(misfireInstruction)) {
            throw new IllegalArgumentException("The misfire instruction code is invalid for this type of trigger.");
        }
        this.misfireInstruction = misfireInstruction;
    }

    protected abstract boolean validateMisfireInstruction(int var1);

    public int getMisfireInstruction() {
        return this.misfireInstruction;
    }

    public abstract void updateAfterMisfire(Calendar var1);

    public void validate() throws SchedulerException {
        if (this.name == null) {
            throw new SchedulerException("Trigger's name cannot be null", 100);
        }
        if (this.group == null) {
            throw new SchedulerException("Trigger's group cannot be null", 100);
        }
        if (this.jobName == null) {
            throw new SchedulerException("Trigger's related Job's name cannot be null", 100);
        }
        if (this.jobGroup == null) {
            throw new SchedulerException("Trigger's related Job's group cannot be null", 100);
        }
    }

    public void setFireInstanceId(String id) {
        this.fireInstanceId = id;
    }

    public String getFireInstanceId() {
        return this.fireInstanceId;
    }

    public String toString() {
        return "Trigger '" + this.getFullName() + "':  triggerClass: '" + this.getClass().getName() + " isVolatile: " + this.isVolatile() + " calendar: '" + this.getCalendarName() + "' misfireInstruction: " + this.getMisfireInstruction();
    }

    public int compareTo(Object obj) {
        Trigger other = (Trigger)obj;
        Date myTime = this.getNextFireTime();
        Date otherTime = other.getNextFireTime();
        if (myTime == null && otherTime == null) {
            return 0;
        }
        if (myTime == null) {
            return 1;
        }
        if (otherTime == null) {
            return -1;
        }
        return myTime.compareTo(otherTime);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)obj;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        return other.getGroup().equals(this.getGroup());
    }

    public Object clone() {
        Trigger copy;
        try {
            copy = (Trigger)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return copy;
    }
}

