/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobPersistenceException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.JobRunShellFactory;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.SchedulingContext;
import org.quartz.spi.TriggerFiredBundle;

public class JobRunShell
implements Runnable {
    protected JobExecutionContext jec = null;
    protected QuartzScheduler qs = null;
    protected Scheduler scheduler = null;
    protected SchedulingContext schdCtxt = null;
    protected JobRunShellFactory jobRunShellFactory = null;
    protected boolean shutdownRequested = false;
    static /* synthetic */ Class class$org$quartz$core$JobRunShell;

    public JobRunShell(JobRunShellFactory jobRunShellFactory, Scheduler scheduler, SchedulingContext schdCtxt) {
        this.jobRunShellFactory = jobRunShellFactory;
        this.scheduler = scheduler;
        this.schdCtxt = schdCtxt;
    }

    private static Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$core$JobRunShell == null ? (class$org$quartz$core$JobRunShell = JobRunShell.class$("org.quartz.core.JobRunShell")) : class$org$quartz$core$JobRunShell));
    }

    public void initialize(QuartzScheduler qs, TriggerFiredBundle firedBundle) throws SchedulerException {
        this.qs = qs;
        Job job = null;
        JobDetail jobDetail = firedBundle.getJobDetail();
        try {
            job = (Job)jobDetail.getJobClass().newInstance();
        }
        catch (Exception ie) {
            SchedulerException se = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "'", ie);
            qs.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getFullName() + "'", se);
            throw se;
        }
        this.jec = new JobExecutionContext(this.scheduler, firedBundle, job);
    }

    public void requestShutdown() {
        this.shutdownRequested = true;
    }

    public void run() {
        block15: {
            int instCode;
            Trigger trigger = this.jec.getTrigger();
            JobDetail jobDetail = this.jec.getJobDetail();
            while (true) {
                SchedulerException se;
                JobExecutionException jobExEx = null;
                Job job = this.jec.getJobInstance();
                try {
                    this.begin();
                }
                catch (SchedulerException se2) {
                    this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getFullName() + ": couldn't begin execution.", se2);
                    break block15;
                }
                if (!this.notifyListenersBeginning(this.jec)) break block15;
                try {
                    job.execute(this.jec);
                }
                catch (JobExecutionException jee) {
                    jobExEx = jee;
                    JobRunShell.getLog().info((Object)("Job " + jobDetail.getFullName() + " threw a JobExecutionException: "), (Throwable)jobExEx);
                }
                catch (Exception e) {
                    JobRunShell.getLog().error((Object)("Job " + jobDetail.getFullName() + " threw an unhandled Exception: "), (Throwable)e);
                    se = new SchedulerException("Job threw an unhandled exception.", e);
                    se.setErrorCode(800);
                    this.qs.notifySchedulerListenersError("Job (" + this.jec.getJobDetail().getFullName() + " threw an exception.", se);
                    jobExEx = new JobExecutionException(se, false);
                    jobExEx.setErrorCode(800);
                }
                if (!this.notifyJobListenersComplete(this.jec, jobExEx)) break block15;
                instCode = 0;
                try {
                    instCode = trigger.executionComplete(this.jec, jobExEx);
                }
                catch (Exception e) {
                    se = new SchedulerException("Trigger threw an unhandled exception.", e);
                    se.setErrorCode(850);
                    this.qs.notifySchedulerListenersError("Please report this error to the Quartz developers.", se);
                }
                if (!this.notifyTriggerListenersComplete(this.jec, instCode)) break block15;
                if (instCode != 1) break;
                this.jec.incrementRefireCount();
                try {
                    this.complete(false);
                }
                catch (SchedulerException se3) {
                    this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getFullName() + ": couldn't finalize execution.", se3);
                }
            }
            try {
                this.complete(true);
            }
            catch (SchedulerException se) {
                this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getFullName() + ": couldn't finalize execution.", se);
            }
            try {
                this.qs.notifyJobStoreJobComplete(this.schdCtxt, trigger, jobDetail, instCode);
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while marking executed job complete. job= '" + jobDetail.getFullName() + "'", jpe);
                if (!this.completeTriggerRetryLoop(trigger, jobDetail, instCode)) {
                    // empty if block
                }
                return;
            }
        }
        this.qs.notifySchedulerThread();
        this.jobRunShellFactory.returnJobRunShell(this);
    }

    protected void begin() throws SchedulerException {
    }

    protected void complete(boolean successfulExecution) throws SchedulerException {
    }

    public void passivate() {
        this.jec = null;
        this.qs = null;
    }

    private boolean notifyListenersBeginning(JobExecutionContext jec) {
        try {
            this.qs.notifyTriggerListenersFired(jec);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
            return false;
        }
        try {
            this.qs.notifyJobListenersToBeExecuted(jec);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job to be executed: (Job will NOT be executed!). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
            return false;
        }
        return true;
    }

    private boolean notifyJobListenersComplete(JobExecutionContext jec, JobExecutionException jobExEx) {
        try {
            this.qs.notifyJobListenersWasExecuted(jec, jobExEx);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job that was executed: (error will be ignored). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
            return false;
        }
        return true;
    }

    private boolean notifyTriggerListenersComplete(JobExecutionContext jec, int instCode) {
        try {
            this.qs.notifyTriggerListenersComplete(jec, instCode);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) of Job that was executed: (error will be ignored). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
            return false;
        }
        if (jec.getTrigger().getNextFireTime() == null) {
            this.qs.notifySchedulerListenersFinalized(jec.getTrigger());
        }
        return true;
    }

    public boolean completeTriggerRetryLoop(Trigger trigger, JobDetail jobDetail, int instCode) {
        while (!this.shutdownRequested) {
            try {
                Thread.sleep(5000L);
                this.qs.notifyJobStoreJobComplete(this.schdCtxt, trigger, jobDetail, instCode);
                return true;
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while marking executed job complete. job= '" + jobDetail.getFullName() + "'", jpe);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

