/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.xml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.xml.JobSchedulingDataProcessor;

public class JobInitializationPlugin
implements SchedulerPlugin {
    private String name;
    private Scheduler scheduler;
    private boolean overWriteExistingJobs = false;
    private boolean failOnFileNotFound = true;
    private boolean fileFound = false;
    private String fileName = "quartz_jobs.xml";
    static /* synthetic */ Class class$org$quartz$plugins$xml$JobInitializationPlugin;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isOverWriteExistingJobs() {
        return this.overWriteExistingJobs;
    }

    public void setOverWriteExistingJobs(boolean overWriteExistingJobs) {
        this.overWriteExistingJobs = overWriteExistingJobs;
    }

    public boolean isFailOnFileNotFound() {
        return this.failOnFileNotFound;
    }

    public void setFailOnFileNotFound(boolean failOnFileNotFound) {
        this.failOnFileNotFound = failOnFileNotFound;
    }

    protected static Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$plugins$xml$JobInitializationPlugin == null ? (class$org$quartz$plugins$xml$JobInitializationPlugin = JobInitializationPlugin.class$("org.quartz.plugins.xml.JobInitializationPlugin")) : class$org$quartz$plugins$xml$JobInitializationPlugin));
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.name = name;
        this.scheduler = scheduler;
        JobInitializationPlugin.getLog().info((Object)"Registering Quartz Job Initiazation Plug-in.");
        InputStream f = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getFileName());
        if (f == null && this.isFailOnFileNotFound()) {
            throw new SchedulerException("File named '" + this.getFileName() + "' does not exist.");
        }
        if (f == null) {
            JobInitializationPlugin.getLog().warn((Object)("File named '" + this.getFileName() + "' does not exist."));
        } else {
            this.fileFound = true;
            try {
                f.close();
            }
            catch (IOException ioe) {
                JobInitializationPlugin.getLog().warn((Object)("Error closing file named '" + this.getFileName()), (Throwable)ioe);
            }
        }
    }

    public void start() {
        if (!this.fileFound) {
            return;
        }
        JobSchedulingDataProcessor processor = new JobSchedulingDataProcessor();
        try {
            processor.processFileAndScheduleJobs(this.getFileName(), this.scheduler, this.isOverWriteExistingJobs());
        }
        catch (Exception e) {
            JobInitializationPlugin.getLog().error((Object)("Error scheduling jobs: " + e.getMessage()), (Throwable)e);
        }
    }

    public void shutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

