/*
 * $Id$
 */
package cx.ath.kgslab.bugtrack;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cx.ath.kgslab.bugtrack.xml.Bug;
import cx.ath.kgslab.bugtrack.xml.Bugtrack;
import cx.ath.kgslab.bugtrack.xml.Message;
import cx.ath.kgslab.bugtrack.xml.types.StatusType;
import cx.ath.kgslab.wiki.JaJaWikiConfig;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import org.springframework.web.context.WebApplicationContext;


/**
 * oOǗNX
 *
 * @author VM
 * @version 1.0 
 *
 * @since JaJaWiki 4.0
 */
public class BugManager implements ApplicationContextAware,
  InitializingBean {
  //  /** DOCUMENT ME! */
  //  private File indexDir = null;

  /** DOCUMENT ME! */
  private String bugtrackDir = null;

  /** DOCUMENT ME! */
  private JaJaWikiConfig config = null;

  /** DOCUMENT ME! */
  private Bugtrack[] bugtrack = null;

  /** DOCUMENT ME! */
  private Map bugtrackMap = null;

  /** DOCUMENT ME! */
  private ApplicationContext context = null;

  /**
   * 
   *
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    //System.out.println("afterPropertiesSet");
    if ((bugtrackDir == null) || (bugtrackDir.length() <= 0)) {
      bugtrackDir = "WEB-INF/bugtrack";
    }

    //΃pXł͂Ȃꍇ
    if (!bugtrackDir.startsWith("/")
        || (bugtrackDir.charAt(2) != ':')) {
      if (context instanceof WebApplicationContext) {
        initialize((WebApplicationContext)context);
      } else {
        // X^hAAv̏ꍇ
        initialize(config.getRoot());
      }
    }

    bugtrackMap = new HashMap(bugtrack.length);

    for (int i = 0; i < bugtrack.length; i++) {
      //System.out.println(">afterPropertiesSet");
      File dir = new File(this.bugtrackDir, bugtrack[i].getProduct());

      if (dir.exists()) {
        //System.out.println(">>afterPropertiesSet");
        Bugtrack temp = readBugtrack(dir);

        if (temp != null) {
          //System.out.println(">>>afterPropertiesSet");
          bugtrack[i] = temp;
        }
      }

      //		createIndex(bugtrack[i].getProduct().getName());
      bugtrackMap.put(bugtrack[i].getProduct(), bugtrack[i]);
    }
  }

  /**
   * 
   *
   * @param root
   */
  private void initialize(String root) {
    //	indexDir = new File(root, SearchManager.INDEX).toString();
    bugtrackDir = new File(root, bugtrackDir).toString();
  }

  /**
   * 
   *
   * @param context
   */
  public void initialize(WebApplicationContext context) {
    //	indexDir =
    //	  context.getServletContext().getRealPath(SearchManager.INDEX);
    bugtrackDir =
      context.getServletContext().getRealPath(bugtrackDir);
  }

  /**
   * DOCUMENT ME!
   *
   * @param context DOCUMENT ME!
   *
   * @throws BeansException DOCUMENT ME!
   *
   * @see org.springframework.context.ApplicationContextAware#setApplicationContext(org.springframework.context.ApplicationContext)
   */
  public void setApplicationContext(ApplicationContext context)
        throws BeansException {
    this.context = context;
  }

  /**
   * DOCUMENT ME!
   *
   * @param product DOCUMENT ME!
   * @param bug DOCUMENT ME!
   */
  public void putBug(String product, Bug bug)
        throws MarshalException, ValidationException, IOException {
    File dir = new File(this.bugtrackDir, product);

    if (bug.getId() < 0) {
      Bugtrack bugtrack = (Bugtrack)bugtrackMap.get(product);
      int count = bugtrack.getCount() + 1;

      bug.setId(count);
      bugtrack.setCount(count);
      writeBugtrack(dir, bugtrack);
    }

    if (!dir.exists()) {
      dir.mkdirs();
    }

    writeBug(dir, bug);
  }

  /**
     * DOCUMENT ME!
     *
     * @param product DOCUMENT ME!
     * @param id DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
  public Bug getBug(String product, int id)
        throws MarshalException, ValidationException, IOException {
    File dir = new File(this.bugtrackDir, product);
    Bug result = null;

    if (dir.exists()) {
      result = readBug(dir, id);
    }

    return result;
  }

  //  /**
  //   * CfbNX쐬
  //   *
  //   * @param bug Ώۂ̃y[W
  //   *
  //   * @throws IOException
  //   */
  //  public void addIndex(String product, Bug bug) throws IOException {
  //    File dir = new File(indexDir);
  //    boolean create = false;
  //
  //    if (!dir.exists()) {
  //      create = true;
  //      dir.mkdirs();
  //    } else {
  //      // ÂCfbNX폜
  //      IndexReader reader = IndexReader.open(dir);
  //
  //      reader.delete(new Term("id", String.valueOf(bug.getId())));
  //      reader.close();
  //    }
  //
  //    // CfbNXǉ
  //    IndexWriter writer =
  //      new IndexWriter(dir, new JapaneseAnalyzer(), create);
  //
  //    writer.addDocument(createDocument(product, bug));
  //
  //    writer.optimize();
  //    writer.close();
  //  }
  //  /**
  //   * CfbNX쐬
  //   *
  //   * @throws IOException
  //   */
  //  public void createIndex(String product) throws IOException {
  //    File dir = new File(indexDir);
  //
  //    if (!dir.exists()) {
  //      dir.mkdirs();
  //    }
  //
  //    IndexWriter writer =
  //      new IndexWriter(dir, new JapaneseAnalyzer(), true);
  //    List bugs = this.getBugList();
  //    Iterator itarator = bugs.iterator();
  //
  //    while (itarator.hasNext()) {
  //      writer.addDocument(createDocument(product, (Bug)itarator.next()));
  //    }
  //
  //    writer.optimize();
  //    writer.close();
  //  }

  /**
   * DOCUMENT ME!
   *
   * @param product DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  public List getBugList(String product)
        throws MarshalException, ValidationException, IOException {
    //System.out.println("BugList");
    Bugtrack bugtrack = (Bugtrack)bugtrackMap.get(product);
    File dir = new File(this.bugtrackDir, product);
    List result = null;

    if (dir.exists()) {
      int count = bugtrack.getCount();

      //System.out.println("BugList Count :" + count);
      result = new ArrayList(count);
      for (int i = 1; i <= count; i++) {
        result.add(this.readBug(dir, i));
      }
    }

    //System.out.println("BugList");
    return result;
  }

  /**
   * DOCUMENT ME!
   *
   * @param dir DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  private Bug readBug(File dir, int id)
        throws IOException, MarshalException, ValidationException {
    File file = new File(dir, String.valueOf(id) + ".xml");

    if (file.exists()) {
      Reader reader =
        new InputStreamReader(new FileInputStream(
            new File(dir, String.valueOf(id) + ".xml")),
          config.getPageEncode());

      return Bug.unmarshal(reader);
    }

    return null;
  }

  /**
   * DOCUMENT ME!
   *
   * @param dir DOCUMENT ME!
   * @param bug DOCUMENT ME!
   */
  private void writeBug(File dir, Bug bug)
        throws IOException, MarshalException, ValidationException {
    if (!dir.exists()) {
      dir.mkdirs();
    }

    File file = new File(dir, String.valueOf(bug.getId()) + ".xml");
    Writer writer =
      new OutputStreamWriter(new FileOutputStream(file),
        config.getPageEncode());

    bug.marshal(writer);
  }

  /**
   * DOCUMENT ME!
   *
   * @param dir DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  private Bugtrack readBugtrack(File dir)
        throws IOException, MarshalException, ValidationException {
    File file = new File(dir, "bugtrack.xml");

    if (file.exists()) {
      Reader reader =
        new InputStreamReader(new FileInputStream(file),
          config.getPageEncode());

      return Bugtrack.unmarshal(reader);
    }

    return null;
  }

  /**
   * DOCUMENT ME!
   *
   * @param dir DOCUMENT ME!
   * @param bugtrack DOCUMENT ME!
   */
  private void writeBugtrack(File dir, Bugtrack bugtrack)
        throws IOException, MarshalException, ValidationException {
    if (!dir.exists()) {
      dir.mkdirs();
    }

    File file = new File(dir, "bugtrack.xml");

    Writer writer =
      new OutputStreamWriter(new FileOutputStream(file),
        config.getPageEncode());

    bugtrack.marshal(writer);
  }

  //  /**
  //   * LucenephLg쐬
  //   *
  //   * @param bug Ώۂ̃y[W
  //   *
  //   * @return hLg
  //   */
  //  private Document createDocument(String product, Bug bug) {
  //    Document doc = new Document();
  //
  //    doc.add(Field.Keyword("product", product));
  //    doc.add(Field.Keyword("component", bug.getComponent()));
  //    doc.add(Field.Keyword("version", bug.getVersion()));
  //    doc.add(Field.Keyword("platform", bug.getPlatform()));
  //
  //    doc.add(Field.Keyword("id", String.valueOf(bug.getId())));
  //    Message[] messages = bug.getMessage();
  //    StringBuffer subjects = new StringBuffer(1024);
  //    StringBuffer bodies = new StringBuffer(1024);
  //
  //    for (int i = 0; i < messages.length; i++) {
  //      subjects.append(messages[i].getSubject()).append("\n");
  //      bodies.append(messages[i].getBody()).append("\n");
  //    }
  //
  //    doc.add(Field.Text("subject", subjects.toString()));
  //    doc.add(Field.Text("message", bodies.toString()));
  //
  //    return doc;
  //  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  public Bugtrack[] getBugtrack() {
    return bugtrack;
  }

  /**
   * DOCUMENT ME!
   *
   * @param bugtrack DOCUMENT ME!
   */
  public void setBugtrack(Bugtrack[] bugtrack) {
    this.bugtrack = bugtrack;
  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  public JaJaWikiConfig getConfig() {
    return config;
  }

  /**
   * DOCUMENT ME!
   *
   * @param config DOCUMENT ME!
   */
  public void setConfig(JaJaWikiConfig config) {
    this.config = config;
  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  public String getBugtrackDir() {
    return bugtrackDir;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string DOCUMENT ME!
   */
  public void setBugtrackDir(String string) {
    bugtrackDir = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @param product DOCUMENT ME!
   * @param bug DOCUMENT ME!
   * @param message DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   *
   * @throws MarshalException DOCUMENT ME!
   * @throws ValidationException DOCUMENT ME!
   * @throws IOException DOCUMENT ME!
   */
  public Bug manipulateBug(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = null;

    if (bug != null) {
      result = this.getBug(product, bug.getId());
      if (result == null) {
        result = bug;
      }
    } else {
      result = new Bug();
    }

    result.addMessage(message);

    return result;
  }

  /**
   * @param bug
   * @param message
   */
  public Bug create(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = manipulateBug(product, bug, message);

    putBug(product, result);

    return result;
  }

  /**
   * @param bug
   * @param message
   */
  public Bug confirm(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = manipulateBug(product, bug, message);

    result.setStatus(StatusType.NEW);
    putBug(product, result);

    return result;
  }

  /**
   * @param bug
   * @param message
   */
  public Bug assign(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = manipulateBug(product, bug, message);

    result.setStatus(StatusType.ASSIGNED);
    putBug(product, result);

    return result;
  }

  /**
   * @param bug
   * @param message
   */
  public Bug resolve(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = manipulateBug(product, bug, message);

    result.setStatus(StatusType.RESOLVED);
    putBug(product, result);

    return result;
  }

  /**
   * @param bug
   * @param message
   */
  public Bug verify(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = manipulateBug(product, bug, message);

    result.setStatus(StatusType.VERIFIED);
    putBug(product, result);

    return result;
  }

  /**
   * @param bug
   * @param message
   */
  public Bug fix(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = manipulateBug(product, bug, message);

    result.setStatus(StatusType.FIXED);
    putBug(product, result);

    return result;
  }

  /**
   * @param bug
   * @param message
   */
  public Bug reserve(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = manipulateBug(product, bug, message);

    result.setStatus(StatusType.RESERVED);
    putBug(product, result);

    return result;
  }

  /**
   * @param bug
   * @param message
   */
  public Bug reject(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = manipulateBug(product, bug, message);

    result.setStatus(StatusType.REJECTED);
    putBug(product, result);

    return result;
  }

  /**
   * @param bug
   * @param message
   */
  public Bug addComment(String product, Bug bug, Message message)
        throws MarshalException, ValidationException, IOException {
    Bug result = manipulateBug(product, bug, message);

    putBug(product, result);

    return result;
  }

  /**
   * @param product
   */
  public Bugtrack getProduct(String product) {
    return (Bugtrack)bugtrackMap.get(product);
  }
}
