/*
 * $Id$
 */
package cx.ath.kgslab.bugtrack.action;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cx.ath.kgslab.bugtrack.BugManager;
import cx.ath.kgslab.bugtrack.form.BugForm;
import cx.ath.kgslab.bugtrack.xml.Bug;
import cx.ath.kgslab.bugtrack.xml.Message;
import cx.ath.kgslab.bugtrack.xml.types.ImportanceType;
import cx.ath.kgslab.bugtrack.xml.types.StatusType;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import org.springframework.beans.BeansException;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.DispatchActionSupport;


/**
 * oOo^ANV
 *
 * @author VM
 * @version 1.0
 */
public class RegistAction extends DispatchActionSupport {
  /**
   * oO}l[W̎擾
   *
   * @return oO}l[W
   *
   * @throws IllegalStateException
   * @throws BeansException
   */
  private BugManager getBugManager()
        throws IllegalStateException, BeansException {
    WebApplicationContext context = getWebApplicationContext();

    BugManager bugMan = (BugManager)context.getBean("bugManager");

    return bugMan;
  }

  /**
   * bZ[WIuWFNg̐
   *
   * @param bugForm tH[
   *
   * @return bZ[WIuWFNg
   */
  private Message createMessage(BugForm bugForm) {
    Message message = new Message();

    message.setDate(new Date());
    message.setBody(bugForm.getMessage());
    message.setSubject(bugForm.getSubject());
    message.setReporter(bugForm.getReporter());

    return message;
  }

  /**
   * VK쐬
   */
  public ActionForward create(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    BugManager bugMan = getBugManager();
    BugForm bugForm = (BugForm)form;
    Bug bug = bugForm.getBug();

    bug.setStatus(StatusType.valueOf(bugForm.getStatus()));
    bug.setImportance(ImportanceType.valueOf(bugForm.getImportance()));

    bug =
      bugMan.create(bugForm.getProduct(), bug, createMessage(bugForm));
    bugForm.setId(bug.getId());

    bugForm.setBug(bug);

    return mapping.findForward("success");
  }

  /**
   * ̃oO/ĂΏۂƔF߂B
   */
  public ActionForward confirm(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    BugManager bugMan = getBugManager();
    BugForm bugForm = (BugForm)form;
    Bug bug = bugForm.getBug();

    bug =
      bugMan.confirm(bugForm.getProduct(), bug, createMessage(bugForm));

    bugForm.setBug(bug);

    return mapping.findForward("success");
  }

  /**
   * ̃oO/Ă̏uJnB
   */
  public ActionForward assign(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    BugManager bugMan = getBugManager();
    BugForm bugForm = (BugForm)form;

    Bug bug = bugForm.getBug();

    bug =
      bugMan.assign(bugForm.getProduct(), bug, createMessage(bugForm));

    bugForm.setBug(bug);

    return mapping.findForward("success");
  }

  /**
   * ̃oO/Ă̏uIB
   */
  public ActionForward resolve(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    BugManager bugMan = getBugManager();
    BugForm bugForm = (BugForm)form;

    Bug bug = bugForm.getBug();

    bug =
      bugMan.resolve(bugForm.getProduct(), bug, createMessage(bugForm));

    bugForm.setBug(bug);

    return mapping.findForward("success");
  }

  /**
   * ̃oO/Ă̏umFB
   */
  public ActionForward verify(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    BugManager bugMan = getBugManager();
    BugForm bugForm = (BugForm)form;

    Bug bug = bugForm.getBug();

    bug =
      bugMan.verify(bugForm.getProduct(), bug, createMessage(bugForm));

    bugForm.setBug(bug);

    return mapping.findForward("success");
  }

  /**
   * ̃oO/ĂB
   */
  public ActionForward fix(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    BugManager bugMan = getBugManager();
    BugForm bugForm = (BugForm)form;

    Bug bug = bugForm.getBug();

    bug =
      bugMan.fix(bugForm.getProduct(), bug, createMessage(bugForm));

    bugForm.setBug(bug);

    return mapping.findForward("success");
  }

  /**
   * ̃oO/ĂۗB
   */
  public ActionForward reserve(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    BugManager bugMan = getBugManager();
    BugForm bugForm = (BugForm)form;

    Bug bug = bugForm.getBug();

    bug =
      bugMan.reserve(bugForm.getProduct(), bug, createMessage(bugForm));

    bugForm.setBug(bug);

    return mapping.findForward("success");
  }

  /**
   * ̃oO/ĂpB
   */
  public ActionForward reject(ActionMapping mapping, ActionForm form,
    HttpServletRequest request, HttpServletResponse response)
        throws Exception {
    BugManager bugMan = getBugManager();
    BugForm bugForm = (BugForm)form;

    Bug bug = bugForm.getBug();

    bug =
      bugMan.reject(bugForm.getProduct(), bug, createMessage(bugForm));

    bugForm.setBug(bug);

    return mapping.findForward("success");
  }

  /**
   * Rgǉ
   */
  public ActionForward addComment(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    BugManager bugMan = getBugManager();
    BugForm bugForm = (BugForm)form;

    Bug bug = bugForm.getBug();

    bug =
      bugMan.addComment(bugForm.getProduct(), bug,
        createMessage(bugForm));

    bugForm.setBug(bug);

    return mapping.findForward("success");
  }
}
