/*
 * 쐬: 2003/10/14
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package cx.ath.kgslab.lsmembers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

import cx.ath.kgslab.lsmembers.xml.Charactor;
import cx.ath.kgslab.lsmembers.xml.LsMembersContentHandler;
import cx.ath.kgslab.lsmembers.xml.Members;


/**
 * vOC  o[Xg
 *
 * @author VM
 * @version 1.0 
 */
public class MemberList implements ApplicationContextAware,
  InitializingBean {
  /** GR[h */
  private String encode = "utf-8";

  //private Members members;

  /** oXg */
  private List memberlist = new ArrayList();

  /** Op}bv */
  private HashMap idmap = new HashMap();

  /** oXgۑt@C̃pX */
  private File path;

  /** DOCUMENT ME! */
  private String memberFile = null;

  /** DOCUMENT ME! */
  private WebApplicationContext context = null;

  /**
   * @see org.apache.struts.action.PlugIn#destroy()
   */
  public void destroy() {
    // nop
  }

  /**
   * 
   *
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    if (memberFile != null) {
      try {
        path =
          new File(context.getServletContext().getRealPath(memberFile));

        SAXParser parser = getSAXParser();

        LsMembersContentHandler handler =
          new LsMembersContentHandler();

        parser.parse(path, handler);
        Members members = handler.getMembers();

        if (members != null) {
          convertCharactorToMemberInfo(members.getCharactor());
        }
      } catch (Exception ex) {
        throw new ServletException(ex);
      }
    } else {
      throw new ServletException(
        "Can't find initialization parameter \"ls.memberFile\".");
    }
  }

  /**
   * SAXp[T̎擾
   *
   * @return SAXp[T
   *
   * @throws Exception
   */
  static SAXParser getSAXParser() throws Exception {
    SAXParserFactory spf = SAXParserFactory.newInstance();

    spf.setNamespaceAware(true);

    return spf.newSAXParser();
  }

  /**
   * LN^̔zoXgɕϊ
   *
   * @param charactors LN^̔z
   */
  private void convertCharactorToMemberInfo(Charactor[] charactors) {
    memberlist = new ArrayList();
    idmap = new HashMap();
    if (charactors != null) {
      for (int i = 0; i < charactors.length; i++) {
        MemberInfo member = new MemberInfo(charactors[i]);

        memberlist.add(member);
        idmap.put(member.getName(), member);
      }
    }

    return;
  }

  /**
   * oXgۑ
   *
   * @throws IOException
   */
  public void saveMembers() throws IOException {
    Members members = new Members();
    Iterator iterator = memberlist.iterator();

    while (iterator.hasNext()) {
      MemberInfo member = (MemberInfo)iterator.next();

      members.addCharactor(member.toCharactor());
    }

    FileOutputStream fos = new FileOutputStream(path);
    try {
			OutputStreamWriter osw = new OutputStreamWriter(fos, this.encode);
			osw.write("<?xml version=\"1.0\" encoding=\"" + this.encode
				+ "\"?>\n");
			members.makeTextElement(osw);
    } finally {
			fos.close();
    }
  }

  /**
   * oXg̎擾
   *
   * @return oXg
   */
  public List getMemberList() {
    return memberlist;
  }

  /**
   * o̓o^
   *
   * @param memberinfo o
   *
   * @throws Error
   */
  public void addMemberInfo(MemberInfo memberinfo) {
    //Charactor charactor = memberinfo.toCharactor();
    //members.addCharactor(charactor);
    if (checkContainsByName(memberinfo.getName())) {
      MemberInfo member = findMemberByName(memberinfo.getName());

      if (member.getNo() == memberinfo.getNo()) {
        memberlist.set(memberinfo.getNo() - 1, memberinfo);
      } else {
        throw new Error("łɓÕLN^[o^Ă܂B");
      }
    } else {
      //memberinfo.setPassword(memberinfo.getPassword());
      int no = memberinfo.getNo();

      if (no != 0) {
        memberlist.set(no - 1, memberinfo);
      } else {
        memberinfo.setNo(memberlist.size() + 1);
        memberlist.add(memberinfo);
      }

      idmap.put(memberinfo.getName(), memberinfo);
    }
  }

  /**
   * o𖼑O猟
   *
   * @param name LN^
   *
   * @return o
   */
  public MemberInfo findMemberByName(String name) {
    return (MemberInfo)idmap.get(name);
  }

  /**
   * oXgɎw肵ÕLN^v邩ǂ`FbN
   *
   * @param name LN^
   *
   * @return true: false Ȃ
   */
  public boolean checkContainsByName(String name) {
    return idmap.containsKey(name);
  }

  /**
   * DOCUMENT ME!
   *
   * @param no
   *
   * @see cx.ath.kgslab.lsmembers.MemberList#removeMember(cx.ath.kgslab.lsmembers.MemberInfo)
   */
  public void removeMember(MemberInfo member) {
    idmap.remove(member.getName());
    int idx = memberlist.indexOf(member);

    memberlist.remove(member);
    for (int i = idx; i < memberlist.size(); i++) {
      ((MemberInfo)memberlist.get(i)).setNo(i + 1);
    }
  }

  /**
   * @return
   */
  public String getMemberFile() {
    return memberFile;
  }

  /**
   * @param string
   */
  public void setMemberFile(String string) {
    memberFile = string;
  }

  /* ( Javadoc)
   * @see org.springframework.context.ApplicationContextAware#setApplicationContext(org.springframework.context.ApplicationContext)
   */
  public void setApplicationContext(ApplicationContext context)
        throws BeansException {
    this.context = (WebApplicationContext)context;
  }
}
