package cx.ath.kgslab.lsmembers.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;


/**
 * <b>Charactor</b> is generated from LsMembers.rng by Relaxer.
 * This class is derived from:
 *
 * <!-- for programmer
 * <element name="charactor">
 *   <attribute name="no">
 *     <data type="int"/>
 *   </attribute>
 *   <group>
 *     <element name="name">
 *       <text/>
 *     </element>
 *     <element name="title">
 *       <text/>
 *     </element>
 *     <element name="password">
 *       <text/>
 *     </element>
 *     <element name="race">
 *       <choice>
 *         <value>hum</value>
 *         <value>elv</value>
 *         <value>tar</value>
 *         <value>mit</value>
 *         <value>gal</value>
 *       </choice>
 *     </element>
 *     <element name="gender">
 *       <choice>
 *         <value>male</value>
 *         <value>female</value>
 *       </choice>
 *     </element>
 *     <element name="face">
 *       <data type="int"/>
 *     </element>
 *     <element name="realm">
 *       <choice>
 *         <value>snd</value>
 *         <value>bas</value>
 *         <value>win</value>
 *       </choice>
 *     </element>
 *     <element name="rank">
 *       <data type="int"/>
 *     </element>
 *     <ref name="jobs"/>
 *     <ref name="skills"/>
 *     <element name="comment">
 *       <text/>
 *     </element>
 *   </group>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="charactor"&gt;
 *   &lt;attribute name="no"&gt;
 *     &lt;data type="int"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;group&gt;
 *     &lt;element name="name"&gt;
 *       &lt;text/&gt;
 *     &lt;/element&gt;
 *     &lt;element name="title"&gt;
 *       &lt;text/&gt;
 *     &lt;/element&gt;
 *     &lt;element name="password"&gt;
 *       &lt;text/&gt;
 *     &lt;/element&gt;
 *     &lt;element name="race"&gt;
 *       &lt;choice&gt;
 *         &lt;value&gt;hum&lt;/value&gt;
 *         &lt;value&gt;elv&lt;/value&gt;
 *         &lt;value&gt;tar&lt;/value&gt;
 *         &lt;value&gt;mit&lt;/value&gt;
 *         &lt;value&gt;gal&lt;/value&gt;
 *       &lt;/choice&gt;
 *     &lt;/element&gt;
 *     &lt;element name="gender"&gt;
 *       &lt;choice&gt;
 *         &lt;value&gt;male&lt;/value&gt;
 *         &lt;value&gt;female&lt;/value&gt;
 *       &lt;/choice&gt;
 *     &lt;/element&gt;
 *     &lt;element name="face"&gt;
 *       &lt;data type="int"/&gt;
 *     &lt;/element&gt;
 *     &lt;element name="realm"&gt;
 *       &lt;choice&gt;
 *         &lt;value&gt;snd&lt;/value&gt;
 *         &lt;value&gt;bas&lt;/value&gt;
 *         &lt;value&gt;win&lt;/value&gt;
 *       &lt;/choice&gt;
 *     &lt;/element&gt;
 *     &lt;element name="rank"&gt;
 *       &lt;data type="int"/&gt;
 *     &lt;/element&gt;
 *     &lt;ref name="jobs"/&gt;
 *     &lt;ref name="skills"/&gt;
 *     &lt;element name="comment"&gt;
 *       &lt;text/&gt;
 *     &lt;/element&gt;
 *   &lt;/group&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version LsMembers.rng (Sun Oct 26 02:34:09 JST 2003)
 * @author  Relaxer 1.0rc3 (http://www.relaxer.org)
 */
public class Charactor implements java.io.Serializable, Cloneable,
  IRNSContainer, IRContentClassHandler, IRNode {
  /** DOCUMENT ME! */
  private RNSContext rNSContext_ =
    new RNSContext(this,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

  /** DOCUMENT ME! */
  private int no_;

  /** DOCUMENT ME! */
  private String name_;

  /** DOCUMENT ME! */
  private String title_;

  /** DOCUMENT ME! */
  private String password_;

  /** DOCUMENT ME! */
  private String race_;

  /** DOCUMENT ME! */
  private String gender_;

  /** DOCUMENT ME! */
  private int face_;

  /** DOCUMENT ME! */
  private String realm_;

  /** DOCUMENT ME! */
  private int rank_;

  /** DOCUMENT ME! */
  private Jobs jobs_;

  /** DOCUMENT ME! */
  private Skills skills_;

  /** DOCUMENT ME! */
  private String comment_;

  /** DOCUMENT ME! */
  private StringBuffer saxBuffer_;

  /** DOCUMENT ME! */
  private IRNode parentRNode_;

  /**
   * Creates a <code>Charactor</code>.
   *
   */
  public Charactor() {
    name_ = "";
    title_ = "";
    password_ = "";
    race_ = "";
    gender_ = "";
    realm_ = "";
    comment_ = "";
  }

  /**
   * Creates a <code>Charactor</code>.
   *
   * @param source
   */
  public Charactor(Charactor source) {
    setup(source);
  }

  /**
   * Creates a <code>Charactor</code> by the Stack <code>stack</code>
   * that contains Elements.
   * This constructor is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   */
  public Charactor(RStack stack) {
    setup(stack);
  }

  /**
   * Creates a <code>Charactor</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public Charactor(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Creates a <code>Charactor</code> by the Element <code>element</code>.
   *
   * @param element
   */
  public Charactor(Element element) {
    setup(element);
  }

  /**
   * Creates a <code>Charactor</code> by the File <code>file</code>.
   *
   * @param file
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Charactor(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file);
  }

  /**
   * Creates a <code>Charactor</code>
   * by the String representation of URI <code>uri</code>.
   *
   * @param uri
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Charactor(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(uri);
  }

  /**
   * Creates a <code>Charactor</code> by the URL <code>url</code>.
   *
   * @param url
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Charactor(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(url);
  }

  /**
   * Creates a <code>Charactor</code> by the InputStream <code>in</code>.
   *
   * @param in
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Charactor(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(in);
  }

  /**
   * Creates a <code>Charactor</code> by the InputSource <code>is</code>.
   *
   * @param is
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Charactor(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(is);
  }

  /**
   * Creates a <code>Charactor</code> by the Reader <code>reader</code>.
   *
   * @param reader
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Charactor(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(reader);
  }

  /**
   * Initializes the <code>Charactor</code> by the Charactor <code>source</code>.
   *
   * @param source
   */
  public void setup(Charactor source) {
    int size;

    setNo(source.getNo());
    setName(source.getName());
    setTitle(source.getTitle());
    setPassword(source.getPassword());
    setRace(source.getRace());
    setGender(source.getGender());
    setFace(source.getFace());
    setRealm(source.getRealm());
    setRank(source.getRank());
    setJobs((Jobs)source.getJobs().clone());
    setSkills((Skills)source.getSkills().clone());
    setComment(source.getComment());
  }

  /**
   * Initializes the <code>Charactor</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public void setup(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Initializes the <code>Charactor</code> by the Element <code>element</code>.
   *
   * @param element
   */
  public void setup(Element element) {
    init(element);
  }

  /**
   * Initializes the <code>Charactor</code> by the Stack <code>stack</code>
   * that contains Elements.
   * This constructor is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   */
  public void setup(RStack stack) {
    init(stack.popElement());
  }

  /**
   * @param element
   */
  private void init(Element element) {
    RStack stack = new RStack(element);

    rNSContext_.declareNamespace(element);
    no_ = URelaxer.getAttributePropertyAsInt(element, "no");
    name_ = URelaxer.getElementPropertyAsString(stack.popElement());
    title_ = URelaxer.getElementPropertyAsString(stack.popElement());
    password_ =
      URelaxer.getElementPropertyAsString(stack.popElement());
    race_ = URelaxer.getElementPropertyAsString(stack.popElement());
    gender_ = URelaxer.getElementPropertyAsString(stack.popElement());
    face_ = URelaxer.getElementPropertyAsInt(stack.popElement());
    realm_ = URelaxer.getElementPropertyAsString(stack.popElement());
    rank_ = URelaxer.getElementPropertyAsInt(stack.popElement());
    setJobs(new Jobs(stack));
    setSkills(new Skills(stack));
    comment_ =
      URelaxer.getElementPropertyAsString(stack.popElement());
  }

  /**
   * @return Object
   */
  public Object clone() {
    return (new Charactor(this));
  }

  /**
   * Creates a DOM representation of the object.
   * Result is appended to the Node <code>parent</code>.
   *
   * @param parent
   */
  public void makeElement(Node parent) {
    Document doc;

    if (parent instanceof Document) {
      doc = (Document)parent;
    } else {
      doc = parent.getOwnerDocument();
    }

    Element element =
      doc.createElementNS("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
        "charactor");

    rNSContext_.setupNamespace(element);
    int size;

    URelaxer.setAttributePropertyByInt(element, "no", this.no_);
    URelaxer2.setElementPropertyByString(element,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "name",
      this.name_, rNSContext_);
    URelaxer2.setElementPropertyByString(element,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "title",
      this.title_, rNSContext_);
    URelaxer2.setElementPropertyByString(element,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "password",
      this.password_, rNSContext_);
    URelaxer2.setElementPropertyByString(element,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "race",
      this.race_, rNSContext_);
    URelaxer2.setElementPropertyByString(element,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "gender",
      this.gender_, rNSContext_);
    URelaxer2.setElementPropertyByInt(element,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "face",
      this.face_, rNSContext_);
    URelaxer2.setElementPropertyByString(element,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "realm",
      this.realm_, rNSContext_);
    URelaxer2.setElementPropertyByInt(element,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "rank",
      this.rank_, rNSContext_);
    this.jobs_.makeElement(element);
    this.skills_.makeElement(element);
    URelaxer2.setElementPropertyByString(element,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "comment",
      this.comment_, rNSContext_);
    parent.appendChild(element);
  }

  /**
   * Initializes the <code>Charactor</code> by the File <code>file</code>.
   *
   * @param file
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file.toURL());
  }

  /**
   * Initializes the <code>Charactor</code>
   * by the String representation of URI <code>uri</code>.
   *
   * @param uri
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Charactor</code> by the URL <code>url</code>.
   *
   * @param url
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Charactor</code> by the InputStream <code>in</code>.
   *
   * @param in
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Charactor</code> by the InputSource <code>is</code>.
   *
   * @param is
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Charactor</code> by the Reader <code>reader</code>.
   *
   * @param reader
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Creates a DOM document representation of the object.
   *
   * @exception ParserConfigurationException
   * @return Document
   */
  public Document makeDocument() throws ParserConfigurationException {
    Document doc = UJAXP.makeDocument();

    makeElement(doc);

    return (doc);
  }

  /**
   * Gets the RNSContext property <b>RNSContext</b>.
   *
   * @return RNSContext
   */
  public final RNSContext rGetRNSContext() {
    return (rNSContext_);
  }

  /**
   * Sets the RNSContext property <b>RNSContext</b>.
   *
   * @param rNSContext
   */
  public final void rSetRNSContext(RNSContext rNSContext) {
    this.rNSContext_ = rNSContext;
  }

  /**
   * Gets the int property <b>no</b>.
   *
   * @return int
   */
  public final int getNo() {
    return (no_);
  }

  /**
   * Sets the int property <b>no</b>.
   *
   * @param no
   */
  public final void setNo(int no) {
    this.no_ = no;
  }

  /**
   * Gets the String property <b>name</b>.
   *
   * @return String
   */
  public final String getName() {
    return (name_);
  }

  /**
   * Sets the String property <b>name</b>.
   *
   * @param name
   */
  public final void setName(String name) {
    this.name_ = name;
  }

  /**
   * Gets the String property <b>title</b>.
   *
   * @return String
   */
  public final String getTitle() {
    return (title_);
  }

  /**
   * Sets the String property <b>title</b>.
   *
   * @param title
   */
  public final void setTitle(String title) {
    this.title_ = title;
  }

  /**
   * Gets the String property <b>password</b>.
   *
   * @return String
   */
  public final String getPassword() {
    return (password_);
  }

  /**
   * Sets the String property <b>password</b>.
   *
   * @param password
   */
  public final void setPassword(String password) {
    this.password_ = password;
  }

  /**
   * Gets the String property <b>race</b>.
   *
   * @return String
   */
  public final String getRace() {
    return (race_);
  }

  /**
   * Sets the String property <b>race</b>.
   *
   * @param race
   */
  public final void setRace(String race) {
    this.race_ = race;
  }

  /**
   * Gets the String property <b>gender</b>.
   *
   * @return String
   */
  public final String getGender() {
    return (gender_);
  }

  /**
   * Sets the String property <b>gender</b>.
   *
   * @param gender
   */
  public final void setGender(String gender) {
    this.gender_ = gender;
  }

  /**
   * Gets the int property <b>face</b>.
   *
   * @return int
   */
  public final int getFace() {
    return (face_);
  }

  /**
   * Sets the int property <b>face</b>.
   *
   * @param face
   */
  public final void setFace(int face) {
    this.face_ = face;
  }

  /**
   * Gets the String property <b>realm</b>.
   *
   * @return String
   */
  public final String getRealm() {
    return (realm_);
  }

  /**
   * Sets the String property <b>realm</b>.
   *
   * @param realm
   */
  public final void setRealm(String realm) {
    this.realm_ = realm;
  }

  /**
   * Gets the int property <b>rank</b>.
   *
   * @return int
   */
  public final int getRank() {
    return (rank_);
  }

  /**
   * Sets the int property <b>rank</b>.
   *
   * @param rank
   */
  public final void setRank(int rank) {
    this.rank_ = rank;
  }

  /**
   * Gets the Jobs property <b>jobs</b>.
   *
   * @return Jobs
   */
  public final Jobs getJobs() {
    return (jobs_);
  }

  /**
   * Sets the Jobs property <b>jobs</b>.
   *
   * @param jobs
   */
  public final void setJobs(Jobs jobs) {
    this.jobs_ = jobs;
    if (jobs != null) {
      jobs.rSetParentRNode(this);
    }
  }

  /**
   * Gets the Skills property <b>skills</b>.
   *
   * @return Skills
   */
  public final Skills getSkills() {
    return (skills_);
  }

  /**
   * Sets the Skills property <b>skills</b>.
   *
   * @param skills
   */
  public final void setSkills(Skills skills) {
    this.skills_ = skills;
    if (skills != null) {
      skills.rSetParentRNode(this);
    }
  }

  /**
   * Gets the String property <b>comment</b>.
   *
   * @return String
   */
  public final String getComment() {
    return (comment_);
  }

  /**
   * Sets the String property <b>comment</b>.
   *
   * @param comment
   */
  public final void setComment(String comment) {
    this.comment_ = comment;
  }

  /**
   * Makes an XML text representation.
   *
   * @return String
   */
  public String makeTextDocument() {
    StringBuffer buffer = new StringBuffer();

    makeTextElement(buffer);

    return (new String(buffer));
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(StringBuffer buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.append("<");
    URelaxer.makeQName(prefix, "charactor", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.append(" ");
    buffer.append("no");
    buffer.append("=\"");
    buffer.append(URelaxer.getString(getNo()));
    buffer.append("\"");
    buffer.append(">");
    buffer.append("<");
    URelaxer.makeQName(prefix, "name", buffer);
    buffer.append(">");
    buffer.append(URelaxer.escapeCharData(URelaxer.getString(
          getName())));
    buffer.append("</");
    URelaxer.makeQName(prefix, "name", buffer);
    buffer.append(">");
    buffer.append("<");
    URelaxer.makeQName(prefix, "title", buffer);
    buffer.append(">");
    buffer.append(URelaxer.escapeCharData(URelaxer.getString(
          getTitle())));
    buffer.append("</");
    URelaxer.makeQName(prefix, "title", buffer);
    buffer.append(">");
    buffer.append("<");
    URelaxer.makeQName(prefix, "password", buffer);
    buffer.append(">");
    buffer.append(URelaxer.escapeCharData(URelaxer.getString(
          getPassword())));
    buffer.append("</");
    URelaxer.makeQName(prefix, "password", buffer);
    buffer.append(">");
    buffer.append("<");
    URelaxer.makeQName(prefix, "race", buffer);
    buffer.append(">");
    buffer.append(URelaxer.escapeCharData(URelaxer.getString(
          getRace())));
    buffer.append("</");
    URelaxer.makeQName(prefix, "race", buffer);
    buffer.append(">");
    buffer.append("<");
    URelaxer.makeQName(prefix, "gender", buffer);
    buffer.append(">");
    buffer.append(URelaxer.escapeCharData(URelaxer.getString(
          getGender())));
    buffer.append("</");
    URelaxer.makeQName(prefix, "gender", buffer);
    buffer.append(">");
    buffer.append("<");
    URelaxer.makeQName(prefix, "face", buffer);
    buffer.append(">");
    buffer.append(URelaxer.getString(getFace()));
    buffer.append("</");
    URelaxer.makeQName(prefix, "face", buffer);
    buffer.append(">");
    buffer.append("<");
    URelaxer.makeQName(prefix, "realm", buffer);
    buffer.append(">");
    buffer.append(URelaxer.escapeCharData(URelaxer.getString(
          getRealm())));
    buffer.append("</");
    URelaxer.makeQName(prefix, "realm", buffer);
    buffer.append(">");
    buffer.append("<");
    URelaxer.makeQName(prefix, "rank", buffer);
    buffer.append(">");
    buffer.append(URelaxer.getString(getRank()));
    buffer.append("</");
    URelaxer.makeQName(prefix, "rank", buffer);
    buffer.append(">");
    jobs_.makeTextElement(buffer);
    skills_.makeTextElement(buffer);
    buffer.append("<");
    URelaxer.makeQName(prefix, "comment", buffer);
    buffer.append(">");
    buffer.append(URelaxer.escapeCharData(URelaxer.getString(
          getComment())));
    buffer.append("</");
    URelaxer.makeQName(prefix, "comment", buffer);
    buffer.append(">");
    buffer.append("</");
    URelaxer.makeQName(prefix, "charactor", buffer);
    buffer.append(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   * @exception IOException
   */
  public void makeTextElement(Writer buffer) throws IOException {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.write("<");
    URelaxer.makeQName(prefix, "charactor", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.write(" ");
    buffer.write("no");
    buffer.write("=\"");
    buffer.write(URelaxer.getString(getNo()));
    buffer.write("\"");
    buffer.write(">");
    buffer.write("<");
    URelaxer.makeQName(prefix, "name", buffer);
    buffer.write(">");
    buffer.write(URelaxer.escapeCharData(URelaxer.getString(getName())));
    buffer.write("</");
    URelaxer.makeQName(prefix, "name", buffer);
    buffer.write(">");
    buffer.write("<");
    URelaxer.makeQName(prefix, "title", buffer);
    buffer.write(">");
    buffer.write(URelaxer.escapeCharData(URelaxer.getString(
          getTitle())));
    buffer.write("</");
    URelaxer.makeQName(prefix, "title", buffer);
    buffer.write(">");
    buffer.write("<");
    URelaxer.makeQName(prefix, "password", buffer);
    buffer.write(">");
    buffer.write(URelaxer.escapeCharData(URelaxer.getString(
          getPassword())));
    buffer.write("</");
    URelaxer.makeQName(prefix, "password", buffer);
    buffer.write(">");
    buffer.write("<");
    URelaxer.makeQName(prefix, "race", buffer);
    buffer.write(">");
    buffer.write(URelaxer.escapeCharData(URelaxer.getString(getRace())));
    buffer.write("</");
    URelaxer.makeQName(prefix, "race", buffer);
    buffer.write(">");
    buffer.write("<");
    URelaxer.makeQName(prefix, "gender", buffer);
    buffer.write(">");
    buffer.write(URelaxer.escapeCharData(URelaxer.getString(
          getGender())));
    buffer.write("</");
    URelaxer.makeQName(prefix, "gender", buffer);
    buffer.write(">");
    buffer.write("<");
    URelaxer.makeQName(prefix, "face", buffer);
    buffer.write(">");
    buffer.write(URelaxer.getString(getFace()));
    buffer.write("</");
    URelaxer.makeQName(prefix, "face", buffer);
    buffer.write(">");
    buffer.write("<");
    URelaxer.makeQName(prefix, "realm", buffer);
    buffer.write(">");
    buffer.write(URelaxer.escapeCharData(URelaxer.getString(
          getRealm())));
    buffer.write("</");
    URelaxer.makeQName(prefix, "realm", buffer);
    buffer.write(">");
    buffer.write("<");
    URelaxer.makeQName(prefix, "rank", buffer);
    buffer.write(">");
    buffer.write(URelaxer.getString(getRank()));
    buffer.write("</");
    URelaxer.makeQName(prefix, "rank", buffer);
    buffer.write(">");
    jobs_.makeTextElement(buffer);
    skills_.makeTextElement(buffer);
    buffer.write("<");
    URelaxer.makeQName(prefix, "comment", buffer);
    buffer.write(">");
    buffer.write(URelaxer.escapeCharData(URelaxer.getString(
          getComment())));
    buffer.write("</");
    URelaxer.makeQName(prefix, "comment", buffer);
    buffer.write(">");
    buffer.write("</");
    URelaxer.makeQName(prefix, "charactor", buffer);
    buffer.write(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(PrintWriter buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.print("<");
    URelaxer.makeQName(prefix, "charactor", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.print(" ");
    buffer.print("no");
    buffer.print("=\"");
    buffer.print(URelaxer.getString(getNo()));
    buffer.print("\"");
    buffer.print(">");
    buffer.print("<");
    URelaxer.makeQName(prefix, "name", buffer);
    buffer.print(">");
    buffer.print(URelaxer.escapeCharData(URelaxer.getString(getName())));
    buffer.print("</");
    URelaxer.makeQName(prefix, "name", buffer);
    buffer.print(">");
    buffer.print("<");
    URelaxer.makeQName(prefix, "title", buffer);
    buffer.print(">");
    buffer.print(URelaxer.escapeCharData(URelaxer.getString(
          getTitle())));
    buffer.print("</");
    URelaxer.makeQName(prefix, "title", buffer);
    buffer.print(">");
    buffer.print("<");
    URelaxer.makeQName(prefix, "password", buffer);
    buffer.print(">");
    buffer.print(URelaxer.escapeCharData(URelaxer.getString(
          getPassword())));
    buffer.print("</");
    URelaxer.makeQName(prefix, "password", buffer);
    buffer.print(">");
    buffer.print("<");
    URelaxer.makeQName(prefix, "race", buffer);
    buffer.print(">");
    buffer.print(URelaxer.escapeCharData(URelaxer.getString(getRace())));
    buffer.print("</");
    URelaxer.makeQName(prefix, "race", buffer);
    buffer.print(">");
    buffer.print("<");
    URelaxer.makeQName(prefix, "gender", buffer);
    buffer.print(">");
    buffer.print(URelaxer.escapeCharData(URelaxer.getString(
          getGender())));
    buffer.print("</");
    URelaxer.makeQName(prefix, "gender", buffer);
    buffer.print(">");
    buffer.print("<");
    URelaxer.makeQName(prefix, "face", buffer);
    buffer.print(">");
    buffer.print(URelaxer.getString(getFace()));
    buffer.print("</");
    URelaxer.makeQName(prefix, "face", buffer);
    buffer.print(">");
    buffer.print("<");
    URelaxer.makeQName(prefix, "realm", buffer);
    buffer.print(">");
    buffer.print(URelaxer.escapeCharData(URelaxer.getString(
          getRealm())));
    buffer.print("</");
    URelaxer.makeQName(prefix, "realm", buffer);
    buffer.print(">");
    buffer.print("<");
    URelaxer.makeQName(prefix, "rank", buffer);
    buffer.print(">");
    buffer.print(URelaxer.getString(getRank()));
    buffer.print("</");
    URelaxer.makeQName(prefix, "rank", buffer);
    buffer.print(">");
    jobs_.makeTextElement(buffer);
    skills_.makeTextElement(buffer);
    buffer.print("<");
    URelaxer.makeQName(prefix, "comment", buffer);
    buffer.print(">");
    buffer.print(URelaxer.escapeCharData(URelaxer.getString(
          getComment())));
    buffer.print("</");
    URelaxer.makeQName(prefix, "comment", buffer);
    buffer.print(">");
    buffer.print("</");
    URelaxer.makeQName(prefix, "charactor", buffer);
    buffer.print(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(StringBuffer buffer) {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   * @exception IOException
   */
  public void makeTextAttribute(Writer buffer) throws IOException {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(PrintWriter buffer) {
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getNoAsString() {
    return (URelaxer.getString(getNo()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getNameAsString() {
    return (URelaxer.getString(getName()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getTitleAsString() {
    return (URelaxer.getString(getTitle()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getPasswordAsString() {
    return (URelaxer.getString(getPassword()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getRaceAsString() {
    return (URelaxer.getString(getRace()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getGenderAsString() {
    return (URelaxer.getString(getGender()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getFaceAsString() {
    return (URelaxer.getString(getFace()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getRealmAsString() {
    return (URelaxer.getString(getRealm()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getRankAsString() {
    return (URelaxer.getString(getRank()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getCommentAsString() {
    return (URelaxer.getString(getComment()));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setNoByString(String string) {
    setNo(Integer.parseInt(string));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setNameByString(String string) {
    setName(string);
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setTitleByString(String string) {
    setTitle(string);
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setPasswordByString(String string) {
    setPassword(string);
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setRaceByString(String string) {
    setRace(string);
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setGenderByString(String string) {
    setGender(string);
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setFaceByString(String string) {
    setFace(Integer.parseInt(string));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setRealmByString(String string) {
    setRealm(string);
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setRankByString(String string) {
    setRank(Integer.parseInt(string));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setCommentByString(String string) {
    setComment(string);
  }

  /**
   * Returns a String representation of this object.
   * While this method informs as XML format representaion,
   *  it's purpose is just information, not making
   * a rigid XML documentation.
   *
   * @return String
   */
  public String toString() {
    try {
      return (makeTextDocument());
    } catch (Exception e) {
      return (super.toString());
    }
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   * @exception SAXException
   */
  public void makeDocument(ContentHandler handler)
        throws SAXException {
    handler.startDocument();
    makeElement(handler);
    handler.endDocument();
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   * @exception SAXException
   */
  public void makeElement(ContentHandler handler) throws SAXException {
    rNSContext_.startNSMappings(handler);
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");
    int size;
    String string;
    String slotQName;
    AttributesImpl nullAttrs = new AttributesImpl();
    AttributesImpl attrs = new AttributesImpl();

    attrs.addAttribute("", "no", "no", "CDATA",
      URelaxer.getString(getNo()));
    String qName = URelaxer.getQName(prefix, "charactor");

    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "charactor", qName, attrs);
    slotQName = URelaxer.getQName(prefix, "name");
    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "name", slotQName, nullAttrs);
    string = URelaxer.getString(getName());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "name", slotQName);
    slotQName = URelaxer.getQName(prefix, "title");
    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "title", slotQName, nullAttrs);
    string = URelaxer.getString(getTitle());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "title", slotQName);
    slotQName = URelaxer.getQName(prefix, "password");
    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "password", slotQName, nullAttrs);
    string = URelaxer.getString(getPassword());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "password", slotQName);
    slotQName = URelaxer.getQName(prefix, "race");
    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "race", slotQName, nullAttrs);
    string = URelaxer.getString(getRace());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "race", slotQName);
    slotQName = URelaxer.getQName(prefix, "gender");
    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "gender", slotQName, nullAttrs);
    string = URelaxer.getString(getGender());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "gender", slotQName);
    slotQName = URelaxer.getQName(prefix, "face");
    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "face", slotQName, nullAttrs);
    string = URelaxer.getString(getFace());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "face", slotQName);
    slotQName = URelaxer.getQName(prefix, "realm");
    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "realm", slotQName, nullAttrs);
    string = URelaxer.getString(getRealm());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "realm", slotQName);
    slotQName = URelaxer.getQName(prefix, "rank");
    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "rank", slotQName, nullAttrs);
    string = URelaxer.getString(getRank());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "rank", slotQName);
    jobs_.makeElement(handler);
    skills_.makeElement(handler);
    slotQName = URelaxer.getQName(prefix, "comment");
    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "comment", slotQName, nullAttrs);
    string = URelaxer.getString(getComment());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "comment", slotQName);
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "charactor", qName);
    rNSContext_.endNSMappings(handler);
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param attrs
   * @exception SAXException
   */
  public void makeAttribute(AttributesImpl attrs) throws SAXException {
  }

  /**
   * Event handler for InitElement during object construction.
   *
   * @param attrs
   */
  public void initElement(Attributes attrs) {
    String string;

    string = attrs.getValue("no");
    setNo(Integer.parseInt(string));
  }

  /**
   * Event handler for declarePrefixMapping during object construction.
   *
   * @param prefix
   * @param uri
   */
  public void declarePrefixMapping(String prefix, String uri) {
    rNSContext_.declareNamespace(prefix, uri);
  }

  /**
   * Event handler for startElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @param attrs
   * @return IRContentClassHandler
   */
  public IRContentClassHandler startElement(String namespaceURI,
    String localName, String qName, Attributes attrs) {
    if ("name".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("title".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("password".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("race".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("gender".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("face".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("realm".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("rank".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("jobs".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      Jobs ref = new Jobs();

      ref.initElement(attrs);
      setJobs(ref);

      return (ref);
    }

    if ("skills".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      Skills ref = new Skills();

      ref.initElement(attrs);
      setSkills(ref);

      return (ref);
    }

    if ("comment".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    return (this);
  }

  /**
   * Event handler for endElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @return IRContentClassHandler
   */
  public IRContentClassHandler endElement(String namespaceURI,
    String localName, String qName) {
    String string;

    if ("name".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setName(string);

      return (this);
    }

    if ("title".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setTitle(string);

      return (this);
    }

    if ("password".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setPassword(string);

      return (this);
    }

    if ("race".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setRace(string);

      return (this);
    }

    if ("gender".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setGender(string);

      return (this);
    }

    if ("face".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setFace(Integer.parseInt(string));

      return (this);
    }

    if ("realm".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setRealm(string);

      return (this);
    }

    if ("rank".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setRank(Integer.parseInt(string));

      return (this);
    }

    if ("comment".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setComment(string);

      return (this);
    }

    return ((IRContentClassHandler)rGetParentRNode());
  }

  /**
   * Event handler for characters during object construction.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void characters(char[] ch, int start, int length) {
    if (saxBuffer_ != null) {
      saxBuffer_.append(ch, start, length);
    }
  }

  /**
   * Event handler for processngInstruction during object construction.
   *
   * @param target
   * @param value
   */
  public void processingInstruction(String target, String value) {
  }

  /**
   * Gets the IRNode property <b>parentRNode</b>.
   *
   * @return IRNode
   */
  public final IRNode rGetParentRNode() {
    return (parentRNode_);
  }

  /**
   * Sets the IRNode property <b>parentRNode</b>.
   *
   * @param parentRNode
   */
  public final void rSetParentRNode(IRNode parentRNode) {
    this.parentRNode_ = parentRNode;
  }

  /**
   * Gets child RNodes.
   *
   * @return IRNode[]
   */
  public IRNode[] rGetRNodes() {
    java.util.List classNodes = new java.util.ArrayList();

    if (jobs_ != null) {
      classNodes.add(jobs_);
    }

    if (skills_ != null) {
      classNodes.add(skills_);
    }

    IRNode[] nodes = new IRNode[classNodes.size()];

    return ((IRNode[])classNodes.toArray(nodes));
  }

  /**
   * Tests if a Element <code>element</code> is valid
   * for the <code>Charactor</code>.
   *
   * @param element
   * @return boolean
   */
  public static boolean isMatch(Element element) {
    if (!URelaxer2.isTargetElement(element,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
          "charactor")) {
      return (false);
    }

    RStack target = new RStack(element);
    boolean $match$ = false;
    Element child;

    if (!URelaxer.hasAttributeHungry(target, "no")) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();
    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "name")) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();
    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "title")) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();
    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
          "password")) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();
    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "race")) {
      return (false);
    }

    if (!URelaxer.isMatchDataValuesElement(element, "race", "token",
          new String[] {
            "hum",
            "elv",
            "tar",
            "mit",
            "gal"
          })) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();
    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "gender")) {
      return (false);
    }

    if (!URelaxer.isMatchDataValuesElement(element, "gender",
          "token", "male", "female")) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();
    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "face")) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();
    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "realm")) {
      return (false);
    }

    if (!URelaxer.isMatchDataValuesElement(element, "realm", "token",
          "snd", "bas", "win")) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();
    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "rank")) {
      return (false);
    }

    $match$ = true;
    if (!Jobs.isMatchHungry(target)) {
      return (false);
    }

    $match$ = true;
    if (!Skills.isMatchHungry(target)) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();
    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
          "comment")) {
      return (false);
    }

    $match$ = true;
    if (!target.isEmptyElement()) {
      return (false);
    }

    return (true);
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code>
   * is valid for the <code>Charactor</code>.
   * This mehtod is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   * @return boolean
   */
  public static boolean isMatch(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    return (isMatch(element));
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code>
   * is valid for the <code>Charactor</code>.
   * This method consumes the stack contents during matching operation.
   * This mehtod is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   * @return boolean
   */
  public static boolean isMatchHungry(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    if (isMatch(element)) {
      stack.popElement();

      return (true);
    } else {
      return (false);
    }
  }
}
