package cx.ath.kgslab.lsmembers.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;


/**
 * <b>Jobs</b> is generated from LsMembers.rng by Relaxer.
 * This class is derived from:
 *
 * <!-- for programmer
 * <element name="jobs">
 *   <attribute name="mainjob">
 *     <ref name="jobType"/>
 *   </attribute>
 *   <attribute name="supportjob">
 *     <ref name="jobType"/>
 *   </attribute>
 *   <oneOrMore>
 *     <ref name="job"/>
 *   </oneOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="jobs"&gt;
 *   &lt;attribute name="mainjob"&gt;
 *     &lt;ref name="jobType"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="supportjob"&gt;
 *     &lt;ref name="jobType"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;oneOrMore&gt;
 *     &lt;ref name="job"/&gt;
 *   &lt;/oneOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version LsMembers.rng (Sun Oct 26 02:34:09 JST 2003)
 * @author  Relaxer 1.0rc3 (http://www.relaxer.org)
 */
public class Jobs implements java.io.Serializable, Cloneable,
  IRNSContainer, IRContentClassHandler, IRNode {
  /** DOCUMENT ME! */
  private RNSContext rNSContext_ =
    new RNSContext(this,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

  /** DOCUMENT ME! */
  private String mainjob_;

  /** DOCUMENT ME! */
  private String supportjob_;

  // List<Job>

  /** DOCUMENT ME! */
  private java.util.List job_ = new java.util.ArrayList();

  /** DOCUMENT ME! */
  private StringBuffer saxBuffer_;

  /** DOCUMENT ME! */
  private IRNode parentRNode_;

  /**
   * Creates a <code>Jobs</code>.
   *
   */
  public Jobs() {
    mainjob_ = "";
    supportjob_ = "";
  }

  /**
   * Creates a <code>Jobs</code>.
   *
   * @param source
   */
  public Jobs(Jobs source) {
    setup(source);
  }

  /**
   * Creates a <code>Jobs</code> by the Stack <code>stack</code>
   * that contains Elements.
   * This constructor is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   */
  public Jobs(RStack stack) {
    setup(stack);
  }

  /**
   * Creates a <code>Jobs</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public Jobs(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Creates a <code>Jobs</code> by the Element <code>element</code>.
   *
   * @param element
   */
  public Jobs(Element element) {
    setup(element);
  }

  /**
   * Creates a <code>Jobs</code> by the File <code>file</code>.
   *
   * @param file
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Jobs(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file);
  }

  /**
   * Creates a <code>Jobs</code>
   * by the String representation of URI <code>uri</code>.
   *
   * @param uri
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Jobs(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(uri);
  }

  /**
   * Creates a <code>Jobs</code> by the URL <code>url</code>.
   *
   * @param url
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Jobs(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(url);
  }

  /**
   * Creates a <code>Jobs</code> by the InputStream <code>in</code>.
   *
   * @param in
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Jobs(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(in);
  }

  /**
   * Creates a <code>Jobs</code> by the InputSource <code>is</code>.
   *
   * @param is
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Jobs(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(is);
  }

  /**
   * Creates a <code>Jobs</code> by the Reader <code>reader</code>.
   *
   * @param reader
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Jobs(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(reader);
  }

  /**
   * Initializes the <code>Jobs</code> by the Jobs <code>source</code>.
   *
   * @param source
   */
  public void setup(Jobs source) {
    int size;

    setMainjob(source.getMainjob());
    setSupportjob(source.getSupportjob());
    this.job_.clear();
    size = source.job_.size();
    for (int i = 0; i < size; i++) {
      addJob((Job)source.getJob(i).clone());
    }
  }

  /**
   * Initializes the <code>Jobs</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public void setup(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Initializes the <code>Jobs</code> by the Element <code>element</code>.
   *
   * @param element
   */
  public void setup(Element element) {
    init(element);
  }

  /**
   * Initializes the <code>Jobs</code> by the Stack <code>stack</code>
   * that contains Elements.
   * This constructor is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   */
  public void setup(RStack stack) {
    init(stack.popElement());
  }

  /**
   * @param element
   */
  private void init(Element element) {
    RStack stack = new RStack(element);

    rNSContext_.declareNamespace(element);
    mainjob_ =
      URelaxer.getAttributePropertyAsString(element, "mainjob");
    supportjob_ =
      URelaxer.getAttributePropertyAsString(element, "supportjob");
    job_.clear();
    while (true) {
      if (Job.isMatch(stack)) {
        addJob(new Job(stack));
      } else {
        break;
      }
    }
  }

  /**
   * @return Object
   */
  public Object clone() {
    return (new Jobs(this));
  }

  /**
   * Creates a DOM representation of the object.
   * Result is appended to the Node <code>parent</code>.
   *
   * @param parent
   */
  public void makeElement(Node parent) {
    Document doc;

    if (parent instanceof Document) {
      doc = (Document)parent;
    } else {
      doc = parent.getOwnerDocument();
    }

    Element element =
      doc.createElementNS("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
        "jobs");

    rNSContext_.setupNamespace(element);
    int size;

    if (this.mainjob_ != null) {
      URelaxer.setAttributePropertyByString(element, "mainjob",
        this.mainjob_);
    }

    if (this.supportjob_ != null) {
      URelaxer.setAttributePropertyByString(element, "supportjob",
        this.supportjob_);
    }

    size = this.job_.size();
    for (int i = 0; i < size; i++) {
      Job value = (Job)this.job_.get(i);

      value.makeElement(element);
    }

    parent.appendChild(element);
  }

  /**
   * Initializes the <code>Jobs</code> by the File <code>file</code>.
   *
   * @param file
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file.toURL());
  }

  /**
   * Initializes the <code>Jobs</code>
   * by the String representation of URI <code>uri</code>.
   *
   * @param uri
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Jobs</code> by the URL <code>url</code>.
   *
   * @param url
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Jobs</code> by the InputStream <code>in</code>.
   *
   * @param in
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Jobs</code> by the InputSource <code>is</code>.
   *
   * @param is
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Jobs</code> by the Reader <code>reader</code>.
   *
   * @param reader
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Creates a DOM document representation of the object.
   *
   * @exception ParserConfigurationException
   * @return Document
   */
  public Document makeDocument() throws ParserConfigurationException {
    Document doc = UJAXP.makeDocument();

    makeElement(doc);

    return (doc);
  }

  /**
   * Gets the RNSContext property <b>RNSContext</b>.
   *
   * @return RNSContext
   */
  public final RNSContext rGetRNSContext() {
    return (rNSContext_);
  }

  /**
   * Sets the RNSContext property <b>RNSContext</b>.
   *
   * @param rNSContext
   */
  public final void rSetRNSContext(RNSContext rNSContext) {
    this.rNSContext_ = rNSContext;
  }

  /**
   * Gets the String property <b>mainjob</b>.
   *
   * @return String
   */
  public final String getMainjob() {
    return (mainjob_);
  }

  /**
   * Sets the String property <b>mainjob</b>.
   *
   * @param mainjob
   */
  public final void setMainjob(String mainjob) {
    this.mainjob_ = mainjob;
  }

  /**
   * Gets the String property <b>supportjob</b>.
   *
   * @return String
   */
  public final String getSupportjob() {
    return (supportjob_);
  }

  /**
   * Sets the String property <b>supportjob</b>.
   *
   * @param supportjob
   */
  public final void setSupportjob(String supportjob) {
    this.supportjob_ = supportjob;
  }

  /**
   * Gets the Job property <b>job</b>.
   *
   * @return Job[]
   */
  public final Job[] getJob() {
    Job[] array = new Job[job_.size()];

    return ((Job[])job_.toArray(array));
  }

  /**
   * Sets the Job property <b>job</b>.
   *
   * @param job
   */
  public final void setJob(Job[] job) {
    this.job_.clear();
    for (int i = 0; i < job.length; i++) {
      addJob(job[i]);
    }

    for (int i = 0; i < job.length; i++) {
      job[i].rSetParentRNode(this);
    }
  }

  /**
   * Sets the Job property <b>job</b>.
   *
   * @param job
   */
  public final void setJob(Job job) {
    this.job_.clear();
    addJob(job);
    if (job != null) {
      job.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Job property <b>job</b>.
   *
   * @param job
   */
  public final void addJob(Job job) {
    this.job_.add(job);
    if (job != null) {
      job.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Job property <b>job</b>.
   *
   * @param job
   */
  public final void addJob(Job[] job) {
    for (int i = 0; i < job.length; i++) {
      addJob(job[i]);
    }

    for (int i = 0; i < job.length; i++) {
      job[i].rSetParentRNode(this);
    }
  }

  /**
   * Gets number of the Job property <b>job</b>.
   *
   * @return int
   */
  public final int sizeJob() {
    return (job_.size());
  }

  /**
   * Gets the Job property <b>job</b> by index.
   *
   * @param index
   * @return Job
   */
  public final Job getJob(int index) {
    return ((Job)job_.get(index));
  }

  /**
   * Sets the Job property <b>job</b> by index.
   *
   * @param index
   * @param job
   */
  public final void setJob(int index, Job job) {
    this.job_.set(index, job);
    if (job != null) {
      job.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Job property <b>job</b> by index.
   *
   * @param index
   * @param job
   */
  public final void addJob(int index, Job job) {
    this.job_.add(index, job);
    if (job != null) {
      job.rSetParentRNode(this);
    }
  }

  /**
   * Remove the Job property <b>job</b> by index.
   *
   * @param index
   */
  public final void removeJob(int index) {
    this.job_.remove(index);
  }

  /**
   * Remove the Job property <b>job</b> by object.
   *
   * @param job
   */
  public final void removeJob(Job job) {
    this.job_.remove(job);
  }

  /**
   * Clear the Job property <b>job</b>.
   *
   */
  public final void clearJob() {
    this.job_.clear();
  }

  /**
   * Makes an XML text representation.
   *
   * @return String
   */
  public String makeTextDocument() {
    StringBuffer buffer = new StringBuffer();

    makeTextElement(buffer);

    return (new String(buffer));
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(StringBuffer buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.append("<");
    URelaxer.makeQName(prefix, "jobs", buffer);
    rNSContext_.makeNSMappings(buffer);
    if (mainjob_ != null) {
      buffer.append(" ");
      buffer.append("mainjob");
      buffer.append("=\"");
      buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(
            getMainjob())));
      buffer.append("\"");
    }

    if (supportjob_ != null) {
      buffer.append(" ");
      buffer.append("supportjob");
      buffer.append("=\"");
      buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(
            getSupportjob())));
      buffer.append("\"");
    }

    buffer.append(">");
    size = this.job_.size();
    for (int i = 0; i < size; i++) {
      Job value = (Job)this.job_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.append("</");
    URelaxer.makeQName(prefix, "jobs", buffer);
    buffer.append(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   * @exception IOException
   */
  public void makeTextElement(Writer buffer) throws IOException {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.write("<");
    URelaxer.makeQName(prefix, "jobs", buffer);
    rNSContext_.makeNSMappings(buffer);
    if (mainjob_ != null) {
      buffer.write(" ");
      buffer.write("mainjob");
      buffer.write("=\"");
      buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(
            getMainjob())));
      buffer.write("\"");
    }

    if (supportjob_ != null) {
      buffer.write(" ");
      buffer.write("supportjob");
      buffer.write("=\"");
      buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(
            getSupportjob())));
      buffer.write("\"");
    }

    buffer.write(">");
    size = this.job_.size();
    for (int i = 0; i < size; i++) {
      Job value = (Job)this.job_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.write("</");
    URelaxer.makeQName(prefix, "jobs", buffer);
    buffer.write(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(PrintWriter buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.print("<");
    URelaxer.makeQName(prefix, "jobs", buffer);
    rNSContext_.makeNSMappings(buffer);
    if (mainjob_ != null) {
      buffer.print(" ");
      buffer.print("mainjob");
      buffer.print("=\"");
      buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(
            getMainjob())));
      buffer.print("\"");
    }

    if (supportjob_ != null) {
      buffer.print(" ");
      buffer.print("supportjob");
      buffer.print("=\"");
      buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(
            getSupportjob())));
      buffer.print("\"");
    }

    buffer.print(">");
    size = this.job_.size();
    for (int i = 0; i < size; i++) {
      Job value = (Job)this.job_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.print("</");
    URelaxer.makeQName(prefix, "jobs", buffer);
    buffer.print(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(StringBuffer buffer) {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   * @exception IOException
   */
  public void makeTextAttribute(Writer buffer) throws IOException {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(PrintWriter buffer) {
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getMainjobAsString() {
    return (URelaxer.getString(getMainjob()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getSupportjobAsString() {
    return (URelaxer.getString(getSupportjob()));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setMainjobByString(String string) {
    setMainjob(string);
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setSupportjobByString(String string) {
    setSupportjob(string);
  }

  /**
   * Returns a String representation of this object.
   * While this method informs as XML format representaion,
   *  it's purpose is just information, not making
   * a rigid XML documentation.
   *
   * @return String
   */
  public String toString() {
    try {
      return (makeTextDocument());
    } catch (Exception e) {
      return (super.toString());
    }
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   * @exception SAXException
   */
  public void makeDocument(ContentHandler handler)
        throws SAXException {
    handler.startDocument();
    makeElement(handler);
    handler.endDocument();
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   * @exception SAXException
   */
  public void makeElement(ContentHandler handler) throws SAXException {
    rNSContext_.startNSMappings(handler);
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");
    int size;
    String string;
    String slotQName;
    AttributesImpl attrs = new AttributesImpl();

    attrs.addAttribute("", "mainjob", "mainjob", "CDATA",
      URelaxer.getString(getMainjob()));
    attrs.addAttribute("", "supportjob", "supportjob", "CDATA",
      URelaxer.getString(getSupportjob()));
    String qName = URelaxer.getQName(prefix, "jobs");

    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "jobs", qName, attrs);
    size = this.job_.size();
    for (int i = 0; i < size; i++) {
      Job value = (Job)this.job_.get(i);

      value.makeElement(handler);
    }

    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "jobs", qName);
    rNSContext_.endNSMappings(handler);
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param attrs
   * @exception SAXException
   */
  public void makeAttribute(AttributesImpl attrs) throws SAXException {
  }

  /**
   * Event handler for InitElement during object construction.
   *
   * @param attrs
   */
  public void initElement(Attributes attrs) {
    String string;

    string = attrs.getValue("mainjob");
    setMainjob(string);
    string = attrs.getValue("supportjob");
    setSupportjob(string);
  }

  /**
   * Event handler for declarePrefixMapping during object construction.
   *
   * @param prefix
   * @param uri
   */
  public void declarePrefixMapping(String prefix, String uri) {
    rNSContext_.declareNamespace(prefix, uri);
  }

  /**
   * Event handler for startElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @param attrs
   * @return IRContentClassHandler
   */
  public IRContentClassHandler startElement(String namespaceURI,
    String localName, String qName, Attributes attrs) {
    if ("job".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      Job ref = new Job();

      ref.initElement(attrs);
      addJob(ref);

      return (ref);
    }

    return (this);
  }

  /**
   * Event handler for endElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @return IRContentClassHandler
   */
  public IRContentClassHandler endElement(String namespaceURI,
    String localName, String qName) {
    String string;

    return ((IRContentClassHandler)rGetParentRNode());
  }

  /**
   * Event handler for characters during object construction.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void characters(char[] ch, int start, int length) {
    if (saxBuffer_ != null) {
      saxBuffer_.append(ch, start, length);
    }
  }

  /**
   * Event handler for processngInstruction during object construction.
   *
   * @param target
   * @param value
   */
  public void processingInstruction(String target, String value) {
  }

  /**
   * Gets the IRNode property <b>parentRNode</b>.
   *
   * @return IRNode
   */
  public final IRNode rGetParentRNode() {
    return (parentRNode_);
  }

  /**
   * Sets the IRNode property <b>parentRNode</b>.
   *
   * @param parentRNode
   */
  public final void rSetParentRNode(IRNode parentRNode) {
    this.parentRNode_ = parentRNode;
  }

  /**
   * Gets child RNodes.
   *
   * @return IRNode[]
   */
  public IRNode[] rGetRNodes() {
    java.util.List classNodes = new java.util.ArrayList();

    classNodes.addAll(job_);
    IRNode[] nodes = new IRNode[classNodes.size()];

    return ((IRNode[])classNodes.toArray(nodes));
  }

  /**
   * Tests if a Element <code>element</code> is valid
   * for the <code>Jobs</code>.
   *
   * @param element
   * @return boolean
   */
  public static boolean isMatch(Element element) {
    if (!URelaxer2.isTargetElement(element,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "jobs")) {
      return (false);
    }

    RStack target = new RStack(element);
    boolean $match$ = false;
    Element child;

    if (!URelaxer.hasAttributeHungry(target, "mainjob")) {
      return (false);
    }

    $match$ = true;
    if (!URelaxer.isMatchDataValuesAttr(element, "mainjob", "token",
          new String[] {
            "war",
            "mnk",
            "whm",
            "blm",
            "rdm",
            "thf",
            "pld",
            "drk",
            "rng",
            "brd",
            "bst",
            "drg",
            "smn",
            "nin",
            "sam"
          })) {
      return (false);
    }

    if (!URelaxer.hasAttributeHungry(target, "supportjob")) {
      return (false);
    }

    $match$ = true;
    if (!URelaxer.isMatchDataValuesAttr(element, "supportjob",
          "token",
          new String[] {
            "war",
            "mnk",
            "whm",
            "blm",
            "rdm",
            "thf",
            "pld",
            "drk",
            "rng",
            "brd",
            "bst",
            "drg",
            "smn",
            "nin",
            "sam"
          })) {
      return (false);
    }

    if (!Job.isMatchHungry(target)) {
      return (false);
    }

    $match$ = true;
    while (true) {
      if (!Job.isMatchHungry(target)) {
        break;
      }

      $match$ = true;
    }

    if (!target.isEmptyElement()) {
      return (false);
    }

    return (true);
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code>
   * is valid for the <code>Jobs</code>.
   * This mehtod is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   * @return boolean
   */
  public static boolean isMatch(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    return (isMatch(element));
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code>
   * is valid for the <code>Jobs</code>.
   * This method consumes the stack contents during matching operation.
   * This mehtod is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   * @return boolean
   */
  public static boolean isMatchHungry(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    if (isMatch(element)) {
      stack.popElement();

      return (true);
    } else {
      return (false);
    }
  }
}
