package cx.ath.kgslab.lsmembers.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;


/**
 * <b>Skill</b> is generated from LsMembers.rng by Relaxer.
 * This class is derived from:
 *
 * <!-- for programmer
 * <element name="skill">
 *   <attribute name="class">
 *     <ref name="skillType"/>
 *   </attribute>
 *   <data type="int"/>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="skill"&gt;
 *   &lt;attribute name="class"&gt;
 *     &lt;ref name="skillType"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;data type="int"/&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version LsMembers.rng (Sun Oct 26 02:34:09 JST 2003)
 * @author  Relaxer 1.0rc3 (http://www.relaxer.org)
 */
public class Skill implements java.io.Serializable, Cloneable,
  IRNSContainer, IRContentClassHandler, IRNode {
  /** DOCUMENT ME! */
  private RNSContext rNSContext_ =
    new RNSContext(this,
      "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

  /** DOCUMENT ME! */
  private int content_;

  /** DOCUMENT ME! */
  private String classValue_;

  /** DOCUMENT ME! */
  private StringBuffer saxBuffer_;

  /** DOCUMENT ME! */
  private IRNode parentRNode_;

  /**
   * Creates a <code>Skill</code>.
   *
   */
  public Skill() {
    classValue_ = "";
  }

  /**
   * Creates a <code>Skill</code>.
   *
   * @param source
   */
  public Skill(Skill source) {
    setup(source);
  }

  /**
   * Creates a <code>Skill</code> by the Stack <code>stack</code>
   * that contains Elements.
   * This constructor is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   */
  public Skill(RStack stack) {
    setup(stack);
  }

  /**
   * Creates a <code>Skill</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public Skill(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Creates a <code>Skill</code> by the Element <code>element</code>.
   *
   * @param element
   */
  public Skill(Element element) {
    setup(element);
  }

  /**
   * Creates a <code>Skill</code> by the File <code>file</code>.
   *
   * @param file
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skill(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file);
  }

  /**
   * Creates a <code>Skill</code>
   * by the String representation of URI <code>uri</code>.
   *
   * @param uri
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skill(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(uri);
  }

  /**
   * Creates a <code>Skill</code> by the URL <code>url</code>.
   *
   * @param url
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skill(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(url);
  }

  /**
   * Creates a <code>Skill</code> by the InputStream <code>in</code>.
   *
   * @param in
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skill(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(in);
  }

  /**
   * Creates a <code>Skill</code> by the InputSource <code>is</code>.
   *
   * @param is
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skill(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(is);
  }

  /**
   * Creates a <code>Skill</code> by the Reader <code>reader</code>.
   *
   * @param reader
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Skill(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(reader);
  }

  /**
   * Initializes the <code>Skill</code> by the Skill <code>source</code>.
   *
   * @param source
   */
  public void setup(Skill source) {
    int size;

    setContent(source.getContent());
    setClassValue(source.getClassValue());
  }

  /**
   * Initializes the <code>Skill</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public void setup(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Initializes the <code>Skill</code> by the Element <code>element</code>.
   *
   * @param element
   */
  public void setup(Element element) {
    init(element);
  }

  /**
   * Initializes the <code>Skill</code> by the Stack <code>stack</code>
   * that contains Elements.
   * This constructor is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   */
  public void setup(RStack stack) {
    init(stack.popElement());
  }

  /**
   * @param element
   */
  private void init(Element element) {
    RStack stack = new RStack(element);

    rNSContext_.declareNamespace(element);
    content_ = URelaxer.getElementPropertyAsInt(element);
    classValue_ =
      URelaxer.getAttributePropertyAsString(element, "class");
  }

  /**
   * @return Object
   */
  public Object clone() {
    return (new Skill(this));
  }

  /**
   * Creates a DOM representation of the object.
   * Result is appended to the Node <code>parent</code>.
   *
   * @param parent
   */
  public void makeElement(Node parent) {
    Document doc;

    if (parent instanceof Document) {
      doc = (Document)parent;
    } else {
      doc = parent.getOwnerDocument();
    }

    Element element =
      doc.createElementNS("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
        "skill");

    rNSContext_.setupNamespace(element);
    URelaxer.setElementPropertyByInt(element, this.content_);
    int size;

    if (this.classValue_ != null) {
      URelaxer.setAttributePropertyByString(element, "class",
        this.classValue_);
    }

    parent.appendChild(element);
  }

  /**
   * Initializes the <code>Skill</code> by the File <code>file</code>.
   *
   * @param file
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file.toURL());
  }

  /**
   * Initializes the <code>Skill</code>
   * by the String representation of URI <code>uri</code>.
   *
   * @param uri
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Skill</code> by the URL <code>url</code>.
   *
   * @param url
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Skill</code> by the InputStream <code>in</code>.
   *
   * @param in
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Skill</code> by the InputSource <code>is</code>.
   *
   * @param is
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Skill</code> by the Reader <code>reader</code>.
   *
   * @param reader
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Creates a DOM document representation of the object.
   *
   * @exception ParserConfigurationException
   * @return Document
   */
  public Document makeDocument() throws ParserConfigurationException {
    Document doc = UJAXP.makeDocument();

    makeElement(doc);

    return (doc);
  }

  /**
   * Gets the RNSContext property <b>RNSContext</b>.
   *
   * @return RNSContext
   */
  public final RNSContext rGetRNSContext() {
    return (rNSContext_);
  }

  /**
   * Sets the RNSContext property <b>RNSContext</b>.
   *
   * @param rNSContext
   */
  public final void rSetRNSContext(RNSContext rNSContext) {
    this.rNSContext_ = rNSContext;
  }

  /**
   * Gets the int property <b>content</b>.
   *
   * @return int
   */
  public final int getContent() {
    return (content_);
  }

  /**
   * Sets the int property <b>content</b>.
   *
   * @param content
   */
  public final void setContent(int content) {
    this.content_ = content;
  }

  /**
   * Gets the String property <b>classValue</b>.
   *
   * @return String
   */
  public final String getClassValue() {
    return (classValue_);
  }

  /**
   * Sets the String property <b>classValue</b>.
   *
   * @param classValue
   */
  public final void setClassValue(String classValue) {
    this.classValue_ = classValue;
  }

  /**
   * Makes an XML text representation.
   *
   * @return String
   */
  public String makeTextDocument() {
    StringBuffer buffer = new StringBuffer();

    makeTextElement(buffer);

    return (new String(buffer));
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(StringBuffer buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.append("<");
    URelaxer.makeQName(prefix, "skill", buffer);
    rNSContext_.makeNSMappings(buffer);
    if (classValue_ != null) {
      buffer.append(" ");
      buffer.append("class");
      buffer.append("=\"");
      buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(
            getClassValue())));
      buffer.append("\"");
    }

    buffer.append(">");
    buffer.append(URelaxer.getString(getContent()));
    buffer.append("</");
    URelaxer.makeQName(prefix, "skill", buffer);
    buffer.append(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   * @exception IOException
   */
  public void makeTextElement(Writer buffer) throws IOException {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.write("<");
    URelaxer.makeQName(prefix, "skill", buffer);
    rNSContext_.makeNSMappings(buffer);
    if (classValue_ != null) {
      buffer.write(" ");
      buffer.write("class");
      buffer.write("=\"");
      buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(
            getClassValue())));
      buffer.write("\"");
    }

    buffer.write(">");
    buffer.write(URelaxer.getString(getContent()));
    buffer.write("</");
    URelaxer.makeQName(prefix, "skill", buffer);
    buffer.write(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(PrintWriter buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");

    buffer.print("<");
    URelaxer.makeQName(prefix, "skill", buffer);
    rNSContext_.makeNSMappings(buffer);
    if (classValue_ != null) {
      buffer.print(" ");
      buffer.print("class");
      buffer.print("=\"");
      buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(
            getClassValue())));
      buffer.print("\"");
    }

    buffer.print(">");
    buffer.print(URelaxer.getString(getContent()));
    buffer.print("</");
    URelaxer.makeQName(prefix, "skill", buffer);
    buffer.print(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(StringBuffer buffer) {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   * @exception IOException
   */
  public void makeTextAttribute(Writer buffer) throws IOException {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(PrintWriter buffer) {
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getContentAsString() {
    return (URelaxer.getString(getContent()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getClassValueAsString() {
    return (URelaxer.getString(getClassValue()));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setContentByString(String string) {
    setContent(Integer.parseInt(string));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setClassValueByString(String string) {
    setClassValue(string);
  }

  /**
   * Returns a String representation of this object.
   * While this method informs as XML format representaion,
   *  it's purpose is just information, not making
   * a rigid XML documentation.
   *
   * @return String
   */
  public String toString() {
    try {
      return (makeTextDocument());
    } catch (Exception e) {
      return (super.toString());
    }
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   * @exception SAXException
   */
  public void makeDocument(ContentHandler handler)
        throws SAXException {
    handler.startDocument();
    makeElement(handler);
    handler.endDocument();
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   * @exception SAXException
   */
  public void makeElement(ContentHandler handler) throws SAXException {
    rNSContext_.startNSMappings(handler);
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0");
    int size;
    String string;
    String slotQName;
    AttributesImpl attrs = new AttributesImpl();

    attrs.addAttribute("", "class", "class", "CDATA",
      URelaxer.getString(getClassValue()));
    String qName = URelaxer.getQName(prefix, "skill");

    handler.startElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "skill", qName, attrs);
    string = URelaxer.getString(getContent());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0",
      "skill", qName);
    rNSContext_.endNSMappings(handler);
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param attrs
   * @exception SAXException
   */
  public void makeAttribute(AttributesImpl attrs) throws SAXException {
  }

  /**
   * Event handler for InitElement during object construction.
   *
   * @param attrs
   */
  public void initElement(Attributes attrs) {
    String string;

    saxBuffer_ = new StringBuffer();
    string = attrs.getValue("class");
    setClassValue(string);
  }

  /**
   * Event handler for declarePrefixMapping during object construction.
   *
   * @param prefix
   * @param uri
   */
  public void declarePrefixMapping(String prefix, String uri) {
    rNSContext_.declareNamespace(prefix, uri);
  }

  /**
   * Event handler for startElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @param attrs
   * @return IRContentClassHandler
   */
  public IRContentClassHandler startElement(String namespaceURI,
    String localName, String qName, Attributes attrs) {
    return (this);
  }

  /**
   * Event handler for endElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @return IRContentClassHandler
   */
  public IRContentClassHandler endElement(String namespaceURI,
    String localName, String qName) {
    String string;

    if ("skill".equals(localName)
        && "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0".equals(
          namespaceURI)) {
      string = new String(saxBuffer_);
      setContent(Integer.parseInt(string));
    }

    return ((IRContentClassHandler)rGetParentRNode());
  }

  /**
   * Event handler for characters during object construction.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void characters(char[] ch, int start, int length) {
    if (saxBuffer_ != null) {
      saxBuffer_.append(ch, start, length);
    }
  }

  /**
   * Event handler for processngInstruction during object construction.
   *
   * @param target
   * @param value
   */
  public void processingInstruction(String target, String value) {
  }

  /**
   * Gets the IRNode property <b>parentRNode</b>.
   *
   * @return IRNode
   */
  public final IRNode rGetParentRNode() {
    return (parentRNode_);
  }

  /**
   * Sets the IRNode property <b>parentRNode</b>.
   *
   * @param parentRNode
   */
  public final void rSetParentRNode(IRNode parentRNode) {
    this.parentRNode_ = parentRNode;
  }

  /**
   * Gets child RNodes.
   *
   * @return IRNode[]
   */
  public IRNode[] rGetRNodes() {
    java.util.List classNodes = new java.util.ArrayList();
    IRNode[] nodes = new IRNode[classNodes.size()];

    return ((IRNode[])classNodes.toArray(nodes));
  }

  /**
   * Tests if a Element <code>element</code> is valid
   * for the <code>Skill</code>.
   *
   * @param element
   * @return boolean
   */
  public static boolean isMatch(Element element) {
    if (!URelaxer2.isTargetElement(element,
          "http://www.kgslab.ath.cx/xml/ns/ffcharactors/1.0", "skill")) {
      return (false);
    }

    RStack target = new RStack(element);
    boolean $match$ = false;
    Element child;

    if (!URelaxer.hasAttributeHungry(target, "class")) {
      return (false);
    }

    $match$ = true;
    if (!URelaxer.isMatchDataValuesAttr(element, "class", "token",
          new String[] {
            "smithery",
            "clothing",
            "alchemy",
            "carpentry",
            "chasing",
            "skinwork",
            "bonework",
            "fishing",
            "cooking"
          })) {
      return (false);
    }

    if (!target.isEmptyElement()) {
      return (false);
    }

    return (true);
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code>
   * is valid for the <code>Skill</code>.
   * This mehtod is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   * @return boolean
   */
  public static boolean isMatch(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    return (isMatch(element));
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code>
   * is valid for the <code>Skill</code>.
   * This method consumes the stack contents during matching operation.
   * This mehtod is supposed to be used internally
   * by the Relaxer system.
   *
   * @param stack
   * @return boolean
   */
  public static boolean isMatchHungry(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    if (isMatch(element)) {
      stack.popElement();

      return (true);
    } else {
      return (false);
    }
  }
}
