/*
 * 쐬: 2004/04/28
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package cx.ath.kgslab.wiki.plugin;

import java.io.IOException;
import java.io.InputStream;

import java.net.MalformedURLException;
import java.net.URL;

import java.text.MessageFormat;

import java.util.Iterator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssDocument;

import churchillobjects.rss4j.parser.RssParseException;
import churchillobjects.rss4j.parser.RssParser;

import cx.ath.kgslab.wiki.plugin.exception.PluginException;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

import org.apache.commons.collections.iterators.EnumerationIterator;

import org.apache.oro.text.perl.Perl5Util;


/**
 * RSS/RDFo̓vOC
 * @author VM
 * @version 1.0 
 * @since JaJaWiki 4.0
 */
public class Rss extends PluginBase {
  /** DOCUMENT ME! */
  private static final String RSS = "RSS";

  /** DOCUMENT ME! */
  private static final String URL_MATCH =
    "#((?:https?|ftp)://[!~*'\\(\\);\\/?:\\@&=+\\$,%#\\w.-]+)#";

  /** DOCUMENT ME! */
  private MessageFormat LINK_FORMAT =
    new MessageFormat("<a href=\"{0}\">{1}</a>");

  /**
   * LbV}l[W
   */
  private CacheManager cacheManager = null;

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#toHTML()
   */
  public String toHTML() throws PluginException {
    Perl5Util util = new Perl5Util();

    if (util.match(URL_MATCH, this.params)) {
      try {
        URL url = new URL(this.params);
        InputStream is = url.openStream();
        RssDocument rss = RssParser.parseRss(is);

        is.close();
        String html = rss2Html(rss);
        Cache cache = getCache();

        if (cache != null) {
          cache.put(new Element(this.params, html));
        }

        return html;
      } catch (MalformedURLException e) {
        throw new PluginException("URI܂B", e);
      } catch (RssParseException e) {
        throw new PluginException("URIŎw肳ꂽ\[X́ARSSł͂܂B", e);
      } catch (IOException e) {
        throw new PluginException("URIŎw肳ꂽ\[XɁAANZXł܂B", e);
      }
    } else {
      throw new PluginException("URI܂B");
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   *
   * @throws IllegalStateException DOCUMENT ME!
   */
  private Cache getCache() throws IllegalStateException {
    Cache cache = null;

    try {
      cache = cacheManager.getCache(RSS);
      if (cache == null) {
        cache =
          new Cache(RSS, config.getCacheSize(), false, false, 0, 0);

        cacheManager.addCache(cache);
      }
    } catch (CacheException e) {
    }

    return cache;
  }

  /**
   * DOCUMENT ME!
   *
   * @param rss DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  private String rss2Html(RssDocument rss) {
    StringBuffer buffer = new StringBuffer();
    Iterator ite = new EnumerationIterator(rss.channels());

    while (ite.hasNext()) {
      buffer.append("<div>");
      RssChannel channel = (RssChannel)ite.next();
      String title = channel.getChannelTitle();
      String desc = channel.getChannelDescription();
      String copy = channel.getChannelCopyright();
      String link = channel.getChannelLink();

      buffer.append("[");
      buffer.append(LINK_FORMAT.format(new Object[] {
            link,
            title
          }));
      buffer.append("]\n<br/>");
      if ((desc != null) && (desc.length() > 0)) {
        buffer.append(desc);
      }

      buffer.append("<ul>");
      channel2Link(channel, buffer);
      buffer.append("</ul>\n");
      if ((copy != null) && (copy.length() > 0)) {
        buffer.append("<span class=\"size1\">");
        buffer.append(copy);
        buffer.append("</span>");
      }

      buffer.append("</div>");
    }

    return buffer.toString();
  }

  /**
   * DOCUMENT ME!
   *
   * @param channel DOCUMENT ME!
   * @param buffer DOCUMENT ME!
   */
  private void channel2Link(RssChannel channel, StringBuffer buffer) {
    Iterator ite2 = new EnumerationIterator(channel.items());

    while (ite2.hasNext()) {
      RssChannelItem item = (RssChannelItem)ite2.next();
      String title = item.getItemTitle();
      String link = item.getItemLink();
      String desc = item.getItemDescription();

      buffer.append("<li>");
      buffer.append(LINK_FORMAT.format(new Object[] {
            link,
            title
          }));
      if ((desc != null) && (desc.length() > 0)) {
        buffer.append(" - <span class=\"size2\">");
        buffer.append(desc);
        buffer.append("</span>");
      }

      buffer.append("</li>\n");
    }
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:RSS/RDF[_ \n" + " &amp;{0}(URL);\n"
    + "&#38;{0}LqƁA\n" + "w肳ꂽURLɂRSS/RDFHTMLɕϊĕ\܂B\n"
    + "-RSS/RDF[_vOĆAubNvfƂĈׂłB\n"
    + "-RSS/RDF[_vOĆA̗vf̎qvfɂȂ邱Ƃ͂ł܂B\n"
    + "-RSS/RDF[_vOĆA̗vfqvfɂ邱Ƃ͂ł܂B";
  }

  /**
   * @return
   */
  public CacheManager getCacheManager() {
    return cacheManager;
  }

  /**
   * @param manager
   */
  public void setCacheManager(CacheManager manager) {
    cacheManager = manager;
  }
}
