/*
 * $Id: RSSGenerator.java 291 2004-06-17 08:21:53Z nagasawa $
 */
package cx.ath.kgslab.wiki.rss;

import java.io.UnsupportedEncodingException;

import java.util.Date;
import java.util.Iterator;
import java.util.List;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssDocument;

import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGenerator;

import churchillobjects.rss4j.model.RssVersion;

import cx.ath.kgslab.util.DateUtils;
import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.PageChangeListener;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.rss.exception.RSSGenerateException;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

import org.springframework.beans.factory.InitializingBean;

/**
 * RSSNX.
 *
 * @author VM
 * @version 2.1 
 * @since JaJaWiki 3.0
 */
public class RSSGenerator implements PageChangeListener,
  InitializingBean {
  /** o[W0.91 */
  public static final String RSS_0_91 = RssVersion.VERSION_91;

  /** o[W1.0 */
  public static final String RSS_1_0 = RssVersion.VERSION_10;

  /** DOCUMENT ME! */
  protected static final String RSS = "RSS_OUT";

  /** `l^Cg */
  String title = null;

  /** 쌠\ */
  String copyright = null;

  /** ڍו */
  String description = null;

  /**  */
  String language = null;

  /** N */
  String link = null;

  /** URI */
  String uri = null;

  /** Web Master */
  String webmaster = null;

  /** y[W}l[W */
  PageManager pageManager = null;

  /**
   * LbV}l[W
   */
  private CacheManager cacheManager = null;

  /** DOCUMENT ME! */
  boolean pagesModified = true;

  /**
   * RXgN^.
   */
  public RSSGenerator() {
  }

  /**
   * nullBlankɕϊ
   *
   * @param src ϊ
   *
   * @return ϊʕ
   */
  private String nullToBlank(String src) {
    return (src != null) ? src.trim() : "";
  }

  /**
   * RSS.
   * <br>
   * ftHgŁARSS1.0(RDF)̐sB
   *
   * @return ꂽRSS
   */
  public String generate() throws RSSGenerateException {
    return generate(RSS_1_0);
  }

  /**
   * RSS.
   * <br>
   * Ŏw肳ꂽo[WɑΉRSS̐sB
   *
   * @param version RSS̃o[W
   *
   * @return ꂽRSS
   *
   * @throws Error RSS̐Ɏs
   */
  public String generate(String version) throws RSSGenerateException {
    Cache cache = getCache();
    String result = null;

    try {
			Element element = cache.get(version);
    	if (element != null) {
				result = (String)element.getValue();
    	}
    } catch (IllegalStateException e1) {
      //e1.printStackTrace();
    } catch (CacheException e1) {
      //e1.printStackTrace();
    }

    if (pagesModified || (result == null)) {
      RssDocument document = new RssDocument(version);
      RssChannel channel = new RssChannel();

      document.addChannel(channel);
      channel.setChannelLastBuildDate(DateUtils.formatISODateTime(
          new Date()));
      if ((title != null) && (title.length() > 0)) {
        channel.setChannelTitle(title);
      }

      if ((copyright != null) && (copyright.length() > 0)) {
        channel.setChannelCopyright(copyright);
      }

      if ((description != null) && (description.length() > 0)) {
        channel.setChannelDescription(description);
      }

      if ((language != null) && (language.length() > 0)) {
        channel.setChannelLanguage(language);
      }

      if ((link != null) && (link.length() > 0)) {
        channel.setChannelLink(link);
        channel.setChannelUri(link);
      }

      if ((webmaster != null) && (webmaster.length() > 0)) {
        channel.setChannelWebmaster(webmaster);
      }

      try {
        List list = pageManager.getModifiedPageList(10);
        Iterator ite = list.iterator();

        while (ite.hasNext()) {
          channel.addItem(convertPageToChannelItem((Page)ite.next()));
        }

        result = RssGenerator.generateRss(document);
        cache.put(new Element(version, result));
      } catch (PageReadException e) {
        throw new RSSGenerateException("RSS̐Ɏs܂", e);
      } catch (RssGenerationException e) {
        throw new RSSGenerateException("RSS̐Ɏs܂", e);
      }
    }

    return result;
  }

  /**
   * y[W񂩂ChannelItemւ̕ϊ
   *
   * @param page y[W
   *
   * @return ChannelItem
   *
   * @throws Error GR[hG[
   */
  private RssChannelItem convertPageToChannelItem(Page page)
        throws Error {
    RssChannelItem item = new RssChannelItem();

    String name =
      AbstractPageManager.concatPath(page.getPath(), page.getTitle());

    item.setItemTitle(name);

    try {
      item.setItemLink(uri + "view.do?page="
        + pageManager.encodePath(name));
    } catch (UnsupportedEncodingException e) {
      throw new Error(e);
    }

    item.setItemDescription(DateUtils.formatISODateTime(
        page.getLastModified()));

    return item;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getCopyright() {
    return copyright;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getDescription() {
    return description;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getLanguage() {
    return language;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getLink() {
    return link;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getTitle() {
    return title;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getWebmaster() {
    return webmaster;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setCopyright(String string) {
    copyright = nullToBlank(string);
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setDescription(String string) {
    description = nullToBlank(string);
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setLanguage(String string) {
    language = nullToBlank(string);
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setLink(String string) {
    link = nullToBlank(string);
    if (!link.endsWith("/")) {
      uri = link + "/";
    } else {
      uri = link;
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setTitle(String string) {
    title = nullToBlank(string);
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setWebmaster(String string) {
    webmaster = nullToBlank(string);
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public PageManager getPageManager() {
    return pageManager;
  }

  /**
   * DOCUMENT ME!
   *
   * @param manager
   */
  public void setPageManager(PageManager manager) {
    pageManager = manager;
  }

  /**
   * @see cx.ath.kgslab.wiki.PageChangeListener#modified()
   */
  public void modified() {
    pagesModified = true;
  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   *
   * @throws IllegalStateException DOCUMENT ME!
   */
  private Cache getCache() throws IllegalStateException {
    Cache cache = null;

    try {
      cache = cacheManager.getCache(RSS);
      if (cache == null) {
        cache = new Cache(RSS, 3, false, false, 0, 0);

        cacheManager.addCache(cache);
      }
    } catch (CacheException e) {
    }

    return cache;
  }

  /**
   * @return
   */
  public CacheManager getCacheManager() {
    return cacheManager;
  }

  /**
   * @param manager
   */
  public void setCacheManager(CacheManager manager) {
    cacheManager = manager;
  }

  /**
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    this.pageManager.addPageChangeListener(this);
  }
}
