/*
 * $Id: EncodedRequestWrapper.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.webutil;

import java.io.UnsupportedEncodingException;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;


/**
 * p[^̃GR[hϊServletRequest.
 * <br>
 * ftHgł́AUTF-8ɕϊB
 * <br>
 * Tomcat5setCharacterEncoding()̓삪<b>Ȃ</b>Ƃւ̑ΉB
 *
 * @author VM
 * @version 1.0 
 */
public class EncodedRequestWrapper extends HttpServletRequestWrapper {
  /** GR[h.ftHg"UTF-8" */
  private String encode = "UTF-8";

  /** p[^Map */
  private Map params = null;

  /**
   * RXgN^.
   *
   * @param request bv郊NGXg
   */
  public EncodedRequestWrapper(HttpServletRequest request) {
    super(request);
  }

  /**
   * RXgN^.
   *
   * @param request bv郊NGXg
   * @param encode GR[h
   */
  public EncodedRequestWrapper(HttpServletRequest request,
    String encode) {
    this(request);
    this.encode = encode;
  }

  /**
   * p[^̎擾.
   *
   * @param name p[^
   *
   * @return GR[hϊꂽp[^
   *
   * @see javax.servlet.ServletRequest#getParameter(java.lang.String)
   */
  public String getParameter(String name) {
    String[] temp = getParameterValues(name);

    if (temp != null) {
      return temp[0];
    } else {
      return null;
    }
  }

  /**
   * p[^}bv̎擾.
   *
   * @return GR[hϊꂽp[^}bv
   *
   * @see javax.servlet.ServletRequest#getParameterMap()
   */
  public Map getParameterMap() {
    if (params == null) {
      params = super.getParameterMap();
      HashMap result = new HashMap();
      Enumeration enum = super.getParameterNames();

      try {
        while (enum.hasMoreElements()) {
          String entry = (String)enum.nextElement();
          Object obj = params.get(entry);
          String[] values = encode((String[])obj);

          result.put(entry, values);
        }

        params = result;
      } catch (UnsupportedEncodingException e) {
      }
    }

    return params;
  }

  /**
   * p[^z̎擾.
   *
   * @param name p[^
   *
   * @return GR[hϊꂽp[^z
   *
   * @see javax.servlet.ServletRequest#getParameterValues(java.lang.String)
   */
  public String[] getParameterValues(String name) {
    if (params == null) {
      params = getParameterMap();
    }

    return (String[])params.get(name);
  }

  /**
   * ̃GR[hϊ.
   *
   * @param values Ώە̔z
   *
   * @return ϊ
   *
   * @throws UnsupportedEncodingException ^Ă镶GR[hɑΉĂȂ
   */
  private String[] encode(String[] values)
        throws UnsupportedEncodingException {
    String[] result = new String[values.length];

    for (int i = 0; i < values.length; i++) {
      result[i] = encode(values[i]);
    }

    values = result;

    return values;
  }

  /**
   * ̃GR[hϊ.
   *
   * @param param Ώە
   *
   * @return ϊʁBnull̏ꍇ́AnullԂB
   *
   * @throws UnsupportedEncodingException ^Ă镶GR[hɑΉĂȂ
   */
  private String encode(String param)
        throws UnsupportedEncodingException {
    if (param != null) {
      param = new String(param.getBytes("8859_1"), encode);
    }

    return param;
  }
}
