/*
 * $Id: EncodingFilter.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.webutil;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;


/**
 * GR[fBOύX邽߂̃tB^.
 * <br>
 * Tomcat5setCharacterEncoding()̓삪<b>Ȃ</b>Ƃւ̑ΉƂāA
 * EncodedRequestWrappergp悤ɕύXB
 *
 * @version 2.0 
 * @author VM
 */
public class EncodingFilter implements Filter {
  /** GR[h(ftHgutf-8) */
  String enc = "utf-8";

  /**
   *  <br/> encodingp[^̓e擾B
   *
   * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
   */
  public void init(FilterConfig config) throws ServletException {
    String tmp = config.getInitParameter("encoding");

    if ((tmp != null) && (tmp.length() > 0)) {
      enc = tmp;
    }
  }

  /**
   * tB^Kp <br/> NGXg̃GR[hύXB
   *
   * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest,
   *      javax.servlet.ServletResponse, javax.servlet.FilterChain)
   */
  public void doFilter(ServletRequest request,
    ServletResponse response, FilterChain chain)
        throws IOException, ServletException {
    HttpServletRequest req = (HttpServletRequest)request;

    if ((request instanceof HttpServletRequest)
        && ("GET".equalsIgnoreCase(
          ((HttpServletRequest)request).getMethod()))) {
      request =
        new EncodedRequestWrapper((HttpServletRequest)request, enc);
    } else {
      request.setCharacterEncoding(enc);
    }

    chain.doFilter(request, response);
  }

  /**
   * @see javax.servlet.Filter#destroy()
   */
  public void destroy() {
  }
}
