/*
 * $Id$
 */
package cx.ath.kgslab.webutil;

import java.util.Enumeration;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import org.apache.commons.collections.iterators.IteratorEnumeration;


/**
 * NGXgp[^̓eAʂMapɒu邽߂RequestWrapper.
 * @author VM
 * @version 1.0
 */
public class ReplaceRequestWrapper extends HttpServletRequestWrapper {
  /** DOCUMENT ME! */
  Map paramMap = null;

  /**
   * @param arg0
   */
  public ReplaceRequestWrapper(HttpServletRequest req, Map map) {
    super(req);
    paramMap = map;
  }

  /**
   * @see javax.servlet.ServletRequest#getParameter(java.lang.String)
   */
  public String getParameter(String key) {
    if ((paramMap == null) || !paramMap.containsKey(key)) {
      return super.getParameter(key);
    } else {
      return getParameterValues(key)[0];
    }
  }

  /**
   * @see javax.servlet.ServletRequest#getParameterMap()
   */
  public Map getParameterMap() {
    if (paramMap == null) {
      return super.getParameterMap();
    } else {
      return paramMap;
    }
  }

  /**
   * @see javax.servlet.ServletRequest#getParameterNames()
   */
  public Enumeration getParameterNames() {
    if (paramMap == null) {
      return super.getParameterNames();
    } else {
      return new IteratorEnumeration(paramMap.keySet().iterator());
    }
  }

  /**
   * @see javax.servlet.ServletRequest#getParameterValues(java.lang.String)
   */
  public String[] getParameterValues(String key) {
    if ((paramMap == null) || !paramMap.containsKey(key)) {
      return super.getParameterValues(key);
    } else {
      return (String[])paramMap.get(key);
    }
  }
}
