/*
 * $Id$
 */
package cx.ath.kgslab.webutil.struts;

import java.io.File;

import javax.servlet.ServletContext;

import org.apache.struts.action.ActionServlet;
import org.apache.struts.actions.LookupDispatchAction;

import org.springframework.context.support.MessageSourceAccessor;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.struts.ContextLoaderPlugIn;
import org.springframework.web.util.WebUtils;


/**
 * SpringLookupDispatchAction.
 * <br>
 * AvP[VReLXg擾ʉ
 * <br>
 * SpringActionSupportADispatchActionSupportꂽ߁A
 * SpringActionASpringDispatchAction͍폜B
 * LookupDispatchActionSupport܂Ȃ̂ŁA܂ł̂ȂB
 * @author VM
 * @version 1.0
 */
public abstract class LookupDispatchActionSupport
      extends LookupDispatchAction {
  /**
   * DOCUMENT ME!
   *
   * @param actionServlet DOCUMENT ME!
   */
  public void setServlet(ActionServlet actionServlet) {
    super.setServlet(actionServlet);
    if (actionServlet != null) {
      webApplicationContext =
        initWebApplicationContext(actionServlet);
      messageSourceAccessor =
        new MessageSourceAccessor(webApplicationContext);
      onInit();
    } else {
      onDestroy();
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param actionServlet DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   *
   * @throws IllegalStateException DOCUMENT ME!
   */
  protected WebApplicationContext initWebApplicationContext(
    ActionServlet actionServlet) throws IllegalStateException {
    ServletContext sc = actionServlet.getServletContext();
    WebApplicationContext wac =
      (WebApplicationContext)sc.getAttribute(ContextLoaderPlugIn.SERVLET_CONTEXT_ATTRIBUTE);

    if (wac == null) {
      wac =
        WebApplicationContextUtils.getRequiredWebApplicationContext(sc);
    }

    return wac;
  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  protected final WebApplicationContext getWebApplicationContext() {
    return webApplicationContext;
  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  protected final MessageSourceAccessor getMessageSourceAccessor() {
    return messageSourceAccessor;
  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  protected final ServletContext getServletContext() {
    return webApplicationContext.getServletContext();
  }

  /**
   * DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  protected final File getTempDir() {
    return WebUtils.getTempDir(getServletContext());
  }

  /**
   * DOCUMENT ME!
   */
  protected void onInit() {
  }

  /**
   * DOCUMENT ME!
   */
  protected void onDestroy() {
  }

  /** DOCUMENT ME! */
  private WebApplicationContext webApplicationContext;

  /** DOCUMENT ME! */
  private MessageSourceAccessor messageSourceAccessor;
}
