/*
 * $Id: InterWikiNames.java 291 2004-06-17 08:21:53Z nagasawa $
 */
package cx.ath.kgslab.wiki;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

import java.util.HashMap;

import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;

import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;

import org.springframework.beans.factory.InitializingBean;


/**
 * InterWikiNameǗNX
 *
 * @author VM
 * @version 2.0
 */
public class InterWikiNames implements InitializingBean {
  /** InterWikiNameLMap */
  private HashMap interWikiNames = new HashMap();

  /** ŏIXV */
  private long lastModified = 0;

  /** y[W}l[W */
  private PageManager pageManager = null;

  /** JaJaWikiݒ */
  private JaJaWikiConfig config = null;

  /** InterWikiNamey[W */
  private String interWikiPageName = "InterWikiName";
  
  /**
   * RXgN^
   */
  public InterWikiNames() {
  }

  /**
   * 
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
		interWikiPageName = config.getInterWikiPageName();
    parseInterWikiName();
  }

  /**
   * ŐVInterWikiNameێHashMapԂB
   *
   * @return InterWikiNameێHashMap
   */
  public HashMap parseInterWikiName() {
    try {
      if (pageManager.existsPage(interWikiPageName)) {
        Page iwpage = pageManager.getPage(interWikiPageName);

        if (lastModified != iwpage.getLastModified().getTime()) {
          lastModified = iwpage.getLastModified().getTime();
          interWikiNames.clear();

          try {
            LineNumberReader reader =
              new LineNumberReader(new StringReader(
                  iwpage.getContent()));
            String line = "";
            Perl5Util util = new Perl5Util();

            while ((line = reader.readLine()) != null) {
              parseLine(line, util);
            }
          } catch (UnsupportedEncodingException uex) {
            uex.printStackTrace();
          } catch (IOException iox) {
            iox.printStackTrace();
          }
        }
      } else {
        interWikiNames.clear();
      }
    } catch (PageReadException e) {
      interWikiNames.clear();
    }

    return interWikiNames;
  }

  /**
   * DOCUMENT ME!
   *
   * @param line DOCUMENT ME!
   * @param util DOCUMENT ME!
   *
   * @throws MalformedPerl5PatternException DOCUMENT ME!
   */
  private void parseLine(String line, Perl5Util util)
        throws MalformedPerl5PatternException {
    if (line.length() > 0) {
      util.match("#\\[([^\\]]+) ([^\\]]+)\\](?: ([^\\]]+))?#", line);

      String url = util.group(1);
      String iname = util.group(2);
      String enc = util.group(3);

      if (((url != null) && ((url = url.trim()).length() > 0))
          && ((iname != null)
          && ((iname = iname.trim()).length() > 0))) {
        InterWikiName iwname =
          new InterWikiName(url, iname,
            ((enc != null) && ((enc = enc.trim()).length() > 0))
            ? enc : config.getUrlEncode());

        interWikiNames.put(iname, iwname);
      }
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public JaJaWikiConfig getConfig() {
    return config;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public HashMap getInterWikiNames() {
    return interWikiNames;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public PageManager getPageManager() {
    return pageManager;
  }

  /**
   * DOCUMENT ME!
   *
   * @param config
   */
  public void setConfig(JaJaWikiConfig config) {
    this.config = config;
  }

  /**
   * DOCUMENT ME!
   *
   * @param manager
   */
  public void setPageManager(PageManager manager) {
    pageManager = manager;
  }
}
