/*
 * $Id$
 */
package cx.ath.kgslab.wiki;

import java.io.File;

import java.text.SimpleDateFormat;

import org.springframework.beans.factory.InitializingBean;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import org.springframework.web.context.WebApplicationContext;


/**
 * JaJaWikiݒ
 *
 * @author VM
 * @version 1.0
 *
 * @since JaJaWiki 4.0
 */
public class JaJaWikiConfig implements ApplicationContextAware,
  InitializingBean {
  /** URLEncodingɎgpGR[h */
  private String urlEncode = "UTF-8";

  /** y[W̓ǂݏɎgpGR[h */
  private String pageEncode = "UTF-8";

  /** Ytt@C̃pX */
  private String uploadDirectory = "upload";

  /** obNAbṽpX */
  private String backupDirectory = "backup";

  /** Abv[hf[^i[pX */
  private File uploadPath = null;

  /** obNAbvf[^i[pX */
  private File backupPath = null;

  /** obNAbvt@C̃t@C */
  private String backupfilePrefix = "backup_";

  /** obNAbvt@C̊gq */
  private String backupfileSuffix = ".tar.gz";

  /** tgy[W */
  private String frontPageName = "FrontPage";

  /** wvy[W */
  private String helpPageName = "Help";

  /** InterWikiNamey[W */
  private String interWikiPageName = "InterWikiName";

  /** L[[hy[W */
  private String keywordPageName = "Keyword";

  /** Җ */
  private String author = "NAGASAWA Takahiro";

  /** URI */
  private String authorUri = "mailto:mashu@xxx.xxx";

  /** 쌠\ */
  private String copyright =
    "NAGASAWA Takahiro/KGS Lab. (c) 2003-2004";

  /** 쌠URI */
  private String copyrightUri = "http://www.kgslab.ath.cx/";

  /** AvP[VReLXg */
  private ApplicationContext context = null;

  /** [gpX */
  private String root = "";

  /** }X^[pX[h */
  private String masterPassword = null;

  /** Wikiy[Wt@C̊gq */
  private String wikiPageExt = "xml";

  /** LbVɊ܂߂邱Ƃ̂łő吔̃ftHgB */
  private static final int MAX_CACHE_SIZE = 30;

  /** LbVɊ܂߂邱Ƃ̂łő吔B */
  private int cacheSize = MAX_CACHE_SIZE;

  /** 摜t@C̊gq <br>  "png", "gif", "jpg", "jpeg" 摜t@CƂĔFB */
  private String[] imgExt = {
    "png",
    "gif",
    "jpg",
    "jpeg",
  };

  /** obNAbvt@CpttH[}bg */
  private SimpleDateFormat dateFormat =
    new SimpleDateFormat("yyyyMMddHHmm");

  /**
   * 
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
  public void afterPropertiesSet() throws Exception {
    if ((context != null) && context instanceof WebApplicationContext) {
      // WebAv̏ꍇ
      initialize((WebApplicationContext)context);
    } else {
      // X^hAAv̏ꍇ
      initialize(root);
    }
  }

  /**
   * 
   *
   * @param context T[ubg
   */
  public void initialize(WebApplicationContext context) {
    backupPath =
      new File(context.getServletContext().getRealPath(this.backupDirectory));
    uploadPath =
      new File(context.getServletContext().getRealPath(this.uploadDirectory));
    if (!backupPath.exists()) {
      backupPath.mkdirs();
    }

    if (!uploadPath.exists()) {
      uploadPath.mkdirs();
    }
  }

  /**
   * 
   *
   * @param root T[ubg
   */
  public void initialize(String root) {
    backupPath = new File(root, this.backupDirectory);
    uploadPath = new File(root, this.uploadDirectory);
    if (!backupPath.exists()) {
      backupPath.mkdirs();
    }

    if (!uploadPath.exists()) {
      uploadPath.mkdirs();
    }
  }

  /**
   * obNAbvt@CɎgpt̃tH[}bg
   *
   * @return t̃tH[}bg
   */
  public SimpleDateFormat getBackupDateFormat() {
    return dateFormat;
  }

  /**
   * y[W̓ǂݏɎgpGR[h
   *
   * @return GR[h
   */
  public String getPageEncode() {
    return pageEncode;
  }

  /**
   * tgy[Wɂy[W
   *
   * @return y[W
   */
  public String getFrontPageName() {
    return frontPageName;
  }

  /**
   * C[Wt@C̊gq
   *
   * @return gq̔z
   */
  public String[] getImgExt() {
    return imgExt;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getUrlEncode() {
    return urlEncode;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setBackupDirectory(String string) {
    backupDirectory = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @param format
   */
  public void setBackupDateFormat(SimpleDateFormat format) {
    dateFormat = format;
  }

  /**
   * DOCUMENT ME!
   *
   * @param format
   */
  public void setBackupDateFormatString(String format) {
    dateFormat = new SimpleDateFormat(format);
  }

  /**
   * y[W̓ǂݏɎgpGR[h
   *
   * @param string
   */
  public void setPageEncode(String string) {
    pageEncode = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setFrontPageName(String string) {
    frontPageName = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @param strings
   */
  public void setImgExt(String[] strings) {
    imgExt = strings;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setUploadDirectory(String string) {
    uploadDirectory = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @param string
   */
  public void setUrlEncode(String string) {
    urlEncode = string;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public File getBackupPath() {
    return backupPath;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public File getUploadPath() {
    return uploadPath;
  }

  /**
   * DOCUMENT ME!
   *
   * @param path
   */
  public void setBackupPath(File path) {
    backupPath = path;
  }

  /**
   * DOCUMENT ME!
   *
   * @param path
   */
  public void setUploadPath(File path) {
    uploadPath = path;
  }

  /**
   * AvP[VReLXg̐ݒ
   *
   * @param context AvP[VReLXg
   */
  public void setApplicationContext(ApplicationContext context) {
    this.context = context;
  }

  /**
   * [gpX̎擾
   *
   * @return [gpX
   */
  public String getRoot() {
    return root;
  }

  /**
   * [gpX̐ݒ
   *
   * @param string [gpX
   */
  public void setRoot(String string) {
    root = string;
  }

  /**
   * LbVTCY̎擾
   *
   * @return LbVTCY
   */
  public int getCacheSize() {
    return cacheSize;
  }

  /**
   * LbVTCY̐ݒ
   *
   * @param i LbVTCY
   */
  public void setCacheSize(int i) {
    cacheSize = i;
  }

  /**
   * }X^[pX[h̎擾
   *
   * @return }X^[pX[h
   */
  public String getMasterPassword() {
    return masterPassword;
  }

  /**
   * }X^[pX[h̐ݒ
   *
   * @param }X^[pX[h
   */
  public void setMasterPassword(String string) {
    masterPassword = string;
  }

  /**
   * Wikiy[W̊gq̎擾
   *
   * @return Wikiy[W̊gq
   */
  public String getWikiPageExt() {
    return wikiPageExt;
  }

  /**
   * Wikiy[W̊gq̐ݒ
   *
   * @param string Wikiy[W̊gq
   */
  public void setWikiPageExt(String string) {
    wikiPageExt = string;
  }

  /**
   * obNAbvt@C̃t@C̎擾
   * @return obNAbvt@C̃t@C(t)
   */
  public String getBackupfilePrefix() {
    return backupfilePrefix;
  }

  /**
   * obNAbvt@C̊gq̎擾
   * @return obNAbvt@C̊gq
   */
  public String getBackupfileSuffix() {
    return backupfileSuffix;
  }

  /**
   * obNAbvt@C̃t@C̐ݒ
   * @param string obNAbvt@C̃t@C(t)
   */
  public void setBackupfilePrefix(String string) {
    backupfilePrefix = string;
  }

  /**
   * obNAbvt@C̊gq
   * @param string obNAbvt@C̊gq̐ݒ
   */
  public void setBackupfileSuffix(String string) {
    backupfileSuffix = string;
  }

  /**
   * @return
   */
  public String getKeywordPageName() {
    return keywordPageName;
  }

  /**
   * @param string
   */
  public void setKeywordPageName(String string) {
    keywordPageName = string;
  }

  /**
   * @return
   */
  public String getAuthor() {
    return author;
  }

  /**
   * @return
   */
  public String getCopyright() {
    return copyright;
  }

  /**
   * @return
   */
  public String getHelpPageName() {
    return helpPageName;
  }

  /**
   * @return
   */
  public String getInterWikiPageName() {
    return interWikiPageName;
  }

  /**
   * @param string
   */
  public void setAuthor(String string) {
    author = string;
  }

  /**
   * @param string
   */
  public void setCopyright(String string) {
    copyright = string;
  }

  /**
   * @param string
   */
  public void setHelpPageName(String string) {
    helpPageName = string;
  }

  /**
   * @param string
   */
  public void setInterWikiPageName(String string) {
    interWikiPageName = string;
  }

  /**
   * @return
   */
  public String getAuthorUri() {
    return authorUri;
  }

  /**
   * @return
   */
  public String getCopyrightUri() {
    return copyrightUri;
  }

  /**
   * @param string
   */
  public void setAuthorUri(String string) {
    authorUri = string;
  }

  /**
   * @param string
   */
  public void setCopyrightUri(String string) {
    copyrightUri = string;
  }
}
