/*
 * $Id$
 */
package cx.ath.kgslab.wiki;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

import java.util.HashMap;

import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;

import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;


/**
 * L[[hǗNXB
 * L[[hN@\邽߂ɁAL[[hǗNXB
 * @author VM
 * @version 4.1
 *
 * @since JaJaWiki 4.1
 */
public class Keywords {
  /** KeywordLMap */
  private HashMap keywords = new HashMap();

  /** ŏIXV */
  private long lastModified = 0;

  /** y[W}l[W */
  private PageManager pageManager = null;

  /** JaJaWikiݒ */
  private JaJaWikiConfig config = null;

  /** ftHgkeywordy[W */
  public static final String DEFAULT_KEYWORD = "Keyword";

  /** keywordy[W */
  private String keyword = DEFAULT_KEYWORD;

  /** [ */
  private String rule = "";

  /**
   * No[
   */
  private static final String LINK_RULE =
    "#(?:\\[\\[([^\\]]+)>((?:https?|ftp|news)://[!~*'\\(\\);\\/?:\\@&=+\\$,%#\\w.-]+)\\]\\])" // URLN(uPbg)
    + "|(?:\\[\\[(?:([^\\]]+)>)?([^\\]]+)\\]\\])" // uPbgl[ N
    + "#";

  /**
   * RXgN^
   */
  public Keywords() {
  }

  /**
   * 
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    keyword = config.getKeywordPageName();
    if ((keyword == null) || (keyword.length() <= 0)) {
      keyword = DEFAULT_KEYWORD;
    }

    parseKeywords();
  }

  /**
   * ŐVKeywordێHashMapԂB
   *
   * @return KeyowrdێHashMap
   */
  public synchronized HashMap parseKeywords() {
    try {
      if (pageManager.existsPage(keyword)) {
        Page kwpage = pageManager.getPage(keyword);

        if (lastModified != kwpage.getLastModified().getTime()) {
          lastModified = kwpage.getLastModified().getTime();
          keywords.clear();

          try {
            StringBuffer buf = new StringBuffer();
            LineNumberReader reader =
              new LineNumberReader(new StringReader(
                  kwpage.getContent()));
            String line = "";
            Perl5Util util = new Perl5Util();

            while ((line = reader.readLine()) != null) {
              parseLine(line, util, buf);
            }

            if (buf.length() > 0) {
              rule = buf.substring(0, buf.length() - 1);
            } else {
              rule = "";
            }
          } catch (UnsupportedEncodingException uex) {
            uex.printStackTrace();
          } catch (IOException iox) {
            iox.printStackTrace();
          }
        }
      } else {
        keywords.clear();
      }
    } catch (PageReadException e) {
      keywords.clear();
    }

    return keywords;
  }

  /**
   * L[[hXgs
   *
   * @param line Ώۍs
   * @param util K\Util(ORO)
   * @param buf XgOobt@
   *
   * @throws MalformedPerl5PatternException DOCUMENT ME!
   */
  private void parseLine(String line, Perl5Util util, StringBuffer buf)
        throws MalformedPerl5PatternException {
    if (line.length() > 0) {
      util.match(LINK_RULE, line);
      String url = util.group(2);
      String bname = util.group(4);

      String alias = "";
      Keyword kw = new Keyword();

      if ((url != null) && (url.trim().length() > 0)) {
        alias = util.group(1).trim();
        kw.setLink(url.trim());
        kw.setUri(true);
      } else if ((bname != null) && (bname.trim().length() > 0)) {
        alias = util.group(3);
        if ((alias == null) || (alias.trim().length() <= 0)) {
          alias = bname;
        }

        alias = alias.trim();
        kw.setLink(bname.trim());

      }

      if ((alias != null) && (alias.length() > 0)) {
        buf.append(alias).append('|');
        keywords.put(alias, kw);
      }
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public JaJaWikiConfig getConfig() {
    return config;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public HashMap getKeywords() {
    return keywords;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public PageManager getPageManager() {
    return pageManager;
  }

  /**
   * DOCUMENT ME!
   *
   * @param config
   */
  public void setConfig(JaJaWikiConfig config) {
    this.config = config;
  }

  /**
   * DOCUMENT ME!
   *
   * @param manager
   */
  public void setPageManager(PageManager manager) {
    pageManager = manager;
  }

  /**
   * @return
   */
  public String getRule() {
    return rule;
  }

  /**
   * @param string
   */
  public void setRule(String string) {
    rule = string;
  }
}
