/*
 * $Id$
 */
package cx.ath.kgslab.wiki.cache;

import net.sf.ehcache.CacheManager;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;


/**
 * LbV}l[W
 * <br>
 * ehcachẽbpNXB
 *
 * @author VM
 * @version 1.0 
 * @since JaJaWiki 4.0
 */
public class CacheManagerFactory implements FactoryBean,
  InitializingBean, DisposableBean {
  /** LbV}l[W */
  private CacheManager cacheManager = null;

  /**
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    cacheManager = CacheManager.create();
  }

  /**
   * @see org.springframework.beans.factory.DisposableBean#destroy()
   */
  public void destroy() throws Exception {
    cacheManager.shutdown();
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#getObject()
   */
  public Object getObject() throws Exception {
    return cacheManager;
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#getObjectType()
   */
  public Class getObjectType() {
    return CacheManager.class;
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#isSingleton()
   */
  public boolean isSingleton() {
    return true;
  }
}
