/*
 * $Id: Parser.java 284 2004-06-15 01:40:23Z nagasawa $
 */
package cx.ath.kgslab.wiki.parser;

import java.io.IOException;
import java.io.LineNumberReader;

import cx.ath.kgslab.wiki.parser.element.Block;
import cx.ath.kgslab.wiki.parser.element.Body;
import cx.ath.kgslab.wiki.parser.element.DList;
import cx.ath.kgslab.wiki.parser.element.HRLine;
import cx.ath.kgslab.wiki.parser.element.Heading;
import cx.ath.kgslab.wiki.parser.element.OList;
import cx.ath.kgslab.wiki.parser.element.Paragraph;
import cx.ath.kgslab.wiki.parser.element.Pre;
import cx.ath.kgslab.wiki.parser.element.Quotation;
import cx.ath.kgslab.wiki.parser.element.Table;
import cx.ath.kgslab.wiki.parser.element.UList;


/**
 * ubNvf̉
 *
 * @author VM
 * @version 2.5 $Revision: 1.1 $
 *
 * @since JaJaWiki 2.5
 */
public class Parser {
  /** Rgs */
  static final String COMMENT = "//";

  /** ؂ */
  static final String HR = HRLine.CONTROL_STRING; // "----"

  /** o */
  static final char HEADING = Heading.CONTROL_CHAR; // '*'

  /** p */
  static final char QUOTATION = Quotation.CONTROL_CHAR; // '>'

  /** ԍȂXg */
  static final char ULIST = UList.CONTROL_CHAR; // '-'

  /** ԍXg */
  static final char OLIST = OList.CONTROL_CHAR; // '+'

  /** `Xg */
  static final char DLIST = DList.CONTROL_CHAR; // ':'

  /** Pre */
  static final char PRE = Pre.CONTROL_CHAR; // ' '

  /** Pre */
  static final char PRE2 = Pre.CONTROL_CHAR2; // '\t'

  /** ꗗ */
  static final char TABLE = Table.CONTROL_CHAR; // '|'

  /** ꗗ */
  static final char TABLE2 = Table.CONTROL_CHAR2; // ','

  /** i */
  static final char PARAGRAPH = Paragraph.CONTROL_CHAR; // '~'

  /**
   * RXgN^
   */
  public Parser() {
  }

  /**
   * Wiki͏.
   *
   * @param reader
   *
   * @return Bodyvf
   *
   * @throws IOException
   */
  public Body parse(LineNumberReader reader) throws IOException {
    Body body = new Body();
    Block last = body;

    String line = null;

    while ((line = reader.readLine()) != null) {
      //      System.out.println("parseLine : <<" + line + ">>");
      last = parseLine(body, last, line);
    }

    return body;
  }

  /**
   * s̉͏.
   *
   * @param body Bodyvf
   * @param last vf܂܂ׂubNvf
   * @param line Ώۍs̕
   *
   * @return ̗vf܂܂ׂubNvf
   */
  private Block parseLine(Body body, Block last, String line) {
    if (line.length() > 0) {
      if (line.startsWith(COMMENT)) {
        // RgȂ̂ŉȂ
      } else if (line.equals(HR)) {
        // ؂
        last = parseHRLine(body);
      } else {
        last = parseBlock(body, last, line);
      }
    } else {
      last = parseParagraph(body);
    }

    return last;
  }

  /**
   * ỉ͏.
   *
   * @param body Bodyvf
   *
   * @return ivf
   */
  private Block parseParagraph(Body body) {
    Paragraph e = new Paragraph();

    e.setParent(body);

    return e;
  }

  /**
   * ̉͏.
   *
   * @param body Bodyvf
   *
   * @return Bodyvf
   */
  private Block parseHRLine(Body body) {
    HRLine hr = new HRLine();

    hr.setParent(body);

    return body;
  }

  /**
   * ubNvf̉͏.
   *
   * @param body Bodyvf
   * @param last vf܂܂ׂubNvf
   * @param line Ώۍs̕
   *
   * @return ̗vf܂܂ׂubNvf
   */
  private Block parseBlock(Body body, Block last, String line) {
    switch (line.charAt(0)) {
    case HEADING:
      last = parseHeading(body, line);

      break;

    case QUOTATION:
      last = parseQuotation(body, last, line);

      break;

    case ULIST:
      last = parseUList(last, line);

      break;

    case OLIST:
      last = parseOList(last, line);

      break;

    case DLIST:
      last = parseDList(last, line);

      break;

    case PRE:
    case PRE2:
      last = parsePre(last, line);

      break;

    case TABLE:
    case TABLE2:
      last = parseTable(body, last, line);

      break;

    case PARAGRAPH:default:
      last = parseParagraph(last, line);

      break;
    }

    return last;
  }

  /**
   * ỉ͏.
   *
   * @param last vf܂܂ׂubNvf
   * @param line Ώۍs̕
   *
   * @return ̗vf܂܂ׂubNvf
   */
  private Block parseParagraph(Block last, String line) {
    if (last instanceof Paragraph) {
      last = last.add(line);
    } else {
      Paragraph e = new Paragraph(line);

      e.setParent(last);
      last = e;
    }

    return last;
  }

  /**
   * e[ủ͏.
   *
   * @param body Bodyvf
   * @param last vf܂܂ׂubNvf
   * @param line Ώۍs̕
   *
   * @return ̗vf܂܂ׂubNvf
   */
  private Block parseTable(Body body, Block last, String line) {
    if (last instanceof Table) {
      last = last.add(line);
    } else {
      Table e = new Table(line);

      e.setParent(body);
      last = e;
    }

    return last;
  }

  /**
   * `ςݕ̉͏.
   *
   * @param last vf܂܂ׂubNvf
   * @param line Ώۍs̕
   *
   * @return ̗vf܂܂ׂubNvf
   */
  private Block parsePre(Block last, String line) {
    if (last instanceof Pre) {
      last = last.add(line);
    } else {
      Pre e = new Pre(line);

      e.setParent(last);
      last = e;
    }

    return last;
  }

  /**
   * Xg̉͏.
   *
   *
   *
   * @param last vf܂܂ׂubNvf
   * @param line Ώۍs̕
   *
   * @return ̗vf܂܂ׂubNvf
   */
  private Block parseDList(Block last, String line) {
    if (last instanceof DList) {
      last = last.add(line);
    } else {
      DList e = new DList(line);

      e.setParent(last);
      last = e;
    }

    return last;
  }

  /**
   * ԍXg̉͏.
   *
   * @param last vf܂܂ׂubNvf
   * @param line Ώۍs̕
   *
   * @return ̗vf܂܂ׂubNvf
   */
  private Block parseOList(Block last, String line) {
    if (last instanceof OList) {
      last = last.add(line);
    } else {
      OList e = new OList(line);

      e.setParent(last);
      last = e;
    }

    return last;
  }

  /**
   * ԍȂXg̉͏.
   *
   * @param last vf܂܂ׂubNvf
   * @param line Ώۍs̕
   *
   * @return ̗vf܂܂ׂubNvf
   */
  private Block parseUList(Block last, String line) {
    if (last instanceof UList) {
      last = last.add(line);
    } else {
      UList e = new UList(line);

      e.setParent(last);
      last = e;
    }

    return last;
  }

  /**
   * p̉͏.
   *
   * @param body Bodyvf
   * @param last vf܂܂ׂubNvf
   * @param line Ώۍs̕
   *
   * @return ̗vf܂܂ׂubNvf
   */
  private Block parseQuotation(Body body, Block last, String line) {
    if (last instanceof Quotation) {
      last = last.add(line);
    } else {
      Quotation e = new Quotation(line);

      e.setParent(body);
      last = e;
    }

    return last;
  }

  /**
   * ỏ͏.
   *
   * @param body Bodyvf
   * @param line Ώۍs̕
   *
   * @return Bodyvf
   */
  private Block parseHeading(Body body, String line) {
    Block last;
    Heading h = new Heading(line);

    h.setParent(body);
    last = body;

    return last;
  }
}
