/*
 * $Id: Block.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.parser.element;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/**
 * ubNvf̊{NX
 *
 * @author VM
 * @version 2.5 
 *
 * @since JaJaWiki 2.5
 */
public abstract class Block extends Element {
  /** qvf̃Xg */
  protected List children = new ArrayList();

  /** x */
  protected int level = 0;

  /**
   * RXgN^
   */
  public Block() {
  }

  /**
   * RXgN^
   *
   * @param line
   */
  public Block(String line) {
    int lv = countLevel(line);

    this.level = lv;
    add(new Inline(line.substring(lv)));
  }

  /**
   * CX^X
   *
   * @param line Ώۂ̍s
   *
   * @return CX^X
   */
  protected abstract Block create(String line);

  /**
   * qvfƂł邩ǂ`FbN  ̃xx̍̂AqvfɂłȂB
   *
   * @param elm qvf
   *
   * @return true:qvfɂł false:qvfɂłȂ
   */
  public boolean canContain(Block elm) {
    return elm.level > this.level;
  }

  /**
   * vf̒ǉ
   *
   * @param child qvf
   */
  protected void add(Element child) {
    children.add(child);
  }

  /**
   * qvf̒ǉ
   *
   * @param line Ώ
   *
   * @return qvf̐eɂȂvf
   */
  public Block add(String line) {
    Block result = this;
    int lv = countLevel(line);

    if (children.size() == 0) {
      this.level = lv;
    }

    if (this.level == lv) {
      add(new Inline(line.substring(lv)));
    } else if (this.level > lv) {
      result = this.getParent().add(line);
    } else {
      result = create(line);
      result.setParent(this);
    }

    return result;
  }

  /**
   * evf̐ݒ
   *
   * @param newParent evf
   *
   * @see cx.ath.kgslab.wiki.parser.element.Element#setParent(cx.ath.kgslab.wiki.parser.element.Block)
   */
  public void setParent(Block newParent) {
    if (newParent.canContain(this)) {
      super.setParent(newParent);
    } else {
      Block parent = newParent.getParent();

      setParent(parent);
    }
  }

  /**
   * x𐔂
   *
   * @param text Ώە
   *
   * @return x
   */
  protected int countLevel(String text) {
    char ch = text.charAt(0);

    return countLevel(ch, text);
  }

  /**
   * x𐔂
   *
   * @param ch vfw
   * @param text Ώە
   *
   * @return x
   */
  protected int countLevel(char ch, String text) {
    int result = 0;

    if (text.charAt(0) == ch) {
      for (int i = 1; (i <= getMaxLevel()) && (text.length() > i);
          i++) {
        if (text.charAt(i) != ch) {
          result = i;

          break;
        }
      }
    }

    return result;
  }

  /**
   * vf̍ő僌x擾  ftHg3Ԃ
   *
   * @return ő僌x
   */
  protected int getMaxLevel() {
    return 3;
  }

  /**
   * vfHTMLɕϊB
   *
   * @return ʕ
   */
  public String toString() {
    StringBuffer buf = new StringBuffer(2048);

    makeText(buf);

    return buf.toString();
  }

  /**
   * vfHTMLɕϊB
   *
   * @param buf i[obt@
   */
  public void makeText(StringBuffer buf) {
    Iterator iterator = children.iterator();

    while (iterator.hasNext()) {
      Object tmp = iterator.next();

      if (tmp != null) {
        if (tmp instanceof Element) {
          Element temp = (Element)tmp;

          temp.makeText(buf);
        } else {
          String temp = tmp.toString();

          if (temp.length() > 0) {
            buf.append(temp);
          }
        }
      }
    }
  }
}
