/*
 * $Id: DList.java 284 2004-06-15 01:40:23Z nagasawa $
 */
package cx.ath.kgslab.wiki.parser.element;

import java.util.Iterator;


/**
 * Xgvf
 *
 * @author VM
 * @version 2.5 $Revision: 1.1 $
 *
 * @since JaJaWiki 2.5
 */
public class DList extends Block {
  /** vfw */
  public static final char CONTROL_CHAR = ':';

  /**
   * RXgN^
   *
   * @param line
   */
  public DList(String line) {
    super(line);
  }

  /**
   * CX^X
   *
   * @param line
   *
   * @return
   *
   * @see cx.ath.kgslab.wiki.parser.element.Block#create(java.lang.String)
   */
  protected Block create(String line) {
    return new DList(line);
  }

  /**
   * HTMLϊ
   *
   * @param buf
   */
  public void makeText(StringBuffer buf) {
    buf.append("<dl>\n");

    Iterator iterator = children.iterator();

    while (iterator.hasNext()) {
      Object tmp = iterator.next();
      String txt = tmp.toString();
      int idx = txt.indexOf("|");

      if (idx >= 0) {
        buf.append("<dt>").append(txt.substring(0, idx)).append("</dt>");
        buf.append("<dd>").append(txt.substring(idx + 1)).append("</dd>\n");
      } else {
        buf.append("<dt></dt>");
        buf.append("<dd>").append(txt).append("</dd>\n");
      }
    }

    buf.append("</dl>\n");
  }
}
