/*
 * $Id: Row.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.parser.element;

import java.util.StringTokenizer;


/**
 * e[usvf
 *
 * @author VM
 * @version 2.5 
 *
 * @since JaJaWiki 2.5
 */
public class Row extends Block {
  /** wb_ǂ */
  boolean head = false;

  /** tb^ǂ */
  boolean foot = false;

  /**
   * RXgN^
   * <br/>
   * Ps̏vfɕB
   *
   * @param line
   */
  public Row(String line) {
    int idx = line.lastIndexOf("|");

    String suffix = line.substring(idx + 1, line.length());

    head = (suffix.indexOf("h") >= 0);
    foot = (suffix.indexOf("f") >= 0);
    line = line.substring(0, idx);

    StringTokenizer tokens =
      new StringTokenizer(line, line.substring(0, 1));
    String token = "";

    while (tokens.hasMoreTokens()) {
      token = tokens.nextToken();
      this.add(new Column(token));
    }
  }

  /**
   * CX^X
   *
   * @param line
   *
   * @return
   *
   * @see cx.ath.kgslab.wiki.parser.element.Block#create(java.lang.String)
   */
  protected Block create(String line) {
    return new Row(line);
  }

  /**
   * vfHTMLɕϊB
   *
   * @param buf i[obt@
   */
  public void makeText(StringBuffer buf) {
    if (head) {
      buf.append("<thead>");
      super.makeText(buf);
      buf.append("</thead>");
    }

    if (foot) {
      buf.append("<tfoot>");
      super.makeText(buf);
      buf.append("</tfoot>");
    }

    if (!(head || foot)) {
      buf.append("<tr>");
      super.makeText(buf);
      buf.append("</tr>");
    }
  }
}
