/*
 * $Id: Board.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.plugin;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;

import java.text.MessageFormat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;
import cx.ath.kgslab.wiki.struts.form.PluginForm;


/**
 * fvOC
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 3.0
 */
public class Board extends PluginBase {
  /** ftHgő吔 */
  private static final int MAX = 3;

  /** Rg */
  private static final MessageFormat FORM_FORMAT =
    new MessageFormat(
      "<form method=\"post\" action=\"{1}/plugin.do\"><div>\n"
      + " <input type=\"hidden\" name=\"page\" value=\"{0}\" />\n"
      + " <input type=\"hidden\" name=\"plugin\" value=\"{5}\" />\n"
      + " {2} <input type=\"text\" name=\"options\" size=\"15\" /> : <br/>\n"
      + " {3} <input type=\"text\" name=\"options\" size=\"30\" /><br/>\n"
      + " <textarea name=\"options\" cols=\"60\" rows=\"8\"/><br/>\n"
      + " <input type=\"submit\" value=\"{4}\" /></div></form>");

  /** bZ[W̃tH[}bg */
  private static final MessageFormat FORMAT =
    new MessageFormat("**[[{0}]] {1,date,yyyy-MM-dd HH:mm:ss}\n");

  /** ID */
  private String id = "";

  /**
   * ϊ <br/> ۂ̃Rǧڂ鏈B
   *
   * @see java.lang.Object#toString()
   */
  public String toHTML() throws PluginException {
    try {
      Page info = pageManager.getPage(this.page);
      StringBuffer result = new StringBuffer();

      childList(info, 1, result);

      //      String temp = URLEncoder.encode(PageManager.concatPath(path, page), JaJaWikiConst.URL_ENC);
      //      if ((id != null) && (id.trim().length() > 0)) {
      //        String tid = URLEncoder.encode(id, JaJaWikiConst.URL_ENC);
      //
      //        return FORM_FORMAT.format(new Object[] {
      //            path, page, temp
      //          }) + result.toString();
      //      } else {
      return converter.convert(result.toString())
      + FORM_FORMAT.format(new Object[] {
          page,
          this.contextPath,
          context.getMessage("plugin.board.name", null,
            converter.getLocale()),
          context.getMessage("plugin.board.subject", null,
            converter.getLocale()),
          context.getMessage("plugin.board.commit", null,
            converter.getLocale()),
          pluginName,
        });

      //      }
      //    } catch (UnsupportedEncodingException uex) {
      //      throw new RuntimeException(uex);
      //    }
    } catch (PageReadException e) {
      throw new PluginException(e.getMessage(), e);
    } catch (IOException e) {
      throw new PluginException(e.getMessage(), e);
    }
  }

  /**
   * qy[W̃Xg
   *
   * @param info y[W
   * @param level x
   * @param result StringBuffer
   */
  private void childList(Page info, int level, StringBuffer result) {
    if (level > 2) {
      return;
    }

    String path = info.getPath();
    String page = info.getTitle();

    List list = new ArrayList(info.getChildCount());
    Iterator ite = info.enumerateChild();
    String parentPath = AbstractPageManager.concatPath(path, page);

    while (ite.hasNext()) {
      String childName = (String)ite.next();

      try {
        Page child =
          pageManager.getPage(AbstractPageManager.concatPath(
              parentPath, childName));

        list.add(child);
      } catch (PageReadException e) {
      }
    }

    Collections.sort(list,
      new Comparator() {
        public int compare(Object p1, Object p2) {
          Page page1 = (Page)p1;
          Page page2 = (Page)p2;
          long result =
            (page1.getLastModified().getTime()
            - page2.getLastModified().getTime());

          return ((result > 0L) ? (-1) : ((result == 0L) ? 0 : 1));
        }
      });

    ite = list.iterator();
    int cnt = (level == 1) ? (-list.size()) : 0;

    while (ite.hasNext() && (cnt < MAX)) {
      cnt++;
      Page child = (Page)ite.next();

      for (int i = 0; i < level; i++) {
        result.append("-");
      }

      String content = child.getContent();
      LineNumberReader reader =
        new LineNumberReader(new StringReader(content));

      result.append("[[").append(child.getTitle()).append(">");
      result.append(AbstractPageManager.concatPath(child.getPath(),
          child.getTitle())).append("]]");
      try {
        String line = reader.readLine();

        result.append("&br;");
        result.append(line);
      } catch (IOException ex) {
      }

      result.append("\n");

      childList(child, level + 1, result);
    }

    if (cnt >= MAX) {
      for (int i = 0; i < level; i++) {
        result.append("-");
      }

      result.append("...\n");
    }
  }

  /**
   * ANV
   *
   * @param form
   *
   * @throws PluginException
   *
   * @see cx.ath.kgslab.wiki.inline.ActionPlugin#action(cx.ath.kgslab.wiki.struts.form.PluginForm)
   */
  public void action(PluginForm form) throws PluginException {
    String page = form.getPage();

    //String id = form.getId();
    Object[] options = form.getOptions();
    String name = (String)options[0];
    String title = (String)options[1];
    String message = (String)options[2];

    // Rg̒ǉB
    try {
      Page comment = addComment(page, name, title, message);

      Page parent = pageManager.getPage(page);

      parent.addChild(comment.getTitle());
      pageManager.putPage(parent, false);
    } catch (Exception ex) {
      throw new PluginException(ex);
    }
  }

  /**
   * Rg̒ǉB
   *
   * @param path y[WpX
   * @param name ͎Җ
   * @param title 
   * @param message bZ[W
   *
   * @return 쐬y[W
   *
   * @throws Exception
   */
  protected Page addComment(String path, String name, String title,
    String message) throws Exception {
    Page info = new Page();

    info.setPath(path);
    if (pageManager.existsPage(path, title)) {
      int idx;

      for (idx = 0; pageManager.existsPage(path, title + "-" + idx);
          idx++) {
        ;
      }

      info.setTitle(title + "-" + idx);
    } else {
      info.setTitle(title);
    }

    info.setContent(FORMAT.format(new Object[] {
          name,
          new Date()
        }) + message + "\n\n&board;");
    info.setConvertedPage("");
    pageManager.putPage(info);

    return info;
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:f\n" + " &amp;{0};\n"
    + "&#38;{0}LqƁAfɏނ߂̃tH[ߍ܂܂B\n"
    + "̊Kw([̍ő3)XgƂĕ\A\n" + "ۂ݂͕̏ʃy[WɋL^܂B\n"
    + "y[ẂAtH[\ty[W̔zɍ܂B\n"
    + "-fvOĆAubNvfƂĈׂłB\n"
    + "-fvOĆA̗vf̎qvfɂȂ邱Ƃ͂ł܂B\n"
    + "-fvOĆA̗vfqvfɂ邱Ƃ͂ł܂B";
  }
}
