/*
 * $Id: Diary.java 290 2004-06-16 05:37:18Z nagasawa $
 */
package cx.ath.kgslab.wiki.plugin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

import java.net.URLEncoder;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

import cx.ath.kgslab.wiki.AbstractPageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.exception.PageWriteException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;


/**
 * L쐬^O/vOC
 * <br>
 * ^OCuƃvOC̗Ɏg悤ɍ쐬ꍇ̗łB
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 1.0
 */
public class Diary extends PluginBase {
  /** NtH[}bg */
  protected static final SimpleDateFormat DATE_FORMAT =
    new SimpleDateFormat("yyyyMM");

  /** wb_\p NtH[}bg */
  protected static final SimpleDateFormat HEADER_DATE_FORMAT =
    new SimpleDateFormat("yyyy-MM");

  /** y[Wp ttH[}bg */
  protected static final SimpleDateFormat PAGENAME_DATE_FORMAT =
    new SimpleDateFormat("yyyy-MM-dd");

  /** 擪̃^O */
  protected static final String TOP =
    "<table class=\"style_calendar\">\n";

  /** ̃^O */
  protected static final String BOTTOM = "</table>";

  /** j\wb_(jJn/jJn) */
  protected static final String[] HEADER_WEEK =
  {
    "<tr class=\"style_td_week\"><th class=\"style_td_sun\" style=\"width:35px;\">Sun</th><th style=\"width:35px;\">Mon</th><th style=\"width:35px;\">Tue</th><th style=\"width:35px;\">Wed</th><th style=\"width:35px;\">Thr</th><th style=\"width:35px;\">Fri</th><th class=\"style_td_sat\" style=\"width:35px;\">Sat</th></tr>",
    "<tr class=\"style_td_week\"><th style=\"width:35px;\">Mon</th><th style=\"width:35px;\">Tue</th><th style=\"width:35px;\">Wed</th><th style=\"width:35px;\">Thr</th><th style=\"width:35px;\">Fri</th><th class=\"style_td_sat\" style=\"width:35px;\">Sat</th><th class=\"style_td_sun\" style=\"width:35px;\">Sun</th></tr>",
  };

  /** j */
  protected static final int[][] DAY_OF_WEEK =
  {
    {
      Calendar.SUNDAY,
      Calendar.MONDAY,
      Calendar.TUESDAY,
      Calendar.WEDNESDAY,
      Calendar.THURSDAY,
      Calendar.FRIDAY,
      Calendar.SATURDAY,
    },
    {
      Calendar.MONDAY,
      Calendar.TUESDAY,
      Calendar.WEDNESDAY,
      Calendar.THURSDAY,
      Calendar.FRIDAY,
      Calendar.SATURDAY,
      Calendar.SUNDAY,
    },
  };

  /** wb_tH[}bg */
  protected MessageFormat HEAD_MESSAGE_FORMAT =
    new MessageFormat(" <thead>\n"
      + "  <tr class=\"style_td_caltop\">\n" + "   <td>{3}</td>\n"
      + "   <td colspan=\"5\">\n" + "    <a href=\"{7}\">{0}</a>\n"
      + "   </td>\n" + "   <td>{4}</td>\n" + "  </tr>\n" + "  {1}\n"
      + " </thead>\n");

  /** J_\y[WtH[}bg */
  protected MessageFormat VIEW_PAGE_MESSAGE_FORMAT =
    new MessageFormat("\n\n&diary({2},{5},true)'{'{6}'}';");

  /** tb^tH[}bg */
  protected MessageFormat FOOT_MESSAGE_FORMAT =
    new MessageFormat(" <tfoot>\n"
      + "  <tr class=\"style_td_caltop\">\n"
      + "   <td colspan=\"7\">\n" + "    <a href=\"{7}\">edit</a>\n"
      + "   </td>\n" + "  </tr>\n" + " </tfoot>\n");

  /** J_ҏWy[WtH[}bg */
  protected MessageFormat EDIT_PAGE_MESSAGE_FORMAT =
    new MessageFormat("\n\n&diary_edit({2},{5})'{'{6}'}';");

  /** J_(N) */
  protected Calendar ym = Calendar.getInstance();

  /** T̍ŏ̗j */
  protected int firstDayOfWeek = ym.getFirstDayOfWeek();

  /** T}\邩ǂ */
  protected boolean showSummary = false;

  /** T} */
  protected StringBuffer summary = new StringBuffer();

  /** ^Cg(ftHg"L") */
  protected String title = "L";

  /** y[W */
  protected String page = "";

  /**
   * RXgN^
   */
  public Diary() {
    super();
    setYearMonth(new Date());
  }

  /**
   * vOCp[^̐ݒ
   *
   * @param params
   *
   * @see cx.ath.kgslab.wiki.inline.InlineElementPlugin#setParams(java.lang.String)
   */
  public void setParams(String params) {
    if ((params != null) && (params.length() > 0)) {
      StringTokenizer tokens = new StringTokenizer(params, ",", true);
      int i = 0;

      while (tokens.hasMoreTokens()) {
        String temp = tokens.nextToken();

        if ((temp != null) && !",".equals(temp)) {
          temp = temp.trim();

          switch (i) {
          case 0:
            if ("today".equalsIgnoreCase(temp)) {
              setYearMonth(new Date());
            } else {
              setYearMonth(temp);
            }

            break;

          case 1:
            setFirstDayOfWeek(temp);

            break;

          case 2:
            setShowSummary(temp);

            break;
          }

          if (tokens.hasMoreTokens()) {
            tokens.nextToken();
          }
        }

        i++;
      }
    }
  }

  /**
   * Nݒ肷B
   *
   * @param param
   */
  protected void setYearMonth(String param) {
    try {
      Date date = DATE_FORMAT.parse(param);

      setYearMonth(date);
    } catch (Exception ex) {
    }
  }

  /**
   * Nݒ肷B
   *
   * @param date
   */
  protected void setYearMonth(Date date) {
    ym.setTime(date);
    ym.set(Calendar.DAY_OF_MONTH, 1);
  }

  /**
   * y[W̐ݒ
   *
   * @param text
   *
   * @see cx.ath.kgslab.wiki.inline.InlineElementPlugin#setText(java.lang.String)
   */
  public void setText(String text) {
    if ((text != null) && (text.trim().length() > 0)) {
      title = text.trim();
    }
  }

  /**
   * y[W̐ݒ
   *
   * @param page y[W
   *
   * @see cx.ath.kgslab.wiki.inline.InlineElementPlugin#setPage(java.lang.String)
   */
  public void setPage(String page) {
    this.page = nullToBlank(page);
  }

  /**
   * null̏ꍇɁA0̕ɕϊB
   *
   * @param string Ώە
   *
   * @return ʕ
   */
  protected String nullToBlank(String string) {
    return (string == null) ? "" : string.trim();
  }

  //  /**
  //   * ^Ȍ
  //   *
  //   * @return SKIP_BODY
  //   *
  //   * @throws JspException
  //   *
  //   * @see javax.servlet.jsp.tagext.Tag#doStartTag()
  //   */
  //  public int doStartTag() throws JspException {
  //    HttpServletRequest request =
  //      (HttpServletRequest)pageContext.getRequest();
  //
  //    converter =
  //      new ConvertHtml(ContextPathUtils.getPath(request),
  //        this.pageContext.getServletContext());
  //
  //    PageForm form =
  //      (PageForm)RequestUtils.lookup(pageContext, "form", null);
  //
  //    String page = form.getPage();
  //
  //    converter.setPage(page);
  //    setPage(page);
  //
  //    String year = (String)this.getValue("year");
  //    String month = (String)this.getValue("month");
  //    String firstDayOfWeek = (String)this.getValue("firstDayOfWeek");
  //
  //    if ((year != null) && (year.length() > 0) && (month != null)
  //          && (month.length() > 0)) {
  //      setYearMonth(year + month);
  //    }
  //
  //    if ((firstDayOfWeek != null) && (firstDayOfWeek.length() > 0)) {
  //      setFirstDayOfWeek(firstDayOfWeek);
  //    }
  //
  //    try {
  //      this.pageContext.getOut().println(toHTML());
  //    } catch (Exception ex) {
  //      throw new JspException(ex);
  //    }
  //
  //    return SKIP_BODY;
  //  }

  /**
   * ϊ
   *
   * @return ϊ̕
   *
   * @throws PluginException
   *
   * @see java.lang.Object#toString()
   */
  public String toHTML() throws PluginException {
    try {
      StringBuffer result = new StringBuffer();

      result.append(TOP);

      String basePath = this.page;

      Page root = pageManager.getPage(this.page);

      Object[] params = new Object[8];
      String date = HEADER_DATE_FORMAT.format(this.ym.getTime());
      MessageFormat PAGE_TITLE = new MessageFormat(title + "({0})");
      String page = PAGE_TITLE.format(new Object[] {
            date
          });

      String rootPage = root.getTitle();
      String rootPath = root.getPath();

      if (rootPage.startsWith(page) || page.startsWith(rootPage)) {
        basePath = rootPath;
      }

      params[0] = page;
      params[1] = HEADER_WEEK[firstDayOfWeek - 1];
      params[2] = DATE_FORMAT.format(this.ym.getTime());
      params[5] =
        (firstDayOfWeek == Calendar.MONDAY) ? "monday" : "sunday";
      params[6] = this.title;
      params[7] =
        this.encodeURL(this.contextPath + "/view.do?page="
          + URLEncoder.encode(AbstractPageManager.concatPath(
              basePath, page), config.getUrlEncode()));

      Calendar prevMonth = (Calendar)this.ym.clone();

      prevMonth.add(Calendar.MONTH, -1);

      String prevDate =
        HEADER_DATE_FORMAT.format(prevMonth.getTime());
      String prev = PAGE_TITLE.format(new Object[] {
            prevDate
          });

      if (pageManager.existsPage(basePath, prev)) {
        params[3] =
          "<a href=\""
          + this.encodeURL(this.contextPath + "/view.do?page="
            + URLEncoder.encode(AbstractPageManager.concatPath(
                basePath, prev), config.getUrlEncode()))
          + "\">&lt;&lt;</a>";
      } else {
        params[3] = "";
      }

      Calendar nextMonth = (Calendar)this.ym.clone();

      nextMonth.add(Calendar.MONTH, 1);

      String nextDate =
        HEADER_DATE_FORMAT.format(nextMonth.getTime());
      String next = PAGE_TITLE.format(new Object[] {
            nextDate
          });

      if (pageManager.existsPage(basePath, next)) {
        params[4] =
          "<a href=\""
          + this.encodeURL(this.contextPath + "/view.do?page="
            + URLEncoder.encode(AbstractPageManager.concatPath(
                basePath, next), config.getUrlEncode()))
          + "\">&gt;&gt;</a>";
      } else {
        params[4] = "";
      }

      String head = createHeader(root, params, basePath, page);
      String body = createBody(params, basePath, page);

      params[7] =
        this.encodeURL(this.contextPath + "/view.do?page="
          + URLEncoder.encode(AbstractPageManager.concatPath(
              basePath, page) + "̕ҏW", config.getUrlEncode()));
      String foot =
        createFooter(root, params, basePath, page + "̕ҏW");

      result.append(head);
      result.append(foot);
      result.append(body);
      result.append(BOTTOM);

      if (showSummary) {
        result.append(summary.toString());
      }

      return result.toString();
    } catch (PageReadException e) {
      throw new PluginException(e.getMessage(), e);
    } catch (PageWriteException e) {
      throw new PluginException(e.getMessage(), e);
    } catch (UnsupportedEncodingException e) {
      throw new PluginException(e.getMessage(), e);
    }
  }

  /**
   * {fB𐶐B
   *
   * @param params p[^
   * @param path y[WpX
   * @param page y[W
   *
   * @return
   */
  protected String createBody(Object[] params, String path,
    String page)
        throws UnsupportedEncodingException, PageReadException {
    StringBuffer result = new StringBuffer();

    result.append(" <tbody>");
    result.append(createCalendarTable(path, page));
    result.append("</tbody>\n");

    return result.toString();
  }

  /**
   * wb_𐶐B
   *
   * @param root
   * @param params
   * @param path
   * @param page
   *
   * @return wb_ҏW
   */
  protected String createHeader(Page root, Object[] params,
    String path, String page)
        throws PageReadException, PageWriteException {
    if (!pageManager.existsPage(path, page)) {
      Page info = new Page();

      info.setPath(path);
      info.setTitle(page);
      info.setContent(VIEW_PAGE_MESSAGE_FORMAT.format(params));
      pageManager.putPage(info);
      root.addChild(page);
      pageManager.putPage(root);
    }

    return HEAD_MESSAGE_FORMAT.format(params);
  }

  /**
   * tb^𐶐B
   *
   * @param root
   * @param params
   * @param path
   * @param page
   *
   * @return tb^ҏW
   *
   * @throws PageReadException
   * @throws PageWriteException
   */
  protected String createFooter(Page root, Object[] params,
    String path, String page)
        throws PageReadException, PageWriteException {
    if (DATE_FORMAT.format(new Date()).equals(params[2])) {
      if (!pageManager.existsPage(page)) {
        Page info = new Page();

        info.setPath(path);
        info.setTitle(page);
        info.setContent(EDIT_PAGE_MESSAGE_FORMAT.format(params));
        pageManager.putPage(info);
        root.addChild(page);
        pageManager.putPage(root);
      }

      return FOOT_MESSAGE_FORMAT.format(params);
    }

    return "";
  }

  /**
   * J_쐬B
   *
   * @param path
   * @param page
   *
   * @return J_
   */
  protected String createCalendarTable(String path, String page)
        throws UnsupportedEncodingException, PageReadException {
    StringBuffer result = new StringBuffer();
    Calendar calendar = (Calendar)ym.clone();
    Calendar today = Calendar.getInstance();
    int tMonth = today.get(Calendar.MONTH);
    int tDate = today.get(Calendar.DATE);
    int cMonth = ym.get(Calendar.MONTH);
    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
    int start = dayOfWeek - firstDayOfWeek;

    if (start < 0) {
      start += 7;
    }

    calendar.add(Calendar.DATE, -start);
    String basePath = AbstractPageManager.concatPath(path, page);

    for (int week = 0; week < 6; week++) {
      result.append("<tr>");

      for (int day = 0; day < 7; day++) {
        dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);

        int month = calendar.get(Calendar.MONTH);
        int date = calendar.get(Calendar.DATE);

        if (month == cMonth) {
          if ((month == tMonth) && (date == tDate)) {
            result.append("<td class=\"style_td_today\">");
          } else {
            switch (dayOfWeek) {
            case Calendar.SUNDAY:
              result.append("<td class=\"style_td_sun\">");

              break;

            case Calendar.SATURDAY:
              result.append("<td class=\"style_td_sat\">");

              break;

            default:
              result.append("<td class=\"style_td_day\">");

              break;
            }
          }
        } else {
          result.append("<td>");
        }

        result.append(createDateLink(basePath, calendar));
        result.append("</td>");

        calendar.add(Calendar.DATE, 1);
      }

      result.append("</tr>\n");
    }

    return result.toString();
  }

  /**
   * Ώۂ̓t̃y[W邩ǂmFAꍇɂ̓N𐶐B
   *
   * @param path
   * @param date
   *
   * @return
   */
  protected String createDateLink(String path, Calendar date)
        throws PageReadException, UnsupportedEncodingException {
    MessageFormat PAGE_TITLE = new MessageFormat(title + "({0})");
    String page =
      PAGE_TITLE.format(new Object[] {
          PAGENAME_DATE_FORMAT.format(date.getTime())
        });
    String path_page = AbstractPageManager.concatPath(path, page);

    if (pageManager.existsPage(path_page)) {
      StringBuffer result = new StringBuffer();

      result.append("<a href=\"");
      result.append(this.encodeURL(this.contextPath
          + "/view.do?page="
          + URLEncoder.encode(path_page, config.getUrlEncode())));
      result.append("\">");
      result.append(date.get(Calendar.DATE));
      result.append("</a>");

      if (showSummary) {
        StringBuffer buf = new StringBuffer();

        buf.append("**[[").append(page).append(">");
        buf.append(path_page).append("]]");

        try {
          Page info = pageManager.getPage(path_page);
          LineNumberReader reader =
            new LineNumberReader(new StringReader(info.getContent()));

          String line = reader.readLine();
          String exp = "[[߂>" + path + "]]";

          for (int i = 0; (line != null) && (i < 10); i++) {
            int idx = line.indexOf(exp);

            if (idx >= 0) {
              line =
                line.substring(0, idx)
                + line.substring(idx + exp.length());
            }

            buf.append(line);
            buf.append("\n");
            line = reader.readLine();
          }

          if (reader.readLine() != null) {
            buf.append("[[ǂ...>");
            buf.append(path_page);
            buf.append("]]");
          }

          summary.append(converter.convert(buf.toString()));
        } catch (FileNotFoundException fnfex) {
        } catch (IOException ioex) {
        }
      }

      return result.toString();
    } else {
      return String.valueOf(date.get(Calendar.DATE));
    }
  }

  /**
   * T̍ŏ̗̓jݒ肷B
   *
   * @param dayOfWeek T̍ŏ̗̓j
   */
  protected void setFirstDayOfWeek(int dayOfWeek) {
    firstDayOfWeek = dayOfWeek;
  }

  /**
   * T̍ŏ̗̓jݒ肷B
   *
   * @param dayOfWeek T̍ŏ̗̓j
   */
  protected void setFirstDayOfWeek(String dayOfWeek) {
    if ("sun".equalsIgnoreCase(dayOfWeek)
        || "sunday".equalsIgnoreCase(dayOfWeek)) {
      setFirstDayOfWeek(Calendar.SUNDAY);
    } else if ("mon".equalsIgnoreCase(dayOfWeek)
        || "monday".equalsIgnoreCase(dayOfWeek)) {
      setFirstDayOfWeek(Calendar.MONDAY);
    }
  }

  /**
   * L̃T}\邩ǂݒ肷
   *
   * @param flg
   */
  protected void setShowSummary(String flg) {
    setShowSummary("true".equalsIgnoreCase(flg)
      || "yes".equalsIgnoreCase(flg));
  }

  /**
   * L̃T}\邩ǂݒ肷
   *
   * @param b
   */
  protected void setShowSummary(boolean b) {
    showSummary = b;
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:L\/쐬\n" + " &amp;{0};\n"
    + "&#38;{0}LqƁǍ̃J_[\܂B\n"
    + "̍ۂɁA\"L(yyyy-MM-dd)\"Ƃy[W΁A\n" + "̓tɃN𒣂܂B\n"
    + "܂A\"edit\"NbNƁA\n" + "L̕ҏWy[WɔԂƂł܂B\n" + "\n"
    + " &amp;{0}(N, T̍ŏ̗j, T}\邩ǂ)'{^Cg}';\n"
    + ":N|\J_[̔Nw肵܂BN\"yyyyMM\"̌`Ŏw肵܂B\n"
    + "w肪΁Ǎ̃J_[\܂B\n"
    + ":T̍ŏ̗j|T̍ŏj(\"sunday\")ɂ邩A\n"
    + "j(\"monday\")ɂ邩w肵܂Bw肪΁A\n"
    + "P[Ɉˑ܂B({sundayw肵ꍇƓɂȂ)\n"
    + ":T}\邩ǂ|̈\"true\"w肷ƁA\n" + "̌̓L\܂B\n"
    + "Lꍇɂ́A擪10ŝ݂\܂B\n"
    + ":^Cg|^Cgw肷ƁALy[W̃^CgA\n"
    + "&lt;^Cg&gt; + \"(yyyy-MM-dd)\"̌`ɕς܂B\n"
    + "^Cgw肷邱ƂŁAނ̓LƂł悤ɂȂ܂B\n"
    + "-L\/쐬vOĆAubNvfƂĈׂłB\n"
    + "-L\/쐬vOĆA̗vf̎qvfɂȂ邱Ƃ͂ł܂B\n"
    + "-L\/쐬vOĆA̗vfqvfɂ邱Ƃ͂ł܂B";
  }
}
