/*
 * $Id: Ref.java 297 2004-06-18 06:41:14Z nagasawa $
 */
package cx.ath.kgslab.wiki.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import java.net.URL;

import java.util.zip.GZIPInputStream;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import cx.ath.kgslab.wiki.plugin.exception.PluginException;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;


/**
 * Ytt@CQƃvOC
 *
 * @author VM
 * @version 1.0 
 */
public class Ref extends PluginBase {
  /**
   * HTML
   *
   * @return HTML
   *
   * @see cx.ath.kgslab.wiki.plugin.Plugin#toString()
   */
  public String toHTML() throws PluginException {
    boolean isImage = false;

    String href = params;
    File path = null;

    if (!params.startsWith("http://")) {
      int idx = params.indexOf(',');

      if (idx > 0) {
        page = params.substring(idx + 1);
        params = params.substring(0, idx);
      }

      String[] imgExt = config.getImgExt();

      for (int i = 0; i < imgExt.length; i++) {
        if (isImage = checkExt(params, imgExt[i])) {
          break;
        }
      }

      String dir = page;

      try {
        dir = pageManager.encodePath(page);
      } catch (UnsupportedEncodingException ex) {
        //this.context.log("toString", ex);
        throw new PluginException(ex);
      }

      href = "/upload/" + dir + "/" + params;
      path = new File(config.getUploadPath(), dir + "/" + params);

      href = this.encodeURL(this.contextPath + href);

      if (!path.exists()) {
        throw new PluginException("Ytt@C '" + params
          + "' ͌܂łB");
      }
    }

    String alt =
      ((text != null) && (text.length() > 0)) ? text : params;


    if (isImage) {
      return "<img src=\"" + href + "\" alt=\"" + alt + "\" />";
    } else {
			boolean svgz = checkExt(params, ".svgz");
			boolean svg = checkExt(params, ".svg");
			
			if (svg || svgz) {
				return makeSvgView(href, path, alt, svgz);
			} else {
				return "<a href=\"" + href + "\">" + alt + "</a>";
			}
    }
  }

  private String makeSvgView(String href, File path, String alt, boolean svgz)
    throws FactoryConfigurationError, PluginException {
    try {
      SAXParserFactory factory = SAXParserFactory.newInstance();
    
      factory.setNamespaceAware(true);
      SAXParser parser = factory.newSAXParser();
      InputStream is = null;
    
      if (path != null) {
        is = new FileInputStream(path);
      } else {
        URL url = new URL(href);
    
        is = url.openStream();
      }
    
      // kSVG̏ꍇ́AGZIPWJ|
      if (svgz) {
        is = new GZIPInputStream(is);
      }
    
      SVGHandler handler = new SVGHandler();
    
      parser.parse(new InputSource(is), handler);
    
      return "<object data=\"" + href
      + "\" type=\"image/svg+xml\" width=\"" + handler.width
      + "\" height=\"" + handler.height + "\">" + alt +"<br/>"
      + "ɕ\悤ƂĂ摜SVGłB" + "\ɂ́ASVG Plugin肵ĂB"
      + "<a href=\"http://www.adobe.co.jp/svg/viewer/install/\">Get SVG Plugin!</a>"
      + "</object>";
    } catch (ParserConfigurationException e) {
      throw new PluginException("SVG摜̉͂Ɏs܂B: " + href, e);
    } catch (SAXException e) {
      throw new PluginException("SVG摜̉͂Ɏs܂B: " + href, e);
    } catch (FileNotFoundException e) {
      throw new PluginException("SVG摜̉͂Ɏs܂B: " + href, e);
    } catch (IOException e) {
      throw new PluginException("SVG摜̉͂Ɏs܂B: " + href, e);
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param param DOCUMENT ME!
   * @param ext DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  private boolean checkExt(String param, String ext) {
    String target = param.toLowerCase();
    String tmp = ext.toLowerCase();

    return target.endsWith(tmp);
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:Q(Ytt@CE摜̓\t) \n" + " &amp;{0}(Ytt@C);\n"
    + "s&#38;{0}LqƁA\n" + "Ytt@C܂͎w肳ꂽUR"
    + "Lɂt@Cւ̃N\t邱Ƃł܂B\n"
    + "t@C摜t@C̏ꍇ́Ả摜\܂B&br;\n"
    + "&#38;{0}ɂ́AJ}ŋ؂ĉL̃p^wł܂B\n"
    + "p^ȗꍇ̓ftHglƂȂ܂B\n"
    + " &amp;{0}(Ytt@C, Ytt@C̃y[W)'{֕}';\n"
    + ":Ytt@C̃y[W|Ytt@C݂y[W(WikiNameA BracketName)w肵܂BftHg݂͌̃y[WłB\n"
    + ":֕|t@C̑ɕ\镶摜̑֕wł܂Bw肵Ȃꍇ́At@CɂȂ܂B\n"
    + ":|֕ɂ͕ȊÕCCvf܂߂邱Ƃ͂ł܂BWikiNameBracketNameAȊÕCCvfLqĂƂĈ܂B\n"
    + "-QƃvOĆACCvfƂĈׂłB\n"
    + "-QƃvOĆA̗vf̎qvfɂȂ邱Ƃł܂B\n"
    + "-QƃvOĆÃCCvfqvfɂ邱Ƃł܂B";
  }

  /**
   * SVG̃TCY擾邽߂SAXCxgnh
   */
  public class SVGHandler extends DefaultHandler {
    /** DOCUMENT ME! */
    static final String SVG_NS = "http://www.w3.org/2000/svg";

    /** DOCUMENT ME! */
    int width = 0;

    /** DOCUMENT ME! */
    int height = 0;

    /**
     * @see org.xml.sax.ContentHandler#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
     */
    public void startElement(String uri, String localName,
      String qName, Attributes attributes) throws SAXException {
      if (SVG_NS.equals(uri)) {
        if ("svg".equals(localName)) {
          String width = attributes.getValue("", "width");
          String height = attributes.getValue("", "height");

          this.width = Integer.parseInt(width);
          this.height = Integer.parseInt(height);
        }
      }
    }
  }
}
