/*
 * $Id: Vote.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.plugin;

import java.text.MessageFormat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.exception.PageWriteException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;
import cx.ath.kgslab.wiki.struts.form.PluginForm;

import org.apache.oro.text.perl.Perl5Util;


/**
 * [vOC
 *
 * @author VM
 * @version 1.0 
 */
public class Vote extends PluginBase {
  //  /** vOC("vote") */
  //  private static final String PLUGIN_NAME = "vote";

  /** tH[̃tH[}bg */
  private static final MessageFormat FORM =
    new MessageFormat(
      "<form method=\"post\" action=\"{3}/plugin.do\"><div>\n"
      + " <input type=\"hidden\" name=\"page\" value=\"{0}\" />\n"
      + " <input type=\"hidden\" name=\"plugin\" value=\"{4}\" />\n"
      + " <input type=\"hidden\" name=\"id\" value=\"{1}\" />\n"
      + " <table>\n"
      + "  <thead><tr><th class=\"vote_label\" colspan=\"2\">{1}&nbsp;</th><th class=\"vote_label\">[</th></tr></thead>\n"
      + "{2} </table>\n"
      + " <input type=\"submit\" value=\"[\" /><br />\n"
      + "</div></form>\n");

  //  /**
  //   * vOC擾
  //   *
  //   * @return "vote"
  //   *
  //   * @see cx.ath.kgslab.wiki.plugin.Plugin#getName()
  //   */
  //  public String getName() {
  //    return PLUGIN_NAME;
  //  }

  /**
   * vOCANV
   *
   * @param form vOCtH[
   *
   * @throws PluginException
   *
   * @see cx.ath.kgslab.wiki.plugin.ActionPlugin#action(cx.ath.kgslab.wiki.struts.form.PluginForm)
   */
  public void action(PluginForm form) throws PluginException {
    try {
      Page info = pageManager.getPage(form.getPage());
      String content = info.getContent();
      String id = form.getId();
      Perl5Util match = new Perl5Util();
      String pattern =
        "#&vote\\(([^\\)]+)\\)"
        + (((id != null) && (id.length() > 0)) ? ("{" + id + "}")
                                               : "(?:{[^}]})?")
        + ";#";

      if (match.match(pattern, content)) {
        String pre = match.preMatch();
        String post = match.postMatch();
        String params = match.group(1);
        List list = this.parseParams(params);
        Object[] options = form.getOptions();
        int idx = 0;

        if ((options != null) && (options.length > 0)) {
          idx = Integer.parseInt((String)options[0]);
        }

        Item item = (Item)list.get(idx);

        item.count++;
        Iterator ite = list.iterator();
        StringBuffer buf = new StringBuffer();

        buf.append(pre);
        buf.append("&vote(");
        while (ite.hasNext()) {
          item = (Item)ite.next();
          buf.append(item.item).append('[').append(item.count).append(']');
          if (ite.hasNext()) {
            buf.append(',');
          }
        }

        buf.append(")");
        if ((id != null) && (id.length() > 0)) {
          buf.append('{').append(id).append('}');
        }

        buf.append(';');
        buf.append(post);
        info.setContent(buf.toString());
        pageManager.putPage(info);
      }
    } catch (PageReadException rex) {
      throw new PluginException("y[W̓ǂݍ݂Ɏs܂B", rex);
    } catch (PageWriteException wex) {
      throw new PluginException("y[W݂̏Ɏs܂B", wex);
    }
  }

  /**
   * HTML
   *
   * @return HTML
   *
   * @throws PluginException
   *
   * @see java.lang.Object#toString()
   */
  public String toHTML() throws PluginException {
    String params = this.params;
    List list = parseParams(params);

    if (list.size() <= 1) {
      throw new PluginException("ڂ2ȏw肵ĂB");
    }

    StringBuffer buf = new StringBuffer();
    Iterator ite = list.iterator();
    int idx = 0;
    int cnt = 1;
    Item src = (Item)ite.next();

    while (ite.hasNext()) {
      Item item = (Item)ite.next();

      if (src.count < item.count) {
        idx = cnt;
        src = item;
      }

      cnt++;
    }

    cnt = 0;
    ite = list.iterator();
    while (ite.hasNext()) {
      Item item = (Item)ite.next();
      int rank = 2;

      if (cnt == idx) {
        rank = 1;
      }

      buf.append("  <tr><td class=\"vote_td").append(rank);
      buf.append("\"><input type=\"radio\" name=\"options\" value=\"")
         .append(cnt);
      if (cnt == 0) {
        buf.append("\" checked=\"checked");
      }

      buf.append("\" /></td><td class=\"vote_td").append(rank);
      buf.append("\">");
      buf.append(item.item).append("</td><td class=\"vote_td").append(rank);
      buf.append("\" style=\"text-align:right\">").append(item.count);
      buf.append("</td></tr>\n");
      cnt++;
    }

    return FORM.format(new Object[] {
        this.page,
        this.text,
        buf.toString(),
        this.contextPath,
        this.pluginName,
      });
  }

  /**
   * p[^̉͏
   *
   * @param params p[^
   *
   * @return p[^̃Xg
   *
   * @throws PluginException
   */
  private List parseParams(String params) throws PluginException {
    StringTokenizer tokens = new StringTokenizer(params, ",");
    List list = new ArrayList(tokens.countTokens());

    while (tokens.hasMoreTokens()) {
      String token = tokens.nextToken().trim();
      Item item = new Item();
      String name = token;
      String count = "0";
      int idx = token.indexOf('[');

      if (idx > 0) {
        name = token.substring(0, idx);
        count = token.substring(idx + 1, token.length() - 1);
      }

      item.item = name.trim();
      try {
        item.count =
          ((count != null) && (count.trim().length() > 0))
          ? Integer.parseInt(count) : 0;
      } catch (NumberFormatException e) {
        throw new PluginException("[͐̐lłKv܂B");
      }

      if (item.count < 0) {
        throw new PluginException("[͐̐lłKv܂B");
      }

      list.add(item);
    }

    return list;
  }

  class Item {
    /** ږ */
    String item;

    /** [ */
    int count;
  }

  /**
   * @see cx.ath.kgslab.wiki.plugin.Plugin#getPluginHelp()
   */
  public String getPluginHelp() {
    return "***{0}:[\n" + " &amp;{0}([[],...);\n"
    + "&#38;{0}LqƁAɗ^ڂ̃XgƁA\n" + "u[v{^\܂B\n"
    + "WI{^œ[ڂIA\n" + "u[v{^œ[܂B\n"
    + "&#38;{0}\ty[ŴҏWA\n" + "[JEĝŁA\n"
    + "RɕҏWł悤ȃy[Wł́A\n" + "[ύXłĂ܂܂B\n"
    + "d[̃`FbNȂǂs܂̂ŁA\n" + "mȓ[͂ł܂B\n"
    + "-[vOĆAubNvfƂĈׂłB\n"
    + "-[vOĆA̗vf̎qvfɂȂ邱Ƃ͂ł܂B\n"
    + "-[vOĆA̗vfqvfɂ邱Ƃ͂ł܂B";
  }
}
