/*
 * $Id: PluginAction.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cx.ath.kgslab.wiki.plugin.ActionPlugin;
import cx.ath.kgslab.wiki.plugin.Plugin;
import cx.ath.kgslab.wiki.plugin.exception.PluginException;
import cx.ath.kgslab.wiki.struts.form.PluginForm;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.ActionSupport;


/**
 * JaJaWikĩvOCsANV
 *
 * @author VM
 * @version 2.0 
 * @since JaJaWiki 2.0
 */
public class PluginAction extends ActionSupport {
  /**
   * Method execute
   *
   * @param mapping mapping
   * @param form form
   * @param request request
   * @param response response
   *
   * @return ActionForward
   *
   * @throws Exception
   */
  public ActionForward execute(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    PluginForm pluginForm = (PluginForm)form;

    WebApplicationContext context = this.getWebApplicationContext();

    Plugin plugin =
      (Plugin)context.getBean("plugin_" + pluginForm.getPlugin());

    if (plugin instanceof ActionPlugin) {
      ActionPlugin action = ((ActionPlugin)plugin);

      action.action(pluginForm);
    } else {
      throw new PluginException("vOC <" + pluginForm.getPlugin()
        + "> ́AANVvOCł͂܂B");
    }

    return mapping.findForward("reload");
  }
}
