/*
 * $Id: PreviewAction.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cx.ath.kgslab.webutil.ContextPathUtils;
import cx.ath.kgslab.webutil.UserAgentUtil;
import cx.ath.kgslab.wiki.ConvertHtml;
import cx.ath.kgslab.wiki.SessionUtilImpl;
import cx.ath.kgslab.wiki.struts.form.PageForm;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.ActionSupport;


/**
 * JaJaWikĩvr[[h\ANV
 *
 * @author VM
 * @version 3.0 
 * @since JaJaWiki 1.0
 */
public class PreviewAction extends ActionSupport {
  /**
   * vr[̎
   * <br />
   * Ołœ͂ꂽehtmlɕϊA
   * vr[py[Wɕ\B
   *
   * @param ActionMapping mapping
   * @param ActionForm form
   * @param HttpServletRequest request
   * @param HttpServletResponse response
   * @return ActionForward
   * @throws Exception
   */
  public ActionForward execute(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    PageForm previewForm = (PageForm)form;

    String content = (String)previewForm.getContents();

    WebApplicationContext context = this.getWebApplicationContext();

    // ʂœ͂ꂽeAHTMLɕϊ
    ConvertHtml conv = (ConvertHtml)context.getBean("converter");

    String ua = request.getHeader("User-Agent");

    conv.setUserAgent(UserAgentUtil.checkUserAgent(ua));

    conv.setLocale(request.getLocale());
    conv.setContextPath(ContextPathUtils.getPath(request));
    conv.setSessionUtil(new SessionUtilImpl(response));
    String page = previewForm.getPage();

    String body = conv.convert(page, content);

    previewForm.setBody(body);

    //    System.out.println("content : " + content);
    //    System.out.println("page : " + page);
    //    System.out.println("body : " + body);
    return mapping.findForward("success");
  }
}
