/*
 * $Id: UploadAction.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.struts.form.UploadForm;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.ActionSupport;


/**
 * Ytt@CAbv[hANV
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 1.0
 */
public class UploadAction extends ActionSupport {
  /**
   * Method execute
   *
   * @param mapping mapping
   * @param form form
   * @param request request
   * @param response response
   *
   * @return ActionForward
   *
   * @throws Exception
   */
  public ActionForward execute(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    UploadForm uploadForm = (UploadForm)form;
    FormFile uploadFile = uploadForm.getFile();
    String page = uploadForm.getPage();
    String fileName = uploadForm.getName();
    boolean overwrite = uploadForm.isOverwrite();

    WebApplicationContext context = this.getWebApplicationContext();

    PageManager pm = (PageManager)context.getBean("pageManager");

    pm.attachFile(page, fileName, uploadFile, overwrite);

    return mapping.findForward("success");
  }
}
