/*
 * $Id: ViewAction.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cx.ath.kgslab.webutil.ContextPathUtils;
import cx.ath.kgslab.webutil.UserAgentUtil;
import cx.ath.kgslab.wiki.ConvertHtml;
import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.SessionUtilImpl;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.struts.form.PageForm;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.ActionSupport;


/**
 * JaJaWiki̒ʏ탂[h\ANV
 *
 * @author VM
 * @version 4.0 
 *
 * @since JaJaWiki 1.0
 */
public class ViewAction extends ActionSupport {
  /**
   * Method execute
   *
   * @param mapping mapping
   * @param form form
   * @param request request
   * @param response response
   *
   * @return ActionForward
   *
   * @throws Exception
   */
  public ActionForward execute(ActionMapping mapping,
    ActionForm form, HttpServletRequest request,
    HttpServletResponse response) throws Exception {
    PageForm viewForm = (PageForm)form;
    String page = viewForm.getPage();

    WebApplicationContext context = this.getWebApplicationContext();

    // y[Ww̏ꍇ́AFrontPage\B
    if ((page == null) || (page.length() <= 0)) {
      page =
        ((JaJaWikiConfig)context.getBean("config")).getFrontPageName();
    }

    boolean reload = mapping.getPath().equals("/reload");

    PageManager pm = (PageManager)context.getBean("pageManager");

    if (pm.existsPage(page)) {
      Page info = pm.getPage(page);
      String body = info.getConvertedPage();

      if (reload || (body == null) || (body.length() <= 0)) {
        ConvertHtml conv = (ConvertHtml)context.getBean("converter");

        String ua = request.getHeader("User-Agent");
        int uac = UserAgentUtil.checkUserAgent(ua);

        conv.setUserAgent(uac);
        this.servlet.log("User-Agent " + ua + " / " + uac);

        conv.setLocale(request.getLocale());
        conv.setContextPath(ContextPathUtils.getPath(request));
        conv.setSessionUtil(new SessionUtilImpl(response));
        conv.setPage(page);

        // HTMLɕϊ
        body = conv.convert(info);
      }

      viewForm.setPage(page);

      viewForm.setBody(body);

      return mapping.findForward("success");
    } else {
      // t@CȂ΁At@C̓e쐬邽߁AҏWʂ֔
      viewForm.setContents("");
      viewForm.setLastModified(-1L);
      viewForm.setLock(false);

      return mapping.findForward("notFound");
    }
  }
}
