/*
 * $Id: CounterTag.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.taglib;

import java.text.MessageFormat;

import java.util.Calendar;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.pages.Count;
import cx.ath.kgslab.wiki.pages.Page;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


/**
 * y[WJE^[
 *
 * @author VM
 * @version 3.0 
 * 
 * @since JaJaWiki 1.0
 */
public class CounterTag extends TagSupport {
  /** vANZX */
  private static final String MODE_SIMPLE = "simple";

  /** ̃ANZX */
  private static final String MODE_TODAY = "today";

  /** ̃ANZX */
  private static final String MODE_YESTERDAY = "yesterday";

  /** v//̃ANZX */
  private static final String MODE_DETAILS = "details";

  /** DOCUMENT ME! */
  private static final String DEFAULT_FORMAT =
    "<span class=\"size2\">Access Total : {0}</span><br /><span class=\"size1\">Today : {1}<br />Yesterday : {2}</span>";

  /** y[W */
  private String page = null;

  /** [h */
  private String mode = null;

  /** tH[}bg */
  private String format = DEFAULT_FORMAT;

  /** ReLXg */
  private WebApplicationContext context = null;

  /**
   * Jn^Oł̏
   *
   * @return
   *
   * @throws JspException
   *
   * @see javax.servlet.jsp.tagext.Tag#doStartTag()
   */
  public int doStartTag() throws JspException {
    context =
      WebApplicationContextUtils.getRequiredWebApplicationContext(this.pageContext
        .getServletContext());
    JaJaWikiConfig config = (JaJaWikiConfig)context.getBean("config");

    HttpSession session = this.pageContext.getSession();
    ServletRequest request = this.pageContext.getRequest();

    String thisPage = request.getParameter("page");

    if ((page == null) || (page.trim().length() <= 0)) {
      if ((thisPage != null) && (thisPage.trim().length() > 0)) {
        page = thisPage.trim();
      } else {
        page = config.getFrontPageName();
      }
    }

    if ((format == null) || (format.trim().length() <= 0)) {
      format = DEFAULT_FORMAT;
    }

    String counted = (String)session.getAttribute(page);

    try {
      String result =
        countup(((counted == null) || (counted.trim().length() <= 0)),
          page, format);

      session.setAttribute(page, "counted");
      this.pageContext.getOut().println(result);
    } catch (Exception ioex) {
      throw new JspException("JE^[̗O("
        + ioex.getLocalizedMessage() + ")", ioex);
    }

    this.page = null;
    this.mode = null;
    this.format = null;

    return SKIP_BODY;
  }

  /**
   * JEgAbv
   *
   * @param countup
   * @param page
   * @param format
   *
   * @return
   *
   * @throws Exception
   */
  private String countup(boolean countup, String page, String format)
        throws Exception {
    PageManager pm = (PageManager)context.getBean("pageManager");

    if (pm.existsPage(page)) {
      Count count = null;
      Page info = pm.getPage(page);

      synchronized (info) {
        count = info.getCount();

        Calendar today = Calendar.getInstance();

        if (count == null) {
          count = new Count();

          count.setTotal(0);
          count.setToday(0);
          count.setYesterday(0);
          count.setLastcount(today.getTime());
          info.setCount(count);
        }

        today.clear(Calendar.MILLISECOND);
        today.clear(Calendar.SECOND);
        today.clear(Calendar.MINUTE);
        today.clear(Calendar.HOUR_OF_DAY);

        Calendar last = Calendar.getInstance();

        last.setTimeInMillis(count.getLastcount().getTime());
        last.setTimeZone(today.getTimeZone());
        last.getTimeInMillis();
        last.clear(Calendar.MILLISECOND);
        last.clear(Calendar.SECOND);
        last.clear(Calendar.MINUTE);
        last.clear(Calendar.HOUR_OF_DAY);

        if (today.getTimeInMillis() != last.getTimeInMillis()) {
          for (int i = 0;
              (i < 2)
              && (today.getTimeInMillis() != last.getTimeInMillis());
              i++) {
            last.add(Calendar.DAY_OF_MONTH, 1);
            count.setYesterday(count.getToday());
            count.setToday(0);
          }

          count.setLastcount(today.getTime());
        }

        if (countup) {
          count.setTotal(count.getTotal() + 1);
          count.setToday(count.getToday() + 1);
          pm.putPage(info, false);
        }
      }

      if (MODE_SIMPLE.equals(mode)) {
        return String.valueOf(count.getTotal());
      } else if (MODE_TODAY.equals(mode)) {
        return String.valueOf(count.getToday());
      } else if (MODE_YESTERDAY.equals(mode)) {
        return String.valueOf(count.getYesterday());
      } else {
        return MessageFormat.format(format,
          new String[] {
            String.valueOf(count.getTotal()),
            String.valueOf(count.getToday()),
            String.valueOf(count.getYesterday())
          });
      }
    }

    return "";
  }

  /**
   * y[W̎擾
   *
   * @return
   */
  public String getPage() {
    return page;
  }

  /**
   * y[W̐ݒ
   *
   * @param string
   */
  public void setPage(String string) {
    page = string;
  }

  /**
   * tH[}bg̎擾
   *
   * @return
   */
  public String getFomrat() {
    return format;
  }

  /**
   * [h̎擾
   *
   * @return
   */
  public String getMode() {
    return mode;
  }

  /**
   * tH[}bg̐ݒ
   *
   * @param string
   */
  public void setFomrat(String string) {
    format = string;
  }

  /**
   * [h̐ݒ
   *
   * @param string
   */
  public void setMode(String string) {
    mode = string;
  }
}
