/*
 * $Id: ModifiedContentsTag.java 290 2004-06-16 05:37:18Z nagasawa $
 */
package cx.ath.kgslab.wiki.taglib;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.struts.util.RequestUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import cx.ath.kgslab.util.DateUtils;
import cx.ath.kgslab.webutil.ContextPathUtils;
import cx.ath.kgslab.webutil.UserAgentUtil;
import cx.ath.kgslab.wiki.ConvertHtml;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.SessionUtilImpl;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.pages.Page;
import cx.ath.kgslab.wiki.struts.form.PageForm;


/**
 * ŋߕύXy[W̃Xg\^O
 *
 * @author VM
 * @version 3.1 
 *
 * @since JaJaWiki 1.0
 */
public class ModifiedContentsTag extends TagSupport {
  /** t̃tH[}bg */
  private static final SimpleDateFormat FORMAT =
    new SimpleDateFormat("yyyy-MM-dd");

  /** o͌ */
  private int count = 20;

  /**
   * ^Ȍ
   *
   * @see javax.servlet.jsp.tagext.Tag#doStartTag()
   */
  public int doStartTag() throws JspException {
    //PrintWriter out = new PrintWriter(this.pageContext.getOut());

    HttpServletRequest request =
      (HttpServletRequest)pageContext.getRequest();

    WebApplicationContext context =
      WebApplicationContextUtils.getRequiredWebApplicationContext(this.pageContext
        .getServletContext());
    PageManager pm = (PageManager)context.getBean("pageManager");

    try {
      List list = pm.getModifiedPageList(count);
      StringBuffer buf =
        new StringBuffer("''ŐV" + list.size() + "''\n\n");
      Calendar lastDate = null;
      Iterator iterator = list.iterator();

      while (iterator.hasNext()) {
        Page page = (Page)iterator.next();
        Calendar calendar = Calendar.getInstance();

        calendar.setTime(page.getLastModified());

        calendar.clear(Calendar.MILLISECOND);
        calendar.clear(Calendar.SECOND);
        calendar.clear(Calendar.MINUTE);
        calendar.clear(Calendar.HOUR_OF_DAY);

        if (!DateUtils.equalsDates(calendar, lastDate)) {
          buf.append("\n").append(FORMAT.format(calendar.getTime()))
             .append("\n");
          lastDate = calendar;
        }

        buf.append("-[[");

        String path = page.getPath();

        if (path != null) {
          path = path.trim();
          if (path.startsWith("/")) {
            path = path.substring(1);
          }

          if (path.length() > 0) {
            buf.append(path).append('/');
          }
        }

        buf.append(page.getTitle());
        buf.append("]]\n");
      }

      ConvertHtml conv = (ConvertHtml)context.getBean("converter");
      String ua = request.getHeader("User-Agent");

      conv.setUserAgent(UserAgentUtil.checkUserAgent(ua));

      conv.setLocale(request.getLocale());

      conv.setContextPath(ContextPathUtils.getPath(request));
      conv.setSessionUtil(new SessionUtilImpl(
          (HttpServletResponse)pageContext.getResponse()));

      PageForm form =
        (PageForm)RequestUtils.lookup(pageContext, "form", null);
      String page = null;

      if (form != null) {
        page = form.getPage();
      } else {
        page = request.getParameter("page");
      }

      conv.setPage(page);

      String contents = conv.convert(page, buf.toString());

			this.pageContext.getOut().println(contents);
    } catch (PageReadException e) {
      throw new JspException(e);
    } catch (IOException e) {
      throw new JspException(e);
    }

    return SKIP_BODY;
  }

  /**
   * o͌擾
   *
   * @return o͌
   */
  public int getCount() {
    return count;
  }

  /**
   * o͌ݒ
   *
   * @param i o͌
   */
  public void setCount(int i) {
    count = i;
  }
}
