/*
 * $Id: TitleTag.java 291 2004-06-17 08:21:53Z nagasawa $
 */
package cx.ath.kgslab.wiki.taglib;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import cx.ath.kgslab.wiki.JaJaWikiConfig;


/**
 * ^CgҏW^OCu
 *
 * @author VM
 * @version 1.0 
 *
 * @since JaJaWiki 3.0
 */
public class TitleTag extends TagSupport {
  /** y[W */
  String page = null;

  /**
   * ^Ȍ
   *
   * @return SKIP_BODY
   *
   * @throws JspException
   *
   * @see javax.servlet.jsp.tagext.Tag#doEndTag()
   */
  public int doEndTag() throws JspException {
    WebApplicationContext context =
      WebApplicationContextUtils.getRequiredWebApplicationContext(this.pageContext
        .getServletContext());
    JaJaWikiConfig config = (JaJaWikiConfig)context.getBean("config");

    HttpServletRequest request =
      (HttpServletRequest)pageContext.getRequest();

    if ((page == null) || (page.length() <= 0)) {
      //      PageForm form =
      //        (PageForm)RequestUtils.lookup(pageContext, "form", null);
      //
      //      page = form.getPage();
      page = request.getParameter("page");
      System.out.println("page : " + page);

      if ((page == null) || (page.length() <= 0)) {
        page = config.getFrontPageName();
      }
    }

    //PrintWriter out = new PrintWriter(this.pageContext.getOut());
    String result = getTitle(page);

		try {
      this.pageContext.getOut().print(result);
    } catch (IOException e) {
    	throw new JspException(e);
    }
		page = null;

    return SKIP_BODY;
  }

  /**
   * DOCUMENT ME!
   *
   * @param page DOCUMENT ME!
   *
   * @return DOCUMENT ME!
   */
  public static String getTitle(String page) {
    String result = page;
    int idx = page.lastIndexOf("/");

    if (idx > 0) {
      result = page.substring(idx + 1);
    }

    return result;
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getPage() {
    return page;
  }

  /**
   * DOCUMENT ME!
   *
   * @param page
   */
  public void setPage(String page) {
    System.out.println("setPage : " + page);
    this.page = page;
  }
}
