/*
 * $Id: WikiLinkTag.java 287 2004-06-16 00:12:51Z nagasawa $
 */
package cx.ath.kgslab.wiki.taglib;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import cx.ath.kgslab.webutil.ContextPathUtils;
import cx.ath.kgslab.webutil.UserAgentUtil;
import cx.ath.kgslab.wiki.ConvertHtml;
import cx.ath.kgslab.wiki.SessionUtilImpl;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


/**
 * y[Wւ̃N𐶐B
 *
 * @author VM
 * @version 3.0 
 *
 * @since JaJaWiki 2.0
 */
public class WikiLinkTag extends BodyTagSupport {
  /** DOCUMENT ME! */
  private String page = null;

  /**
   * @see javax.servlet.jsp.tagext.Tag#doEndTag()
   */
  public int doEndTag() throws JspException {
    WebApplicationContext context =
      WebApplicationContextUtils.getRequiredWebApplicationContext(this.pageContext
        .getServletContext());

    HttpServletRequest request =
      (HttpServletRequest)pageContext.getRequest();

    try {
      if ((page == null) || (page.length() <= 0)) {
        page = this.getBodyContent().getString();
      }

      ConvertHtml conv = (ConvertHtml)context.getBean("converter");
      String ua = request.getHeader("User-Agent");

      conv.setUserAgent(UserAgentUtil.checkUserAgent(ua));
      conv.setLocale(request.getLocale());

      conv.setContextPath(ContextPathUtils.getPath(request));
      conv.setPage(page);
      conv.setSessionUtil(new SessionUtilImpl(
          (HttpServletResponse)pageContext.getResponse()));

      this.pageContext.getOut().println(conv.processLinkBraketName(
          null, page));
    } catch (Exception ex) {
      throw new JspException(ex);
    }

    return EVAL_PAGE;
  }

  /**
   * @return
   */
  public String getPage() {
    return page;
  }

  /**
   * @param string
   */
  public void setPage(String string) {
    page = string;
  }
}
