/*
 * $Id$
 */
package cx.ath.kgslab.wiki.timer;

import java.io.File;
import java.io.FilenameFilter;

import java.util.Arrays;
import java.util.Comparator;

import cx.ath.kgslab.wiki.JaJaWikiConfig;
import cx.ath.kgslab.wiki.PageManager;
import cx.ath.kgslab.wiki.exception.PageReadException;
import cx.ath.kgslab.wiki.exception.PageWriteException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import org.springframework.scheduling.quartz.QuartzJobBean;


/**
 * 莞obNAbvWu
 *
 * @author VM
 * @version 1.0 
 * @since JaJaWiki 4.0
 */
public class BackupJob extends QuartzJobBean {
  /** O */
  private Log log = LogFactory.getLog(this.getClass());

  /** obNAbvt@C̍ő吢㐔 */
  private int maxGeneration = 5;

  /** y[W}l[W */
  private PageManager pageManager = null;

  /** JaJaWikiݒ */
  private JaJaWikiConfig config = null;

  /** obNAbvt@CۑfBNg̐΃pX */
  private String backupDir = null;

  /**
   * obNAbv.
   * <br>
   * ÂobNAbvt@C폜A
   * @see org.springframework.scheduling.quartz.QuartzJobBean#executeInternal(org.quartz.JobExecutionContext)
   */
  protected void executeInternal(JobExecutionContext context)
        throws JobExecutionException {
    log.info("obNAbv Jn");
    try {
      File backupPath = config.getBackupPath();

      if ((backupDir != null) && (backupDir.length() > 0)) {
        backupPath = new File(backupDir);
      }

      // obNAbv
      pageManager.backupPages(backupPath);

      // Ǘ
      reduceGenerate(backupPath);

      // Ώۂ̃fBNg蓮obNAbvƈقȂꍇ
      if (!backupPath.equals(config.getBackupPath())) {
        // 蓮obNAbṽfBNgǗs
        reduceGenerate(config.getBackupPath());
      }
    } catch (PageReadException e) {
      throw new JobExecutionException(e);
    } catch (PageWriteException e) {
      throw new JobExecutionException(e);
    }

    log.info("obNAbv I");
  }

  /**
   * Ǘ
   * <br>
   * ÂobNAbvt@C폜B
   *
   * @param backupPath Ώۂ̃fBNg
   */
  private void reduceGenerate(File backupPath) {
    // Ǘ
    log.info("Ǘ Jn");
    File[] files =
      backupPath.listFiles(new FilenameFilter() {
          public boolean accept(File dir, String name) {
            return name.startsWith(config.getBackupfilePrefix())
            && name.endsWith(config.getBackupfileSuffix());
          }
        });

    if (files.length > maxGeneration) {
      // t@C(t@CɓtĂ̂ŌÂ)Ƀ\[g
      Arrays.sort(files,
        new Comparator() {
          public int compare(Object o1, Object o2) {
            File file1 = (File)o1;
            File file2 = (File)o2;
            String name1 = file1.getName();
            String name2 = file2.getName();

            return name1.compareTo(name2);
          }
        });

      // ]vɂ镪폜B
      int cnt = files.length - maxGeneration;

      for (int idx = 0; idx < cnt; idx++) {
        files[idx].delete();
        if (log.isInfoEnabled()) {
          log.info("Ǘ - \"" + files[idx].getName() + "\"폜");
        }
      }
    }

    log.info("Ǘ I");
  }

  /**
   * ő吢㐔̎擾
   * @return ő吢㐔
   */
  public int getMaxGeneration() {
    return maxGeneration;
  }

  /**
   * ő吢㐔̐ݒ
   * @param i ő吢㐔
   */
  public void setMaxGeneration(int i) {
    maxGeneration = i;
  }

  /**
   * y[W}l[W̎擾
   * @return y[W}l[W
   */
  public PageManager getPageManager() {
    return pageManager;
  }

  /**
   * y[W}l[W̐ݒ
   * @param manager y[W}l[W
   */
  public void setPageManager(PageManager manager) {
    pageManager = manager;
  }

  /**
   * JaJaWikiݒ̎擾
   * @return JaJaWikiݒ
   */
  public JaJaWikiConfig getConfig() {
    return config;
  }

  /**
   * JaJaWikiݒ̐ݒ
   * @param config JaJaWikiݒ
   */
  public void setConfig(JaJaWikiConfig config) {
    this.config = config;
  }

  /**
   * @return
   */
  public String getBackupDir() {
    return backupDir;
  }

  /**
   * @param string
   */
  public void setBackupDir(String string) {
    backupDir = string;
  }
}
