/*
 * $Id: Page.java 71 2004-02-27 07:21:29Z nagasawa $
 */
package cx.ath.kgslab.wiki.relaxer.pages;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.*;

import org.w3c.dom.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;


/**
 * <!-- for programmer
 <element java:extends="cx.ath.kgslab.wiki.PageInfo" name="page">
 <attribute name="title">
 <data type="string"/>
 </attribute>
 <attribute name="locked">
 <data type="boolean"/>
 </attribute>
 <attribute name="password">
 <data type="string"/>
 </attribute>
 <optional>
 <attribute java:dataClass="cx.ath.kgslab.xmlutil.DateTime" name="lastModified">
 <data type="dateTime"/>
 </attribute>
 </optional>
 <group>
 <element name="content">
 <text/>
 </element>
 <optional>
 <ref name="count"/>
 </optional>
 <optional>
 <ref name="pathInfo"/>
 </optional>
 </group>
 </element>
 -->
 * <!-- for javadoc -->
 * <b>Page</b> is generated from WikiPages.rng by Relaxer. This class
 * is derived from:
 * <pre> &lt;element java:extends="cx.ath.kgslab.wiki.PageInfo" name="page"&gt;
 *   &lt;attribute name="title"&gt;
 *     &lt;data type="string"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="locked"&gt;
 *     &lt;data type="boolean"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="password"&gt;
 *     &lt;data type="string"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;optional&gt;
 *     &lt;attribute java:dataClass="cx.ath.kgslab.xmlutil.DateTime" name="lastModified"&gt;
 *       &lt;data type="dateTime"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;group&gt;
 *     &lt;element name="content"&gt;
 *       &lt;text/&gt;
 *     &lt;/element&gt;
 *     &lt;optional&gt;
 *       &lt;ref name="count"/&gt;
 *     &lt;/optional&gt;
 *     &lt;optional&gt;
 *       &lt;ref name="pathInfo"/&gt;
 *     &lt;/optional&gt;
 *   &lt;/group&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @author Relaxer 1.0b (http://www.relaxer.org)
 * @version WikiPages.rng (Wed Nov 26 14:58:00 JST 2003)
 */
public class Page extends cx.ath.kgslab.wiki.PageInfo
      implements java.io.Serializable, Cloneable, IRNSContainer,
        IRContentClassHandler, IRNode {
  /** DOCUMENT ME! */
  private RNSContext rNSContext_ =
    new RNSContext(this,
      "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

  /** DOCUMENT ME! */
  private String title_;

  /** DOCUMENT ME! */
  private boolean locked_;

  /** DOCUMENT ME! */
  private String password_;

  /** DOCUMENT ME! */
  private cx.ath.kgslab.xmlutil.DateTime lastModified_;

  /** DOCUMENT ME! */
  private String content_;

  /** DOCUMENT ME! */
  private Count count_;

  /** DOCUMENT ME! */
  private PathInfo pathInfo_;

  /** DOCUMENT ME! */
  private StringBuffer saxBuffer_;

  /** DOCUMENT ME! */
  private IRNode parentRNode_;

  /**
   * Creates a <code>Page</code>.
   */
  public Page() {
    title_ = "";
    password_ = "";
    content_ = "";
    pathInfo_ = new PathInfo();
  }

  /**
   * Creates a <code>Page</code>.
   *
   * @param source
   */
  public Page(Page source) {
    setup(source);
  }

  /**
   * Creates a <code>Page</code> by the Stack <code>stack</code> that
   * contains Elements. This constructor is supposed to be used
   * internally by the Relaxer system.
   *
   * @param stack
   */
  public Page(RStack stack) {
    setup(stack);
  }

  /**
   * Creates a <code>Page</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public Page(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Creates a <code>Page</code> by the Element <code>element</code>.
   *
   * @param element
   */
  public Page(Element element) {
    setup(element);
  }

  /**
   * Creates a <code>Page</code> by the File <code>file</code>.
   *
   * @param file
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Page(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file);
  }

  /**
   * Creates a <code>Page</code> by the String representation of URI
   * <code>uri</code>.
   *
   * @param uri
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Page(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(uri);
  }

  /**
   * Creates a <code>Page</code> by the URL <code>url</code>.
   *
   * @param url
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Page(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(url);
  }

  /**
   * Creates a <code>Page</code> by the InputStream <code>in</code>.
   *
   * @param in
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Page(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(in);
  }

  /**
   * Creates a <code>Page</code> by the InputSource <code>is</code>.
   *
   * @param is
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Page(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(is);
  }

  /**
   * Creates a <code>Page</code> by the Reader <code>reader</code>.
   *
   * @param reader
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Page(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(reader);
  }

  /**
   * Initializes the <code>Page</code> by the Page
   * <code>source</code>.
   *
   * @param source
   */
  public void setup(Page source) {
    int size;

    setTitle(source.getTitle());
    setLocked(source.getLocked());
    setPassword(source.getPassword());
    setLastModified(source.getLastModified());
    setContent(source.getContent());
    setCount((Count)source.getCount().clone());
    setPathInfo((PathInfo)source.getPathInfo().clone());
  }

  /**
   * Initializes the <code>Page</code> by the Document
   * <code>doc</code>.
   *
   * @param doc
   */
  public void setup(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Initializes the <code>Page</code> by the Element
   * <code>element</code>.
   *
   * @param element
   */
  public void setup(Element element) {
    init(element);
  }

  /**
   * Initializes the <code>Page</code> by the Stack
   * <code>stack</code> that contains Elements. This constructor is
   * supposed to be used internally by the Relaxer system.
   *
   * @param stack
   */
  public void setup(RStack stack) {
    init(stack.popElement());
  }

  /**
   * DOCUMENT ME!
   *
   * @param element
   */
  private void init(Element element) {
    RStack stack = new RStack(element);

    rNSContext_.declareNamespace(element);
    title_ = URelaxer.getAttributePropertyAsString(element, "title");
    locked_ =
      URelaxer.getAttributePropertyAsBoolean(element, "locked");
    password_ =
      URelaxer.getAttributePropertyAsString(element, "password");
    lastModified_ =
      new cx.ath.kgslab.xmlutil.DateTime(URelaxer
        .getAttributePropertyAsString(element, "lastModified"));
    content_ =
      URelaxer.getElementPropertyAsString(stack.popElement());

    if (Count.isMatch(stack)) {
      setCount(new Count(stack));
    }

    if (PathInfo.isMatch(stack)) {
      setPathInfo(new PathInfo(stack));
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @return Object
   */
  public Object clone() {
    return (new Page(this));
  }

  /**
   * Creates a DOM representation of the object. Result is appended
   * to the Node <code>parent</code>.
   *
   * @param parent
   */
  public void makeElement(Node parent) {
    Document doc;

    if (parent instanceof Document) {
      doc = (Document)parent;
    } else {
      doc = parent.getOwnerDocument();
    }

    Element element =
      doc.createElementNS("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
        "page");

    rNSContext_.setupNamespace(element);

    int size;

    if (this.title_ != null) {
      URelaxer.setAttributePropertyByString(element, "title",
        this.title_);
    }

    URelaxer.setAttributePropertyByBoolean(element, "locked",
      this.locked_);

    if (this.password_ != null) {
      URelaxer.setAttributePropertyByString(element, "password",
        this.password_);
    }

    if (this.lastModified_ != null) {
      URelaxer.setAttributePropertyByString(element, "lastModified",
        this.lastModified_.toString());
    }

    URelaxer2.setElementPropertyByString(element,
      "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages", "content",
      this.content_, rNSContext_);

    if (this.count_ != null) {
      this.count_.makeElement(element);
    }

    if (this.pathInfo_ != null) {
      this.pathInfo_.makeElement(element);
    }

    parent.appendChild(element);
  }

  /**
   * Initializes the <code>Page</code> by the File <code>file</code>.
   *
   * @param file
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file.toURL());
  }

  /**
   * Initializes the <code>Page</code> by the String representation
   * of URI <code>uri</code>.
   *
   * @param uri
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Page</code> by the URL <code>url</code>.
   *
   * @param url
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Page</code> by the InputStream
   * <code>in</code>.
   *
   * @param in
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Page</code> by the InputSource
   * <code>is</code>.
   *
   * @param is
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Page</code> by the Reader
   * <code>reader</code>.
   *
   * @param reader
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Creates a DOM document representation of the object.
   *
   * @return Document
   *
   * @exception ParserConfigurationException
   */
  public Document makeDocument() throws ParserConfigurationException {
    Document doc = UJAXP.makeDocument();

    makeElement(doc);

    return (doc);
  }

  /**
   * Gets the RNSContext property <b>RNSContext</b>.
   *
   * @return RNSContext
   */
  public final RNSContext rGetRNSContext() {
    return (rNSContext_);
  }

  /**
   * Sets the RNSContext property <b>RNSContext</b>.
   *
   * @param rNSContext
   */
  public final void rSetRNSContext(RNSContext rNSContext) {
    this.rNSContext_ = rNSContext;
  }

  /**
   * Gets the String property <b>title</b>.
   *
   * @return String
   */
  public final String getTitle() {
    return (title_);
  }

  /**
   * Sets the String property <b>title</b>.
   *
   * @param title
   */
  public final void setTitle(String title) {
    this.title_ = title;
  }

  /**
   * Gets the boolean property <b>locked</b>.
   *
   * @return boolean
   */
  public final boolean getLocked() {
    return (locked_);
  }

  /**
   * Sets the boolean property <b>locked</b>.
   *
   * @param locked
   */
  public final void setLocked(boolean locked) {
    this.locked_ = locked;
  }

  /**
   * Gets the String property <b>password</b>.
   *
   * @return String
   */
  public final String getPassword() {
    return (password_);
  }

  /**
   * Sets the String property <b>password</b>.
   *
   * @param password
   */
  public final void setPassword(String password) {
    this.password_ = password;
  }

  /**
   * Gets the cx.ath.kgslab.xmlutil.DateTime property
   * <b>lastModified</b>.
   *
   * @return cx.ath.kgslab.xmlutil.DateTime
   */
  public final cx.ath.kgslab.xmlutil.DateTime getLastModified() {
    return (lastModified_);
  }

  /**
   * Sets the cx.ath.kgslab.xmlutil.DateTime property
   * <b>lastModified</b>.
   *
   * @param lastModified
   */
  public final void setLastModified(
    cx.ath.kgslab.xmlutil.DateTime lastModified) {
    this.lastModified_ = lastModified;
  }

  /**
   * Gets the String property <b>content</b>.
   *
   * @return String
   */
  public final String getContent() {
    return (content_);
  }

  /**
   * Sets the String property <b>content</b>.
   *
   * @param content
   */
  public final void setContent(String content) {
    this.content_ = content;
  }

  /**
   * Gets the Count property <b>count</b>.
   *
   * @return Count
   */
  public final Count getCount() {
    return (count_);
  }

  /**
   * Sets the Count property <b>count</b>.
   *
   * @param count
   */
  public final void setCount(Count count) {
    this.count_ = count;

    if (count != null) {
      count.rSetParentRNode(this);
    }
  }

  /**
   * Gets the PathInfo property <b>pathInfo</b>.
   *
   * @return PathInfo
   */
  public final PathInfo getPathInfo() {
    return (pathInfo_);
  }

  /**
   * Sets the PathInfo property <b>pathInfo</b>.
   *
   * @param pathInfo
   */
  public final void setPathInfo(PathInfo pathInfo) {
    this.pathInfo_ = pathInfo;

    if (pathInfo != null) {
      pathInfo.rSetParentRNode(this);
    }
  }

  /**
   * Makes an XML text representation.
   *
   * @return String
   */
  public String makeTextDocument() {
    StringBuffer buffer = new StringBuffer();

    makeTextElement(buffer);

    return (new String(buffer));
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(StringBuffer buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.append("<");
    URelaxer.makeQName(prefix, "page", buffer);
    rNSContext_.makeNSMappings(buffer);

    if (title_ != null) {
      buffer.append(" ");
      buffer.append("title");
      buffer.append("=\"");
      buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(
            getTitle())));
      buffer.append("\"");
    }

    buffer.append(" ");
    buffer.append("locked");
    buffer.append("=\"");
    buffer.append(URelaxer.getString(getLocked()));
    buffer.append("\"");

    if (password_ != null) {
      buffer.append(" ");
      buffer.append("password");
      buffer.append("=\"");
      buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(
            getPassword())));
      buffer.append("\"");
    }

    if (lastModified_ != null) {
      buffer.append(" ");
      buffer.append("lastModified");
      buffer.append("=\"");
      buffer.append(URelaxer.getString(getLastModified()));
      buffer.append("\"");
    }

    buffer.append(">");
    buffer.append("<");
    URelaxer.makeQName(prefix, "content", buffer);
    buffer.append(">");
    buffer.append(URelaxer.escapeCharData(URelaxer.getString(
          getContent())));
    buffer.append("</");
    URelaxer.makeQName(prefix, "content", buffer);
    buffer.append(">");

    if (count_ != null) {
      count_.makeTextElement(buffer);
    }

    if (pathInfo_ != null) {
      pathInfo_.makeTextElement(buffer);
    }

    buffer.append("</");
    URelaxer.makeQName(prefix, "page", buffer);
    buffer.append(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   *
   * @exception IOException
   */
  public void makeTextElement(Writer buffer) throws IOException {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.write("<");
    URelaxer.makeQName(prefix, "page", buffer);
    rNSContext_.makeNSMappings(buffer);

    if (title_ != null) {
      buffer.write(" ");
      buffer.write("title");
      buffer.write("=\"");
      buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(
            getTitle())));
      buffer.write("\"");
    }

    buffer.write(" ");
    buffer.write("locked");
    buffer.write("=\"");
    buffer.write(URelaxer.getString(getLocked()));
    buffer.write("\"");

    if (password_ != null) {
      buffer.write(" ");
      buffer.write("password");
      buffer.write("=\"");
      buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(
            getPassword())));
      buffer.write("\"");
    }

    if (lastModified_ != null) {
      buffer.write(" ");
      buffer.write("lastModified");
      buffer.write("=\"");
      buffer.write(URelaxer.getString(getLastModified()));
      buffer.write("\"");
    }

    buffer.write(">");
    buffer.write("<");
    URelaxer.makeQName(prefix, "content", buffer);
    buffer.write(">");
    buffer.write(URelaxer.escapeCharData(URelaxer.getString(
          getContent())));
    buffer.write("</");
    URelaxer.makeQName(prefix, "content", buffer);
    buffer.write(">");

    if (count_ != null) {
      count_.makeTextElement(buffer);
    }

    if (pathInfo_ != null) {
      pathInfo_.makeTextElement(buffer);
    }

    buffer.write("</");
    URelaxer.makeQName(prefix, "page", buffer);
    buffer.write(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(PrintWriter buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.print("<");
    URelaxer.makeQName(prefix, "page", buffer);
    rNSContext_.makeNSMappings(buffer);

    if (title_ != null) {
      buffer.print(" ");
      buffer.print("title");
      buffer.print("=\"");
      buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(
            getTitle())));
      buffer.print("\"");
    }

    buffer.print(" ");
    buffer.print("locked");
    buffer.print("=\"");
    buffer.print(URelaxer.getString(getLocked()));
    buffer.print("\"");

    if (password_ != null) {
      buffer.print(" ");
      buffer.print("password");
      buffer.print("=\"");
      buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(
            getPassword())));
      buffer.print("\"");
    }

    if (lastModified_ != null) {
      buffer.print(" ");
      buffer.print("lastModified");
      buffer.print("=\"");
      buffer.print(URelaxer.getString(getLastModified()));
      buffer.print("\"");
    }

    buffer.print(">");
    buffer.print("<");
    URelaxer.makeQName(prefix, "content", buffer);
    buffer.print(">");
    buffer.print(URelaxer.escapeCharData(URelaxer.getString(
          getContent())));
    buffer.print("</");
    URelaxer.makeQName(prefix, "content", buffer);
    buffer.print(">");

    if (count_ != null) {
      count_.makeTextElement(buffer);
    }

    if (pathInfo_ != null) {
      pathInfo_.makeTextElement(buffer);
    }

    buffer.print("</");
    URelaxer.makeQName(prefix, "page", buffer);
    buffer.print(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(StringBuffer buffer) {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   *
   * @exception IOException
   */
  public void makeTextAttribute(Writer buffer) throws IOException {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(PrintWriter buffer) {
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getTitleAsString() {
    return (URelaxer.getString(getTitle()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getLockedAsString() {
    return (URelaxer.getString(getLocked()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getPasswordAsString() {
    return (URelaxer.getString(getPassword()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getLastModifiedAsString() {
    return (URelaxer.getString(getLastModified()));
  }

  /**
   * Gets the property value as String.
   *
   * @return String
   */
  public String getContentAsString() {
    return (URelaxer.getString(getContent()));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setTitleByString(String string) {
    setTitle(string);
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setLockedByString(String string) {
    setLocked(new Boolean(string).booleanValue());
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setPasswordByString(String string) {
    setPassword(string);
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setLastModifiedByString(String string) {
    setLastModified(new cx.ath.kgslab.xmlutil.DateTime(string));
  }

  /**
   * Sets the property value by String.
   *
   * @param string
   */
  public void setContentByString(String string) {
    setContent(string);
  }

  /**
   * Returns a String representation of this object. While this
   * method informs as XML format representaion, it's purpose is
   * just information, not making a rigid XML documentation.
   *
   * @return String
   */
  public String toString() {
    try {
      return (makeTextDocument());
    } catch (Exception e) {
      return (super.toString());
    }
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   *
   * @exception SAXException
   */
  public void makeDocument(ContentHandler handler)
        throws SAXException {
    handler.startDocument();
    makeElement(handler);
    handler.endDocument();
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   *
   * @exception SAXException
   */
  public void makeElement(ContentHandler handler) throws SAXException {
    rNSContext_.startNSMappings(handler);

    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");
    int size;
    String string;
    String slotQName;
    AttributesImpl nullAttrs = new AttributesImpl();
    AttributesImpl attrs = new AttributesImpl();

    attrs.addAttribute("", "title", "title", "CDATA",
      URelaxer.getString(getTitle()));
    attrs.addAttribute("", "locked", "locked", "CDATA",
      URelaxer.getString(getLocked()));
    attrs.addAttribute("", "password", "password", "CDATA",
      URelaxer.getString(getPassword()));

    if (lastModified_ != null) {
      attrs.addAttribute("", "lastModified", "lastModified", "CDATA",
        URelaxer.getString(getLastModified()));
    }

    String qName = URelaxer.getQName(prefix, "page");

    handler.startElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "page", qName, attrs);
    slotQName = URelaxer.getQName(prefix, "content");
    handler.startElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "content", slotQName, nullAttrs);
    string = URelaxer.getString(getContent());
    handler.characters(string.toCharArray(), 0, string.length());
    handler.endElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "content", slotQName);

    if (count_ != null) {
      count_.makeElement(handler);
    }

    if (pathInfo_ != null) {
      pathInfo_.makeElement(handler);
    }

    handler.endElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "page", qName);
    rNSContext_.endNSMappings(handler);
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param attrs
   *
   * @exception SAXException
   */
  public void makeAttribute(AttributesImpl attrs) throws SAXException {
  }

  /**
   * Event handler for InitElement during object construction.
   *
   * @param attrs
   */
  public void initElement(Attributes attrs) {
    String string;

    string = attrs.getValue("title");
    setTitle(string);
    string = attrs.getValue("locked");
    setLocked(new Boolean(string).booleanValue());
    string = attrs.getValue("password");
    setPassword(string);
    string = attrs.getValue("lastModified");

    if (string != null) {
      setLastModified(new cx.ath.kgslab.xmlutil.DateTime(string));
    }
  }

  /**
   * Event handler for declarePrefixMapping during object
   * construction.
   *
   * @param prefix
   * @param uri
   */
  public void declarePrefixMapping(String prefix, String uri) {
    rNSContext_.declareNamespace(prefix, uri);
  }

  /**
   * Event handler for startElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @param attrs
   *
   * @return IRContentClassHandler
   */
  public IRContentClassHandler startElement(String namespaceURI,
    String localName, String qName, Attributes attrs) {
    if ("content".equals(localName)
          && "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages".equals(
            namespaceURI)) {
      saxBuffer_ = new StringBuffer();

      return (this);
    }

    if ("count".equals(localName)
          && "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages".equals(
            namespaceURI)) {
      Count ref = new Count();

      ref.initElement(attrs);
      setCount(ref);

      return (ref);
    }

    if ("pathInfo".equals(localName)
          && "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages".equals(
            namespaceURI)) {
      PathInfo ref = new PathInfo();

      ref.initElement(attrs);
      setPathInfo(ref);

      return (ref);
    }

    return (this);
  }

  /**
   * Event handler for endElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   *
   * @return IRContentClassHandler
   */
  public IRContentClassHandler endElement(String namespaceURI,
    String localName, String qName) {
    String string;

    if ("content".equals(localName)
          && "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages".equals(
            namespaceURI)) {
      string = new String(saxBuffer_);
      setContent(string);

      return (this);
    }

    return ((IRContentClassHandler)rGetParentRNode());
  }

  /**
   * Event handler for characters during object construction.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void characters(char[] ch, int start, int length) {
    if (saxBuffer_ != null) {
      saxBuffer_.append(ch, start, length);
    }
  }

  /**
   * Event handler for processngInstruction during object
   * construction.
   *
   * @param target
   * @param value
   */
  public void processingInstruction(String target, String value) {
  }

  /**
   * Gets the IRNode property <b>parentRNode</b>.
   *
   * @return IRNode
   */
  public final IRNode rGetParentRNode() {
    return (parentRNode_);
  }

  /**
   * Sets the IRNode property <b>parentRNode</b>.
   *
   * @param parentRNode
   */
  public final void rSetParentRNode(IRNode parentRNode) {
    this.parentRNode_ = parentRNode;
  }

  /**
   * Gets child RNodes.
   *
   * @return IRNode[]
   */
  public IRNode[] rGetRNodes() {
    java.util.List classNodes = new java.util.ArrayList();

    if (count_ != null) {
      classNodes.add(count_);
    }

    if (pathInfo_ != null) {
      classNodes.add(pathInfo_);
    }

    IRNode[] nodes = new IRNode[classNodes.size()];

    return ((IRNode[])classNodes.toArray(nodes));
  }

  /**
   * Tests if a Element <code>element</code> is valid for the
   * <code>Page</code>.
   *
   * @param element
   *
   * @return boolean
   */
  public static boolean isMatch(Element element) {
    if (!URelaxer2.isTargetElement(element,
            "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages", "page")) {
      return (false);
    }

    RStack target = new RStack(element);
    boolean $match$ = false;
    Element child;

    if (!URelaxer.hasAttributeHungry(target, "title")) {
      return (false);
    }

    $match$ = true;

    if (!URelaxer.hasAttributeHungry(target, "locked")) {
      return (false);
    }

    $match$ = true;

    if (!URelaxer.hasAttributeHungry(target, "password")) {
      return (false);
    }

    $match$ = true;
    child = target.popElement();

    if (child == null) {
      return (false);
    }

    if (!URelaxer2.isTargetElement(child,
            "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
            "content")) {
      return (false);
    }

    $match$ = true;

    if (Count.isMatchHungry(target)) {
    }

    if (PathInfo.isMatchHungry(target)) {
    }

    if (!target.isEmptyElement()) {
      return (false);
    }

    return (true);
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code> is
   * valid for the <code>Page</code>. This mehtod is supposed to be
   * used internally by the Relaxer system.
   *
   * @param stack
   *
   * @return boolean
   */
  public static boolean isMatch(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    return (isMatch(element));
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code> is
   * valid for the <code>Page</code>. This method consumes the stack
   * contents during matching operation. This mehtod is supposed to
   * be used internally by the Relaxer system.
   *
   * @param stack
   *
   * @return boolean
   */
  public static boolean isMatchHungry(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    if (isMatch(element)) {
      stack.popElement();

      return (true);
    } else {
      return (false);
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public String getPath() {
    return pathInfo_.getPath();
  }

  /**
   * DOCUMENT ME!
   *
   * @param path
   */
  public void setPath(String path) {
    pathInfo_.setPath(path);
  }

  /**
   * DOCUMENT ME!
   *
   * @return
   */
  public Child[] getChild() {
    return pathInfo_.getChild();
  }

  /**
   * DOCUMENT ME!
   *
   * @param childValue
   */
  public void setChild(Child[] childValue) {
    pathInfo_.setChild(childValue);
  }
}
