/*
 * $Id: Pages.java 71 2004-02-27 07:21:29Z nagasawa $
 */
package cx.ath.kgslab.wiki.relaxer.pages;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.*;

import org.w3c.dom.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;


/**
 * <!-- for programmer
 <element name="pages">
 <zeroOrMore>
 <ref name="page"/>
 </zeroOrMore>
 </element>
 -->
 * <!-- for javadoc -->
 * <b>Pages</b> is generated from WikiPages.rng by Relaxer. This
 * class is derived from:
 * <pre> &lt;element name="pages"&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="page"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @author Relaxer 1.0b (http://www.relaxer.org)
 * @version WikiPages.rng (Wed Nov 26 14:58:00 JST 2003)
 */
public class Pages implements java.io.Serializable, Cloneable,
  IRNSContainer, IRContentClassHandler, IRNode {
  /** DOCUMENT ME! */
  private RNSContext rNSContext_ =
    new RNSContext(this,
      "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

  // List<Page>

  /** DOCUMENT ME! */
  private java.util.List page_ = new java.util.ArrayList();

  /** DOCUMENT ME! */
  private StringBuffer saxBuffer_;

  /** DOCUMENT ME! */
  private IRNode parentRNode_;

  /**
   * Creates a <code>Pages</code>.
   */
  public Pages() {
  }

  /**
   * Creates a <code>Pages</code>.
   *
   * @param source
   */
  public Pages(Pages source) {
    setup(source);
  }

  /**
   * Creates a <code>Pages</code> by the Stack <code>stack</code>
   * that contains Elements. This constructor is supposed to be used
   * internally by the Relaxer system.
   *
   * @param stack
   */
  public Pages(RStack stack) {
    setup(stack);
  }

  /**
   * Creates a <code>Pages</code> by the Document <code>doc</code>.
   *
   * @param doc
   */
  public Pages(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Creates a <code>Pages</code> by the Element
   * <code>element</code>.
   *
   * @param element
   */
  public Pages(Element element) {
    setup(element);
  }

  /**
   * Creates a <code>Pages</code> by the File <code>file</code>.
   *
   * @param file
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Pages(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file);
  }

  /**
   * Creates a <code>Pages</code> by the String representation of URI
   * <code>uri</code>.
   *
   * @param uri
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Pages(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(uri);
  }

  /**
   * Creates a <code>Pages</code> by the URL <code>url</code>.
   *
   * @param url
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Pages(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(url);
  }

  /**
   * Creates a <code>Pages</code> by the InputStream <code>in</code>.
   *
   * @param in
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Pages(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(in);
  }

  /**
   * Creates a <code>Pages</code> by the InputSource <code>is</code>.
   *
   * @param is
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Pages(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(is);
  }

  /**
   * Creates a <code>Pages</code> by the Reader <code>reader</code>.
   *
   * @param reader
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public Pages(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(reader);
  }

  /**
   * Initializes the <code>Pages</code> by the Pages
   * <code>source</code>.
   *
   * @param source
   */
  public void setup(Pages source) {
    int size;

    this.page_.clear();
    size = source.page_.size();

    for (int i = 0; i < size; i++) {
      addPage((Page)source.getPage(i).clone());
    }
  }

  /**
   * Initializes the <code>Pages</code> by the Document
   * <code>doc</code>.
   *
   * @param doc
   */
  public void setup(Document doc) {
    setup(doc.getDocumentElement());
  }

  /**
   * Initializes the <code>Pages</code> by the Element
   * <code>element</code>.
   *
   * @param element
   */
  public void setup(Element element) {
    init(element);
  }

  /**
   * Initializes the <code>Pages</code> by the Stack
   * <code>stack</code> that contains Elements. This constructor is
   * supposed to be used internally by the Relaxer system.
   *
   * @param stack
   */
  public void setup(RStack stack) {
    init(stack.popElement());
  }

  /**
   * DOCUMENT ME!
   *
   * @param element
   */
  private void init(Element element) {
    RStack stack = new RStack(element);

    rNSContext_.declareNamespace(element);
    page_.clear();

    while (true) {
      if (Page.isMatch(stack)) {
        addPage(new Page(stack));
      } else {
        break;
      }
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @return Object
   */
  public Object clone() {
    return (new Pages(this));
  }

  /**
   * Creates a DOM representation of the object. Result is appended
   * to the Node <code>parent</code>.
   *
   * @param parent
   */
  public void makeElement(Node parent) {
    Document doc;

    if (parent instanceof Document) {
      doc = (Document)parent;
    } else {
      doc = parent.getOwnerDocument();
    }

    Element element =
      doc.createElementNS("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
        "pages");

    rNSContext_.setupNamespace(element);

    int size;

    size = this.page_.size();

    for (int i = 0; i < size; i++) {
      Page value = (Page)this.page_.get(i);

      value.makeElement(element);
    }

    parent.appendChild(element);
  }

  /**
   * Initializes the <code>Pages</code> by the File
   * <code>file</code>.
   *
   * @param file
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(File file)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(file.toURL());
  }

  /**
   * Initializes the <code>Pages</code> by the String representation
   * of URI <code>uri</code>.
   *
   * @param uri
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(String uri)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Pages</code> by the URL <code>url</code>.
   *
   * @param url
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(URL url)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Pages</code> by the InputStream
   * <code>in</code>.
   *
   * @param in
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputStream in)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Pages</code> by the InputSource
   * <code>is</code>.
   *
   * @param is
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(InputSource is)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Initializes the <code>Pages</code> by the Reader
   * <code>reader</code>.
   *
   * @param reader
   *
   * @exception IOException
   * @exception SAXException
   * @exception ParserConfigurationException
   */
  public void setup(Reader reader)
        throws IOException, SAXException, 
          ParserConfigurationException {
    setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
  }

  /**
   * Creates a DOM document representation of the object.
   *
   * @return Document
   *
   * @exception ParserConfigurationException
   */
  public Document makeDocument() throws ParserConfigurationException {
    Document doc = UJAXP.makeDocument();

    makeElement(doc);

    return (doc);
  }

  /**
   * Gets the RNSContext property <b>RNSContext</b>.
   *
   * @return RNSContext
   */
  public final RNSContext rGetRNSContext() {
    return (rNSContext_);
  }

  /**
   * Sets the RNSContext property <b>RNSContext</b>.
   *
   * @param rNSContext
   */
  public final void rSetRNSContext(RNSContext rNSContext) {
    this.rNSContext_ = rNSContext;
  }

  /**
   * Gets the Page property <b>page</b>.
   *
   * @return Page[]
   */
  public final Page[] getPage() {
    Page[] array = new Page[page_.size()];

    return ((Page[])page_.toArray(array));
  }

  /**
   * Sets the Page property <b>page</b>.
   *
   * @param page
   */
  public final void setPage(Page[] page) {
    this.page_.clear();

    for (int i = 0; i < page.length; i++) {
      addPage(page[i]);
    }

    for (int i = 0; i < page.length; i++) {
      page[i].rSetParentRNode(this);
    }
  }

  /**
   * Sets the Page property <b>page</b>.
   *
   * @param page
   */
  public final void setPage(Page page) {
    this.page_.clear();
    addPage(page);

    if (page != null) {
      page.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Page property <b>page</b>.
   *
   * @param page
   */
  public final void addPage(Page page) {
    this.page_.add(page);

    if (page != null) {
      page.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Page property <b>page</b>.
   *
   * @param page
   */
  public final void addPage(Page[] page) {
    for (int i = 0; i < page.length; i++) {
      addPage(page[i]);
    }

    for (int i = 0; i < page.length; i++) {
      page[i].rSetParentRNode(this);
    }
  }

  /**
   * Gets number of the Page property <b>page</b>.
   *
   * @return int
   */
  public final int sizePage() {
    return (page_.size());
  }

  /**
   * Gets the Page property <b>page</b> by index.
   *
   * @param index
   *
   * @return Page
   */
  public final Page getPage(int index) {
    return ((Page)page_.get(index));
  }

  /**
   * Sets the Page property <b>page</b> by index.
   *
   * @param index
   * @param page
   */
  public final void setPage(int index, Page page) {
    this.page_.set(index, page);

    if (page != null) {
      page.rSetParentRNode(this);
    }
  }

  /**
   * Adds the Page property <b>page</b> by index.
   *
   * @param index
   * @param page
   */
  public final void addPage(int index, Page page) {
    this.page_.add(index, page);

    if (page != null) {
      page.rSetParentRNode(this);
    }
  }

  /**
   * Remove the Page property <b>page</b> by index.
   *
   * @param index
   */
  public final void removePage(int index) {
    this.page_.remove(index);
  }

  /**
   * Remove the Page property <b>page</b> by object.
   *
   * @param page
   */
  public final void removePage(Page page) {
    this.page_.remove(page);
  }

  /**
   * Clear the Page property <b>page</b>.
   */
  public final void clearPage() {
    this.page_.clear();
  }

  /**
   * Makes an XML text representation.
   *
   * @return String
   */
  public String makeTextDocument() {
    StringBuffer buffer = new StringBuffer();

    makeTextElement(buffer);

    return (new String(buffer));
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(StringBuffer buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.append("<");
    URelaxer.makeQName(prefix, "pages", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.append(">");
    size = this.page_.size();

    for (int i = 0; i < size; i++) {
      Page value = (Page)this.page_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.append("</");
    URelaxer.makeQName(prefix, "pages", buffer);
    buffer.append(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   *
   * @exception IOException
   */
  public void makeTextElement(Writer buffer) throws IOException {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.write("<");
    URelaxer.makeQName(prefix, "pages", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.write(">");
    size = this.page_.size();

    for (int i = 0; i < size; i++) {
      Page value = (Page)this.page_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.write("</");
    URelaxer.makeQName(prefix, "pages", buffer);
    buffer.write(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextElement(PrintWriter buffer) {
    int size;
    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");

    buffer.print("<");
    URelaxer.makeQName(prefix, "pages", buffer);
    rNSContext_.makeNSMappings(buffer);
    buffer.print(">");
    size = this.page_.size();

    for (int i = 0; i < size; i++) {
      Page value = (Page)this.page_.get(i);

      value.makeTextElement(buffer);
    }

    buffer.print("</");
    URelaxer.makeQName(prefix, "pages", buffer);
    buffer.print(">");
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(StringBuffer buffer) {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   *
   * @exception IOException
   */
  public void makeTextAttribute(Writer buffer) throws IOException {
  }

  /**
   * Makes an XML text representation.
   *
   * @param buffer
   */
  public void makeTextAttribute(PrintWriter buffer) {
  }

  /**
   * Returns a String representation of this object. While this
   * method informs as XML format representaion, it's purpose is
   * just information, not making a rigid XML documentation.
   *
   * @return String
   */
  public String toString() {
    try {
      return (makeTextDocument());
    } catch (Exception e) {
      return (super.toString());
    }
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   *
   * @exception SAXException
   */
  public void makeDocument(ContentHandler handler)
        throws SAXException {
    handler.startDocument();
    makeElement(handler);
    handler.endDocument();
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param handler
   *
   * @exception SAXException
   */
  public void makeElement(ContentHandler handler) throws SAXException {
    rNSContext_.startNSMappings(handler);

    String prefix =
      rNSContext_.getPrefixByUri(
        "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages");
    int size;
    String string;
    String slotQName;
    AttributesImpl attrs = new AttributesImpl();
    String qName = URelaxer.getQName(prefix, "pages");

    handler.startElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "pages", qName, attrs);
    size = this.page_.size();

    for (int i = 0; i < size; i++) {
      Page value = (Page)this.page_.get(i);

      value.makeElement(handler);
    }

    handler.endElement("http://JaJaWiki.kgslab.ath.cx/schema/WikiPages",
      "pages", qName);
    rNSContext_.endNSMappings(handler);
  }

  /**
   * Generates SAX events for ContentHandler.
   *
   * @param attrs
   *
   * @exception SAXException
   */
  public void makeAttribute(AttributesImpl attrs) throws SAXException {
  }

  /**
   * Event handler for InitElement during object construction.
   *
   * @param attrs
   */
  public void initElement(Attributes attrs) {
    String string;
  }

  /**
   * Event handler for declarePrefixMapping during object
   * construction.
   *
   * @param prefix
   * @param uri
   */
  public void declarePrefixMapping(String prefix, String uri) {
    rNSContext_.declareNamespace(prefix, uri);
  }

  /**
   * Event handler for startElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @param attrs
   *
   * @return IRContentClassHandler
   */
  public IRContentClassHandler startElement(String namespaceURI,
    String localName, String qName, Attributes attrs) {
    if ("page".equals(localName)
          && "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages".equals(
            namespaceURI)) {
      Page ref = new Page();

      ref.initElement(attrs);
      addPage(ref);

      return (ref);
    }

    return (this);
  }

  /**
   * Event handler for endElement during object construction.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   *
   * @return IRContentClassHandler
   */
  public IRContentClassHandler endElement(String namespaceURI,
    String localName, String qName) {
    String string;

    return ((IRContentClassHandler)rGetParentRNode());
  }

  /**
   * Event handler for characters during object construction.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void characters(char[] ch, int start, int length) {
    if (saxBuffer_ != null) {
      saxBuffer_.append(ch, start, length);
    }
  }

  /**
   * Event handler for processngInstruction during object
   * construction.
   *
   * @param target
   * @param value
   */
  public void processingInstruction(String target, String value) {
  }

  /**
   * Gets the IRNode property <b>parentRNode</b>.
   *
   * @return IRNode
   */
  public final IRNode rGetParentRNode() {
    return (parentRNode_);
  }

  /**
   * Sets the IRNode property <b>parentRNode</b>.
   *
   * @param parentRNode
   */
  public final void rSetParentRNode(IRNode parentRNode) {
    this.parentRNode_ = parentRNode;
  }

  /**
   * Gets child RNodes.
   *
   * @return IRNode[]
   */
  public IRNode[] rGetRNodes() {
    java.util.List classNodes = new java.util.ArrayList();

    classNodes.addAll(page_);

    IRNode[] nodes = new IRNode[classNodes.size()];

    return ((IRNode[])classNodes.toArray(nodes));
  }

  /**
   * Tests if a Element <code>element</code> is valid for the
   * <code>Pages</code>.
   *
   * @param element
   *
   * @return boolean
   */
  public static boolean isMatch(Element element) {
    if (!URelaxer2.isTargetElement(element,
            "http://JaJaWiki.kgslab.ath.cx/schema/WikiPages", "pages")) {
      return (false);
    }

    RStack target = new RStack(element);
    boolean $match$ = false;
    Element child;

    while (true) {
      if (!Page.isMatchHungry(target)) {
        break;
      }

      $match$ = true;
    }

    if (!target.isEmptyElement()) {
      return (false);
    }

    return (true);
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code> is
   * valid for the <code>Pages</code>. This mehtod is supposed to be
   * used internally by the Relaxer system.
   *
   * @param stack
   *
   * @return boolean
   */
  public static boolean isMatch(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    return (isMatch(element));
  }

  /**
   * Tests if elements contained in a Stack <code>stack</code> is
   * valid for the <code>Pages</code>. This method consumes the
   * stack contents during matching operation. This mehtod is
   * supposed to be used internally by the Relaxer system.
   *
   * @param stack
   *
   * @return boolean
   */
  public static boolean isMatchHungry(RStack stack) {
    Element element = stack.peekElement();

    if (element == null) {
      return (false);
    }

    if (isMatch(element)) {
      stack.popElement();

      return (true);
    } else {
      return (false);
    }
  }
}
