/*
 * $Id: WikiPagesContentHandler.java 71 2004-02-27 07:21:29Z nagasawa $
 */
package cx.ath.kgslab.wiki.relaxer.pages;

import java.util.*;

import org.xml.sax.*;


/**
 * DOCUMENT ME!
 *
 * @author Relaxer 1.0b (http://www.relaxer.org)
 * @version WikiPages.rng 1.0 (Wed Nov 26 14:58:00 JST 2003)
 */
public class WikiPagesContentHandler
      extends org.xml.sax.helpers.DefaultHandler {
  /** DOCUMENT ME! */
  private WikiPagesBaseHandler root_;

  /** DOCUMENT ME! */
  private IRContentClassHandler handler_;

  /** DOCUMENT ME! */
  private List mappings_ = new ArrayList();

  /**
   * Gets a object.
   *
   * @return Object
   */
  public Object get() {
    Object object;

    object = root_.getPages();

    if (object != null) {
      return (object);
    }

    object = root_.getPage();

    if (object != null) {
      return (object);
    }

    return (null);
  }

  /**
   * Gets a Pages.
   *
   * @return Pages
   */
  public Pages getPages() {
    return (root_.getPages());
  }

  /**
   * Gets a Page.
   *
   * @return Page
   */
  public Page getPage() {
    return (root_.getPage());
  }

  /**
   * Event handler for setDocumentLocator of ContentHandler.
   *
   * @param locator
   */
  public void setDocumentLocator(Locator locator) {
  }

  /**
   * Event handler for start of ContentHandler.
   */
  public void startDocument() {
    handler_ = root_ = new WikiPagesBaseHandler();
  }

  /**
   * Event handler for endDocument of ContentHandler.
   */
  public void endDocument() {
  }

  /**
   * Event handler for startPrefixMapping of ContentHandler.
   *
   * @param prefix
   * @param uri
   */
  public void startPrefixMapping(String prefix, String uri) {
    mappings_.add(new String[] { prefix, uri });
  }

  /**
   * Event handler for endPrefixMapping of ContentHandler.
   *
   * @param prefix
   */
  public void endPrefixMapping(String prefix) {
  }

  /**
   * Event handler for startElement of ContentHandler.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   * @param attrs
   */
  public void startElement(String namespaceURI, String localName,
    String qName, Attributes attrs) {
    handler_ =
      handler_.startElement(namespaceURI, localName, qName, attrs);

    int size = mappings_.size();

    for (int i = 0; i < size; i++) {
      String[] mapping = (String[])mappings_.get(i);

      handler_.declarePrefixMapping(mapping[0], mapping[1]);
    }

    mappings_.clear();
  }

  /**
   * Event handler for endElement of ContentHandler.
   *
   * @param namespaceURI
   * @param localName
   * @param qName
   */
  public void endElement(String namespaceURI, String localName,
    String qName) {
    handler_ = handler_.endElement(namespaceURI, localName, qName);
  }

  /**
   * Event handler for characters of ContentHandler.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void characters(char[] ch, int start, int length) {
    handler_.characters(ch, start, length);
  }

  /**
   * Event handler for ignorableWhitespace of ContentHandler.
   *
   * @param ch
   * @param start
   * @param length
   */
  public void ignorableWhitespace(char[] ch, int start, int length) {
  }

  /**
   * Event handler for processingInstruction of ContentHandler.
   *
   * @param target
   * @param value
   */
  public void processingInstruction(String target, String value) {
    handler_.processingInstruction(target, value);
  }

  /**
   * Event handler for skippedEntity of ContentHandler.
   *
   * @param name
   */
  public void skippedEntity(String name) {
  }
}
