/*
 * $Id: PageConverter.java 71 2004-02-27 07:21:29Z nagasawa $
 */
package cx.ath.kgslab.wiki.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import java.net.URLEncoder;

import java.nio.channels.FileLock;

import java.util.StringTokenizer;

import cx.ath.kgslab.wiki.relaxer.pages.Page;
import cx.ath.kgslab.xmlutil.DateTime;


/**
 * 1.0`Wikiy[W2.0`ɕϊB
 *
 * @author VM
 * @version 1.0
 */
public class PageConverter {
  /** DOCUMENT ME! */
  static final String TXT = ".txt";

  /** DOCUMENT ME! */
  static final String XML = ".xml";
  static File path = new File(".");

  /** DOCUMENT ME! */
  String enc = "utf-8";

  /**
   * RXgN^
   *
   * @param enc GR[h
   *
   * @throws IOException 
   */
  public PageConverter(String enc) throws IOException {
    File[] files = path.listFiles();

    this.enc = enc;

    for (int i = 0; i < files.length; i++) {
      File file = files[i];
      String name = file.getName();

      if (name.endsWith(TXT)) {
        Page page = new Page();

        page.setTitle(name.substring(0, name.length() - TXT.length()));

        FileInputStream fis = new FileInputStream(file);
        char[] buf = new char[1024];
        InputStreamReader reader = new InputStreamReader(fis, enc);
        StringWriter writer = new StringWriter(4096);
        int count = reader.read(buf);

        while (count > 0) {
          writer.write(buf, 0, count);
          count = reader.read(buf);
        }

        writer.close();
        reader.close();

        page.setContent(writer.toString());

        DateTime time = new DateTime();

        time.setTimeInMillis(file.lastModified());
        page.setLastModified(time);

        writePage(page);
      }
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param args DOCUMENT ME!
   */
  public static void main(String[] args) {
    try {
      String enc = "UTF-8";

      if (args.length > 0) {
        enc = args[0];
      }

      new PageConverter(enc);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param name
   *
   * @return
   *
   * @throws RuntimeException DOCUMENT ME!
   */
  protected File getFile(String name) {
    try {
      String converted = URLEncoder.encode(name, enc);
      StringTokenizer tokens = new StringTokenizer(converted, "%");
      StringBuffer buf =
        new StringBuffer(converted.length() + XML.length());

      while (tokens.hasMoreTokens()) {
        buf.append(tokens.nextToken());
      }

      buf.append(XML);

      File file = new File(path, buf.toString());

      return file;
    } catch (UnsupportedEncodingException uex) {
      throw new RuntimeException("URLGR[fBO[" + enc + "]gpł܂B",
        uex);
    }
  }

  /**
   * DOCUMENT ME!
   *
   * @param page
   *
   * @throws RuntimeException DOCUMENT ME!
   *
   * @see cx.ath.kgslab.wiki.PageManager#putPage(cx.ath.kgslab.wiki.pages.Page)
   */
  public void writePage(Page page) {
    File file = getFile(page.getTitle());
    FileOutputStream fos = null;
    Writer writer = null;
    FileLock fileLock = null;

    try {
      page.setLastModified(new DateTime());
      fos = new FileOutputStream(file);
      fileLock = fos.getChannel().lock();
      writer = new OutputStreamWriter(fos, enc);
      writer.write("<?xml version=\"1.0\" encoding=\"" + enc
        + "\" ?>\n");
      writer.write(page.makeTextDocument());
    } catch (FileNotFoundException e) {
      throw new RuntimeException(e);
    } catch (IOException e) {
      throw new RuntimeException(e);
    } finally {
      try {
        if (writer != null) {
          writer.close();
        }

        if (fileLock != null) {
          fileLock.release();
        }
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
}
