<%@ page contentType="text/html; charset=utf-8"%>
<%@ page pageEncoding="utf-8"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%> 
<%@ taglib uri="/tags/struts-logic" prefix="logic"%> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<html:xhtml/>
<fmt:bundle basename="cx.ath.kgslab.wiki.ApplicationResources">
<%-- データがなければファイル一覧は表示しない --%>
<c:if test="${attachForm.count gt 0}">
 <html:form action="remove.do">
  <div>
   <html:hidden name="attachForm" property="page" />
   <table border="1">
    <tr>
     <th><%-- ファイル名 --%><fmt:message key="view.upload.filename"/></th>
     <th><%-- サイズ --%><fmt:message key="view.upload.size"/>(Byte)</th>
     <th><%-- 更新日時 --%><fmt:message key="view.upload.lastupdate"/></th>
     <th><%-- 削除 --%><fmt:message key="view.upload.deleteflg"/></th>
    </tr>
    <logic:iterate id="file" name="attachForm" property="attachFiles">
     <tr>
      <td>${file.name}</td>
      <td>${file.size}</td>
      <td>${file.lastupdate}</td>
      <td><html:multibox name="attachForm" property="delete">${file.name}</html:multibox></td>
     </tr>
    </logic:iterate>
   </table>
   <html:submit><%-- 削除 --%><fmt:message key="view.upload.delete"/></html:submit>
  </div>
 </html:form>
</c:if>

<html:form action="upload" enctype="multipart/form-data">
 <div>
  <%-- このページに添付したいファイルを入力してください。 --%>
  <fmt:message key="view.upload.message"/>
  <br />
  <html:hidden name="attachForm" property="page" />
  <%-- 添付ファイル --%><fmt:message key="view.upload.attachfile"/> : <html:file property="file" /><br />
  <%-- 登録ファイル名 --%><fmt:message key="view.upload.commitfilename"/> : <html:text property="name" /><br />
  <html:checkbox property="overwrite"><%-- 上書き --%><fmt:message key="view.upload.overwrite"/></html:checkbox><br />
  <html:submit><%-- 送信 --%><fmt:message key="view.upload.submit"/></html:submit>
 </div>
</html:form>
<br />
<html:link action="view.do?page=${attachForm.page}">[<%-- 戻る --%><fmt:message key="view.return"/>]</html:link>
</fmt:bundle>