/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

public final class MimeBase64Encoder {
    private StringBuffer out = new StringBuffer();
    private int buf = 0;
    private int buf_bytes = 0;
    private char[] line = new char[74];
    private int line_length = 0;
    private static final byte[] crlf = "\r\n".getBytes();
    private static final char[] map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private final void encode_token() {
        int n = this.line_length;
        this.line[n] = map[0x3F & this.buf >> 18];
        this.line[n + 1] = map[0x3F & this.buf >> 12];
        this.line[n + 2] = map[0x3F & this.buf >> 6];
        this.line[n + 3] = map[0x3F & this.buf];
        this.line_length += 4;
        this.buf = 0;
        this.buf_bytes = 0;
    }

    private final void encode_partial_token() {
        int n = this.line_length;
        this.line[n] = map[0x3F & this.buf >> 18];
        this.line[n + 1] = map[0x3F & this.buf >> 12];
        this.line[n + 2] = this.buf_bytes == 1 ? 61 : map[0x3F & this.buf >> 6];
        this.line[n + 3] = this.buf_bytes <= 2 ? 61 : map[0x3F & this.buf];
        this.line_length += 4;
        this.buf = 0;
        this.buf_bytes = 0;
    }

    private final void flush_line() {
        this.out.append(this.line, 0, this.line_length);
        this.line_length = 0;
    }

    public final void translate(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.buf = this.buf_bytes == 0 ? this.buf & 0xFFFF | byArray[n2] << 16 : (this.buf_bytes == 1 ? this.buf & 0xFF00FF | byArray[n2] << 8 & 0xFFFF : this.buf & 0xFFFF00 | byArray[n2] & 0xFF);
            if (++this.buf_bytes == 3) {
                this.encode_token();
                if (this.line_length >= 72) {
                    this.flush_line();
                }
            }
            if (n2 == n - 1) {
                if (this.buf_bytes > 0 && this.buf_bytes < 3) {
                    this.encode_partial_token();
                }
                if (this.line_length > 0) {
                    this.flush_line();
                }
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.line.length) {
            this.line[n3] = '\u0000';
            ++n3;
        }
    }

    public char[] getCharArray() {
        if (this.buf_bytes != 0) {
            this.encode_partial_token();
        }
        this.flush_line();
        int n = 0;
        while (n < this.line.length) {
            this.line[n] = '\u0000';
            ++n;
        }
        char[] cArray = new char[this.out.length()];
        if (this.out.length() > 0) {
            this.out.getChars(0, this.out.length(), cArray, 0);
        }
        return cArray;
    }
}

