/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.handlers;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.ValidityException;
import org.exolab.castor.xml.XMLFieldHandler;

public class DateFieldHandler
extends XMLFieldHandler {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String DATE_FORMAT_2 = "yyyy-MM-dd'T'HH:mm:ss";
    private static TimeZone _defaultTimezone = TimeZone.getDefault();
    private FieldHandler handler = null;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Enumeration;

    public DateFieldHandler(FieldHandler fieldHandler) {
        if (fieldHandler == null) {
            String string = "The FieldHandler argument passed to the constructor of DateFieldHandler must not be null.";
            throw new IllegalArgumentException(string);
        }
        this.handler = fieldHandler;
    }

    public Object getValue(Object object) throws IllegalStateException {
        Class<?> clazz;
        Object object2 = this.handler.getValue(object);
        if (object2 == null) {
            return object2;
        }
        Object[] objectArray = null;
        if ((class$java$util$Date == null ? (class$java$util$Date = DateFieldHandler.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz = object2.getClass())) {
            objectArray = DateFieldHandler.getFormattedDate((Date)object2);
        } else if (clazz.isArray()) {
            int n = Array.getLength(object2);
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = DateFieldHandler.format(Array.get(object2, n2));
                ++n2;
            }
            objectArray = stringArray;
        } else if ((class$java$util$Enumeration == null ? (class$java$util$Enumeration = DateFieldHandler.class$("java.util.Enumeration")) : class$java$util$Enumeration).isAssignableFrom(clazz)) {
            Enumeration enumeration = (Enumeration)object2;
            Vector<String> vector = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                vector.addElement(DateFieldHandler.format(enumeration.nextElement()));
            }
            Object[] objectArray2 = new String[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
        } else {
            objectArray = object2.toString();
        }
        return objectArray;
    }

    public void setValue(Object object, Object object2) throws IllegalStateException {
        Date date = null;
        if (!(object2 instanceof Date)) {
            TimeZone timeZone;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            if (object2.toString().indexOf(".") == -1) {
                simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_2);
            }
            if ((timeZone = this.getTimeZone(object2.toString())) != null) {
                simpleDateFormat.setTimeZone(timeZone);
            }
            try {
                date = simpleDateFormat.parse(object2.toString());
            }
            catch (ParseException parseException) {
                if (object2 == null) {
                    date = new Date();
                }
                throw new IllegalStateException("Bad 'timeInstant' format:it should be yyyy-MM-dd'T'HH:mm:ss.SSS.\n");
            }
        } else {
            date = (Date)object2;
        }
        this.handler.setValue(object, date);
    }

    public void resetValue(Object object) throws IllegalStateException {
        this.handler.resetValue(object);
    }

    public void checkValidity(Object object) throws ValidityException, IllegalStateException {
    }

    public Object newInstance(Object object) throws IllegalStateException {
        return new Date();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof XMLFieldHandler)) {
            return false;
        }
        return this.handler.getClass().isInstance(object);
    }

    private TimeZone getTimeZone(String string) throws IllegalStateException {
        TimeZone timeZone = null;
        int n = -1;
        if (string.indexOf(90) != -1) {
            timeZone = TimeZone.getTimeZone("UTC");
        } else {
            int n2;
            n = string.indexOf(43);
            if (n != -1) {
                try {
                    Date date = new SimpleDateFormat("HH:mm").parse(string.substring(n + 1));
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(date);
                    int n3 = gregorianCalendar.get(11) * 60 * 60 * 1000 + gregorianCalendar.get(12) * 60 * 1000;
                    return new SimpleTimeZone(n3, "UTC");
                }
                catch (ParseException parseException) {
                    throw new IllegalStateException("Invalid 'timezone' format : should be '+HH:mm'\n");
                }
            }
            n = string.lastIndexOf(45);
            if (n != -1 && n > (n2 = string.indexOf(84))) {
                try {
                    Date date = new SimpleDateFormat("HH:mm").parse(string.substring(n + 1));
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(date);
                    int n4 = -1 * (gregorianCalendar.get(11) * 60 * 60 * 1000 + gregorianCalendar.get(12) * 60 * 1000);
                    return new SimpleTimeZone(n4, "UTC");
                }
                catch (ParseException parseException) {
                    throw new IllegalStateException("Invalid 'timezone' format : should be '-HH:mm'\n");
                }
            }
        }
        return timeZone;
    }

    private static String format(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return DateFieldHandler.getFormattedDate((Date)object);
        }
        return object.toString();
    }

    private static String getFormattedDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(_defaultTimezone);
        calendar.setTime(date);
        int n = calendar.get(15) + calendar.get(16);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        simpleDateFormat.setTimeZone(_defaultTimezone);
        String string = simpleDateFormat.format(date);
        if (n == 0) {
            return string + "Z";
        }
        String string2 = n < 0 ? "-" : "+";
        n = Math.abs(n);
        short s = (short)(n / 3600000);
        short s2 = (short)((n %= 3600000) / 60000);
        string2 = string2 + (s < 10 ? "0" + s : "" + s) + ":" + (s2 < 10 ? "0" + s2 : "" + s2);
        return string + string2;
    }

    public static void setDefaultTimeZone(TimeZone timeZone) {
        _defaultTimezone = timeZone;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

