/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.PathServices;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class IncludeUnmarshaller
extends ComponentReader {
    public IncludeUnmarshaller(Schema schema, AttributeSet attributeSet, Resolver resolver, Locator locator) throws XMLException {
        this(schema, attributeSet, resolver, locator, null);
    }

    public IncludeUnmarshaller(Schema schema, AttributeSet attributeSet, Resolver resolver, Locator locator, SchemaUnmarshallerState schemaUnmarshallerState) throws XMLException {
        this.setResolver(resolver);
        String string = attributeSet.getValue("schemaLocation");
        if (string == null) {
            throw new SchemaException("'schemaLocation' attribute missing on 'include'");
        }
        if (string.indexOf("\\") != -1) {
            String string2 = string + " is not a valid URI as defined by IETF RFC 2396.";
            string2 = string2 + "The URI mustn't contain '\\'.";
            throw new SchemaException(string2);
        }
        if (schemaUnmarshallerState.processed(string = PathServices.makeAbsolute(string, locator.getSystemId()))) {
            return;
        }
        schemaUnmarshallerState.markAsProcessed(string, schema);
        schema.addInclude(string);
        Parser parser = null;
        try {
            parser = Configuration.getParser();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (parser == null) {
            throw new SchemaException("Error failed to create parser for include");
        }
        SchemaUnmarshaller schemaUnmarshaller = new SchemaUnmarshaller(true, schemaUnmarshallerState);
        schemaUnmarshaller.setSchema(schema);
        Sax2ComponentReader sax2ComponentReader = new Sax2ComponentReader(schemaUnmarshaller);
        parser.setDocumentHandler(sax2ComponentReader);
        parser.setErrorHandler(sax2ComponentReader);
        try {
            parser.parse(new InputSource(string));
        }
        catch (IOException iOException) {
            throw new SchemaException("Error reading include file '" + string + "'");
        }
        catch (SAXException sAXException) {
            throw new SchemaException(sAXException);
        }
    }

    public String elementName() {
        return "include";
    }

    public Object getObject() {
        return null;
    }
}

