/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGeneratorImpl090;
import churchillobjects.rss4j.generator.RssGeneratorImpl091;
import churchillobjects.rss4j.generator.RssGeneratorImpl100;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class RssGenerator {
    protected DOMImplementation domImpl;
    protected OutputFormat format;
    protected Document doc;
    protected Writer outputWriter;
    protected OutputStream outputStream;
    protected Element rootElement;
    private boolean truncateText = false;
    protected int channelTitleMax;
    protected int channelDescriptionMax;
    protected int channelLinkMax;
    protected int channelPubDate;
    protected int channelBuildDate;
    protected int channelManagingEditorMax;
    protected int channelWebmasterMax;
    protected int channelCopyrightMax;
    protected int channelDocsMax;
    protected int imageTitleMax;
    protected int imageUrlMax;
    protected int imageLinkMax;
    protected int imageDescriptionMax;
    protected int itemTitleMax;
    protected int itemLinkMax;
    protected int itemDescriptionMax;
    protected int textInputTitleMax;
    protected int textInputDescriptionMax;
    protected int textInputNameMax;
    protected int textInputLinkMax;

    public static String generateRss(RssDocument rssDocument) throws RssGenerationException {
        StringWriter stringWriter = new StringWriter();
        RssGenerator.generateRss(rssDocument, stringWriter);
        return stringWriter.toString();
    }

    public static void generateRss(RssDocument rssDocument, OutputStream outputStream) throws RssGenerationException {
        RssGenerator rssGenerator = RssGenerator.getGenerator(rssDocument);
        rssGenerator.writeRssDocument(rssDocument, outputStream);
    }

    public static void generateRss(RssDocument rssDocument, File file) throws RssGenerationException {
        RssGenerator rssGenerator = RssGenerator.getGenerator(rssDocument);
        rssGenerator.writeRssDocument(rssDocument, file);
    }

    public static void generateRss(RssDocument rssDocument, Writer writer) throws RssGenerationException {
        RssGenerator rssGenerator = RssGenerator.getGenerator(rssDocument);
        rssGenerator.writeRssDocument(rssDocument, writer);
    }

    private static RssGenerator getGenerator(RssDocument rssDocument) throws RssGenerationException {
        String string = rssDocument.getVersion();
        if (string == null || string.length() == 0) {
            throw new RssGenerationException("RSS version was not specified in the RssDocument object.");
        }
        if ("0.90".equals(string)) {
            return new RssGeneratorImpl090();
        }
        if ("0.91".equals(string)) {
            return new RssGeneratorImpl091();
        }
        if ("1.0".equals(string)) {
            return new RssGeneratorImpl100();
        }
        throw new RssGenerationException("Could not find a generator for the document version: " + string);
    }

    RssGenerator() throws RssGenerationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.domImpl = documentBuilder.getDOMImplementation();
            this.format = new OutputFormat();
            this.format.setLineWidth(65);
            this.format.setIndenting(true);
            this.format.setIndent(2);
            this.format.setEncoding("UTF-8");
            this.format.setMediaType("application/xml");
            this.format.setOmitComments(true);
            this.format.setOmitXMLDeclaration(false);
            this.format.setVersion("1.0");
            this.format.setStandalone(true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RssGenerationException("Could not locate a JAXP DocumentBuilder class");
        }
        this.setMaxLengths();
    }

    protected abstract void setMaxLengths();

    protected abstract void handleChannel(RssChannel var1) throws RssGenerationException;

    protected abstract void finishDocument() throws RssGenerationException;

    private void writeRssDocument(RssDocument rssDocument) throws RssGenerationException {
        try {
            RssChannel rssChannel;
            this.createRssDocument(rssDocument);
            Enumeration enumeration = rssDocument.channels();
            while (enumeration.hasMoreElements()) {
                rssChannel = (RssChannel)enumeration.nextElement();
                if (rssChannel == null) continue;
                this.handleChannel(rssChannel);
            }
            this.finishDocument();
            rssChannel = null;
            rssChannel = this.outputWriter != null ? new XMLSerializer(this.outputWriter, this.format) : new XMLSerializer(this.outputStream, this.format);
            rssChannel.serialize(this.doc);
            return;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RssGenerationException("Could not locate a JAXP factory class");
        }
        catch (DOMException dOMException) {
            throw new RssGenerationException(dOMException);
        }
        catch (IOException iOException) {
            throw new RssGenerationException(iOException);
        }
    }

    protected abstract void createRssDocument(RssDocument var1) throws RssGenerationException;

    private void writeRssDocument(RssDocument rssDocument, OutputStream outputStream) throws RssGenerationException {
        this.outputStream = outputStream;
        this.writeRssDocument(rssDocument);
    }

    private void writeRssDocument(RssDocument rssDocument, File file) throws RssGenerationException {
        try {
            this.outputStream = new FileOutputStream(file);
            this.writeRssDocument(rssDocument);
            return;
        }
        catch (IOException iOException) {
            throw new RssGenerationException(iOException);
        }
    }

    private void writeRssDocument(RssDocument rssDocument, Writer writer) throws RssGenerationException {
        this.outputWriter = writer;
        this.writeRssDocument(rssDocument);
    }

    protected Element add(Element element, String string, String string2) {
        if (string2 != null) {
            Element element2 = this.doc.createElement(string);
            Text text = this.doc.createTextNode(string2);
            element2.appendChild(text);
            element.appendChild(element2);
            return element2;
        }
        return null;
    }

    public void setTruncateText(boolean bl) {
        this.truncateText = bl;
    }

    public boolean isTruncateText() {
        return this.truncateText;
    }

    protected String truncate(String string, int n) throws RssGenerationException {
        if (!this.truncateText || string == null || n == 0) {
            return string;
        }
        if ((string = string.trim()).length() <= n) {
            return string;
        }
        string = string.substring(0, n - 3).trim();
        return String.valueOf(string) + "...";
    }

    protected void validateValueRequired(String string, String string2, int n, int n2) throws RssGenerationException {
        if (string == null || string.length() == 0) {
            throw new RssGenerationException(String.valueOf(string2) + " attribute required");
        }
        if (string == null || string.length() == 0 || n2 > 0 && string.length() > n2) {
            throw new RssGenerationException(String.valueOf(string2) + " attribute must be between " + n + " and " + n2 + " characters: " + string.length() + " '" + string + "'");
        }
    }

    protected void validateValueRequired(String string, String string2, int n) throws RssGenerationException {
        this.validateValueRequired(string, string2, 1, n);
    }

    protected void validateValueOptional(String string, String string2, int n, int n2) throws RssGenerationException {
        if (n2 > 0 && string != null && string.length() > n2) {
            throw new RssGenerationException(String.valueOf(string2) + " optional, but length must be between " + n + " and " + n2 + " characters: " + string.length() + " '" + string + "'");
        }
    }

    protected void validateValueOptional(String string, String string2, int n) throws RssGenerationException {
        this.validateValueOptional(string, string2, 1, n);
    }

    protected String embedHtml(String string) {
        if (string.indexOf("<") >= 0) {
            string = "<[!CDATA[" + string + "]]>";
        }
        return string;
    }

    protected void validateUri(String string) throws RssGenerationException {
        if (!(string == null || string.length() <= 0 || string.startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:") || string.startsWith("mailto:"))) {
            throw new RssGenerationException("Invalid URI format: must be 'http:', 'https:', 'ftp:', or 'mailto:' - " + string);
        }
    }
}

