/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.parser;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.model.RssNamespace;
import churchillobjects.rss4j.model.RssVersion;
import churchillobjects.rss4j.parser.RssParseException;
import churchillobjects.rss4j.parser.RssParserImpl090;
import churchillobjects.rss4j.parser.RssParserImpl091;
import churchillobjects.rss4j.parser.RssParserImpl100;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RssParser
extends DefaultHandler
implements RssVersion {
    private XMLReader parser;
    protected RssDocument document;
    protected RssChannel currentChannel;
    protected RssChannelItem currentItem;
    protected RssChannelTextInput currentTextInput;
    protected RssChannelImage currentImage;
    private StringBuffer characters;
    protected Vector namespaces;

    public static RssDocument parseRss(String string) throws RssParseException {
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        RssParser rssParser = new RssParser();
        return rssParser.parseRss(inputSource);
    }

    public static RssDocument parseRss(InputStream inputStream) throws RssParseException {
        InputSource inputSource = new InputSource(inputStream);
        RssParser rssParser = new RssParser();
        return rssParser.parseRss(inputSource);
    }

    public static RssDocument parseRss(Reader reader) throws RssParseException {
        InputSource inputSource = new InputSource(reader);
        RssParser rssParser = new RssParser();
        return rssParser.parseRss(inputSource);
    }

    public static RssDocument parseRss(File file) throws RssParseException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RssParseException(fileNotFoundException);
        }
        InputSource inputSource = new InputSource(fileInputStream);
        RssParser rssParser = new RssParser();
        return rssParser.parseRss(inputSource);
    }

    RssParser() {
        this.namespaces = new Vector();
    }

    RssParser(RssDocument rssDocument, Vector vector) {
        this.document = rssDocument;
        this.namespaces = vector;
    }

    RssDocument parseRss(InputSource inputSource) throws RssParseException {
        this.document = new RssDocument();
        this.namespaces = new Vector();
        this.characters = new StringBuffer();
        this.parser = new SAXParser();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        try {
            this.parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            this.cleanUp();
            if (sAXException.getException() instanceof RssParseException) {
                throw (RssParseException)sAXException.getException();
            }
            throw new RssParseException(sAXException.getException());
        }
        catch (IOException iOException) {
            this.cleanUp();
            throw new RssParseException(iOException);
        }
        RssDocument rssDocument = this.document;
        this.cleanUp();
        return rssDocument;
    }

    protected void cleanUp() {
        this.parser = null;
        this.document = null;
        this.currentChannel = null;
        this.currentItem = null;
        this.currentTextInput = null;
        this.currentImage = null;
        this.characters = null;
        this.namespaces = null;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.namespaces.addElement(new RssNamespace(string, string2));
        if (string.length() == 0) {
            if ("http://my.netscape.com/rdf/simple/0.9/".equals(string2)) {
                this.document.setVersion("0.90");
                RssParserImpl090 rssParserImpl090 = new RssParserImpl090(this.document, this.namespaces);
                this.parser.setContentHandler(rssParserImpl090);
                this.parser.setErrorHandler(rssParserImpl090);
                return;
            }
            if ("http://purl.org/rss/1.0/".equals(string2)) {
                this.document.setVersion("1.0");
                RssParserImpl100 rssParserImpl100 = new RssParserImpl100(this.document, this.namespaces);
                this.parser.setContentHandler(rssParserImpl100);
                this.parser.setErrorHandler(rssParserImpl100);
                return;
            }
            throw new SAXException(new RssParseException("Could not determine the RSS version from namespace: " + string2));
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("rss")) {
            String string4 = attributes.getValue("version");
            if (string4.equals("0.91")) {
                this.document.setVersion("0.91");
                RssParserImpl091 rssParserImpl091 = new RssParserImpl091(this.document, null);
                this.parser.setContentHandler(rssParserImpl091);
                this.parser.setErrorHandler(rssParserImpl091);
            } else {
                if (string4.equals("0.92")) {
                    throw new SAXException(new RssParseException("RSS 0.92 not supported by this toolkit"));
                }
                throw new SAXException(new RssParseException("Could not determine the RSS version: " + string4));
            }
        }
        if (string2.equals("channel")) {
            throw new SAXException(new RssParseException("Could not determine the RSS version of this document."));
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.characters == null) {
            this.characters = new StringBuffer();
        }
        this.characters.append(cArray, n, n2);
    }

    protected String getChars() {
        if (this.characters == null) {
            return "";
        }
        String string = this.characters.toString().trim();
        this.resetChars();
        return string;
    }

    protected boolean hasChars() {
        if (this.characters == null) {
            return false;
        }
        return this.characters.toString().trim().length() > 0;
    }

    protected void resetChars() {
        this.characters = null;
    }

    protected String getAttribute(Attributes attributes, String string) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getQName(n);
            if (string2.equals(string)) {
                return attributes.getValue(n);
            }
            ++n;
        }
        return null;
    }
}

