/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.IOException;
import net.java.sen.CToken;
import net.java.sen.io.FileAccessor;
import net.java.sen.io.FileAccessorFactory;
import net.java.sen.util.DoubleArrayTrie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Dictionary {
    private static Log log;
    private FileAccessor tfd = null;
    private FileAccessor ffd = null;
    private DoubleArrayTrie da = new DoubleArrayTrie();
    private CToken[] result = new CToken[256];
    private int[] daresult = new int[256];
    private String charset = "utf-8";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.java.sen.Dictionary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean close() {
        return true;
    }

    public CToken[] commonPrefixSearch(char[] str, int pos) throws IOException {
        int size = 0;
        if (log.isTraceEnabled()) {
            log.trace((Object)("input=" + new String(str, pos, str.length - pos)));
            log.trace((Object)("pos=" + pos));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("str.length=" + str.length));
            log.trace((Object)("pos2=" + pos));
        }
        int n = this.da.commonPrefixSearch(str, this.daresult, pos, 0);
        if (log.isTraceEnabled()) {
            log.trace((Object)("number of prefix = " + n));
        }
        int i = 0;
        while (i < n) {
            int k = 0xFF & this.daresult[i];
            int p = this.daresult[i] >> 8;
            if (log.isTraceEnabled()) {
                log.trace((Object)("token location = " + p));
            }
            this.tfd.seek((int)((long)(p + 3) * 16L));
            int j = 0;
            while (j < k) {
                this.result[size] = new CToken();
                this.result[size].read(this.tfd);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"----found----");
                    log.trace((Object)("posInfo=" + this.getPosInfo(this.result[size].posID)));
                    log.trace((Object)("rcAttr2=" + this.result[size].rcAttr2));
                    log.trace((Object)("rcAttr1=" + this.result[size].rcAttr1));
                    log.trace((Object)("lcAttr=" + this.result[size].lcAttr));
                    log.trace((Object)("length=" + this.result[size].length));
                    log.trace((Object)("cost=" + this.result[size].cost));
                }
                ++size;
                ++j;
            }
            ++i;
        }
        this.result[size] = null;
        return this.result;
    }

    CToken[] exactMatchSearch(char[] str, int pos) throws IOException {
        int n;
        int size = 0;
        int len = str.length;
        if (log.isTraceEnabled()) {
            log.trace((Object)("len=" + len));
        }
        if ((n = this.da.search(str, pos, 0)) != -1) {
            int k = 0xFF & n;
            int p = n >> 8;
            this.tfd.seek((int)((long)(p + 3) * 16L));
            int i = 0;
            while (i < k) {
                this.result[size] = new CToken();
                this.result[size].read(this.tfd);
                this.result[size].length = (short)(this.result[size].length / 2);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("rcAttr2=" + this.result[size].rcAttr2));
                    log.trace((Object)("rcAttr1=" + this.result[size].rcAttr1));
                    log.trace((Object)("lcAttr=" + this.result[size].lcAttr));
                    log.trace((Object)("length=" + this.result[size].length));
                    log.trace((Object)("str=" + new String(str, pos, (int)this.result[size].length)));
                }
                ++size;
                ++i;
            }
        }
        this.result[size] = null;
        return this.result;
    }

    public String getPosInfo(int f) {
        if (f == -1) {
            return null;
        }
        try {
            int cnt = 0;
            byte[] b = new byte[256];
            this.ffd.seek(f);
            while (this.ffd.read(b, cnt, 1) != -1 && b[cnt] != 0) {
                ++cnt;
            }
            byte[] b2 = new byte[cnt];
            int i = 0;
            while (i < cnt) {
                b2[i] = b[i];
                ++i;
            }
            return new String(b2, this.charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Dictionary(String tokenFile, String doubleArrayFile, String posInfoFile, String charset) throws IOException {
        this.charset = charset;
        log.info((Object)("token file = " + tokenFile));
        long start = System.currentTimeMillis();
        this.tfd = FileAccessorFactory.getInstance(tokenFile);
        log.info((Object)("time to load posInfo file = " + (System.currentTimeMillis() - start) + "[ms]"));
        log.info((Object)("double array trie dictionary = " + doubleArrayFile));
        this.da.load(doubleArrayFile);
        log.info((Object)("pos info file = " + posInfoFile));
        start = System.currentTimeMillis();
        this.ffd = FileAccessorFactory.getInstance(posInfoFile);
        log.info((Object)("time to load pos info file = " + (System.currentTimeMillis() - start) + "[ms]"));
    }

    public CToken getBOSToken() throws IOException {
        this.tfd.seek(0);
        CToken t = new CToken();
        t.read(this.tfd);
        log.debug((Object)"getBOSToken()");
        log.debug((Object)("rcAttr2 = " + t.rcAttr2));
        log.debug((Object)("rcAttr1 = " + t.rcAttr1));
        log.debug((Object)("lcAttr = " + t.lcAttr));
        log.debug((Object)("posid = " + t.posid));
        log.debug((Object)("length = " + t.length));
        log.debug((Object)("cost = " + t.cost));
        log.debug((Object)("posID = " + t.posID));
        return t;
    }

    public CToken getEOSToken() throws IOException {
        this.tfd.seek(16);
        CToken t = new CToken();
        t.read(this.tfd);
        log.debug((Object)"getEOSToken()");
        log.debug((Object)("rcAttr2 = " + t.rcAttr2));
        log.debug((Object)("rcAttr1 = " + t.rcAttr1));
        log.debug((Object)("lcAttr = " + t.lcAttr));
        log.debug((Object)("posid = " + t.posid));
        log.debug((Object)("length = " + t.length));
        log.debug((Object)("cost = " + t.cost));
        log.debug((Object)("posID = " + t.posID));
        return t;
    }

    public CToken getUnknownToken() throws IOException {
        this.tfd.seek(32);
        CToken t = new CToken();
        t.read(this.tfd);
        log.debug((Object)"getEOSToken()");
        log.debug((Object)("rcAttr2 = " + t.rcAttr2));
        log.debug((Object)("rcAttr1 = " + t.rcAttr1));
        log.debug((Object)("lcAttr = " + t.lcAttr));
        log.debug((Object)("posid = " + t.posid));
        log.debug((Object)("length = " + t.length));
        log.debug((Object)("cost = " + t.cost));
        log.debug((Object)("posID = " + t.posID));
        return t;
    }
}

