/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.File;
import java.io.IOException;
import net.java.sen.CToken;
import net.java.sen.Dictionary;
import net.java.sen.Node;
import net.java.sen.io.FileAccessor;
import net.java.sen.io.FileAccessorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Tokenizer {
    private int id;
    private Node bosNode2 = new Node();
    private Node eosNode = new Node();
    public Dictionary dic = null;
    public CToken bosToken = null;
    public CToken bosToken2 = new CToken();
    public CToken eosToken = null;
    public CToken unknownToken = new CToken();
    public Node bosNode = new Node();
    private short[] matrix;
    private int msize1;
    private int msize2;
    private int msize3;
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.java.sen.Tokenizer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Tokenizer(String tokenFile, String doubleArrayFile, String posInfoFile, String connectFile, String charset) throws IOException {
        this.dic = new Dictionary(tokenFile, doubleArrayFile, posInfoFile, charset);
        this.bosToken = this.dic.getBOSToken();
        this.bosToken2 = this.dic.getBOSToken();
        this.eosToken = this.dic.getEOSToken();
        this.unknownToken = this.dic.getUnknownToken();
        this.loadConnectCost(connectFile);
    }

    private void loadConnectCost(String connectFile) throws IOException {
        FileAccessor fd = null;
        File f = new File(connectFile);
        log.info((Object)("connection file = " + f.toString()));
        long start = System.currentTimeMillis();
        fd = FileAccessorFactory.getInstance(f);
        this.msize1 = fd.readShort();
        this.msize2 = fd.readShort();
        this.msize3 = fd.readShort();
        int len = ((int)f.length() - 6) / 2;
        log.debug((Object)("msize1=" + this.msize1));
        log.debug((Object)("msize2=" + this.msize2));
        log.debug((Object)("msize3=" + this.msize3));
        log.debug((Object)("matrix size = " + len));
        this.matrix = new short[len];
        int i = 0;
        while (i < len) {
            this.matrix[i] = fd.readShort();
            ++i;
        }
        log.info((Object)("time to load connect cost file = " + (System.currentTimeMillis() - start) + "[ms]"));
        fd.close();
    }

    public int skipCharClass(char[] c, int begin, int end, int char_class, int[] fail) {
        int p = begin;
        while (p != end && (fail[0] = this.getCharClass(c[p])) == char_class) {
            ++p;
        }
        if (p == end) {
            fail[0] = 0;
        }
        return p;
    }

    public int skipCharClass(char[] c, int begin, int end, int char_class) {
        int p = begin;
        while (p != end && this.getCharClass(c[p]) == char_class) {
            ++p;
        }
        return p;
    }

    public abstract int getCharClass(char var1);

    public abstract Node lookup(char[] var1, int var2) throws IOException;

    public void clear() {
        this.id = 0;
    }

    public Node getNewNode() {
        Node node = new Node();
        node.id = this.id++;
        return node;
    }

    Node getBOSNode() {
        this.bosNode.clear();
        this.bosNode2.clear();
        this.bosNode.prev = this.bosNode2;
        this.bosNode2.surface = null;
        this.bosNode.surface = null;
        this.bosNode2.length = 0;
        this.bosNode.length = 0;
        this.bosNode.token = this.bosToken;
        this.bosNode2.token = this.bosToken2;
        return this.bosNode;
    }

    Node getEOSNode() {
        this.eosNode.clear();
        this.eosNode.surface = null;
        this.eosNode.length = 1;
        this.eosNode.token = this.eosToken;
        return this.eosNode;
    }

    int getCost(Node lNode2, Node lNode, Node rNode) {
        int pos = this.msize3 * (this.msize2 * lNode2.token.rcAttr2 + lNode.token.rcAttr1) + rNode.token.lcAttr;
        if (pos >= this.matrix.length) {
            System.out.println("error pos=" + pos);
            System.out.println("matrix=" + this.matrix.length);
        }
        return this.matrix[pos] + rNode.token.cost;
    }

    public boolean close() {
        return this.dic.close();
    }
}

