/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.tools;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import net.java.sen.CToken;
import net.java.sen.tools.DictionaryMaker;
import net.java.sen.tools.PairObject;
import net.java.sen.util.CSVParser;
import net.java.sen.util.DoubleArrayTrie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MkChaDic {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.java.sen.tools.MkChaDic");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static void main(String[] args) {
        CToken token;
        ResourceBundle rb = ResourceBundle.getBundle("dictionary");
        DictionaryMaker dm1 = new DictionaryMaker();
        DictionaryMaker dm2 = new DictionaryMaker();
        DictionaryMaker dm3 = new DictionaryMaker();
        Vector<String> rule1 = new Vector<String>();
        Vector<String> rule2 = new Vector<String>();
        Vector<String> rule3 = new Vector<String>();
        short[] score = new short[20131];
        long start = System.currentTimeMillis();
        log.info((Object)"(1/7): reading connection matrix ... ");
        try {
            String[] t;
            CSVParser csvparser = new CSVParser(new FileInputStream(rb.getString("text_connection_file")), rb.getString("dic.charset"));
            int line = 0;
            while ((t = csvparser.nextTokens()) != null) {
                dm1.add(t[0]);
                rule1.add(t[0]);
                dm2.add(t[1]);
                rule2.add(t[1]);
                dm3.add(t[2]);
                rule3.add(t[2]);
                if (line == score.length) {
                    score = MkChaDic.resize(score);
                }
                score[line++] = (short)Integer.parseInt(t[3]);
            }
            log.info((Object)"(2/7): building type dictionary ... ");
            dm1.build();
            dm2.build();
            dm3.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        int size1 = dm1.size();
        int size2 = dm2.size();
        int size3 = dm3.size();
        int ruleSize = rule1.size();
        short[] matrix = new short[size1 * size2 * size3];
        short default_cost = (short)Integer.parseInt(rb.getString("default_connection_cost"));
        log.info((Object)("(3/7): writing conection matrix (" + size1 + " x " + size2 + " x " + size3 + " = " + size1 * size2 * size3 + ") ..."));
        int i = 0;
        while (i < size1 * size2 * size3) {
            matrix[i] = default_cost;
            ++i;
        }
        i = 0;
        while (i < ruleSize) {
            Vector r1 = dm1.getRuleIdList((String)rule1.get(i));
            Vector r2 = dm2.getRuleIdList((String)rule2.get(i));
            Vector r3 = dm3.getRuleIdList((String)rule3.get(i));
            Iterator i1 = r1.iterator();
            while (i1.hasNext()) {
                int ii1 = (Integer)i1.next();
                Iterator i2 = r2.iterator();
                while (i2.hasNext()) {
                    int ii2 = (Integer)i2.next();
                    Iterator i3 = r3.iterator();
                    while (i3.hasNext()) {
                        int ii3 = (Integer)i3.next();
                        int pos = size3 * (size2 * ii1 + ii2) + ii3;
                        matrix[pos] = score[i];
                    }
                }
            }
            ++i;
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(rb.getString("matrix_file"))));
            out.writeShort(size1);
            out.writeShort(size2);
            out.writeShort(size3);
            int i1 = 0;
            while (i1 < size1) {
                int i2 = 0;
                while (i2 < size2) {
                    int i3 = 0;
                    while (i3 < size3) {
                        out.writeShort(matrix[size3 * (size2 * i1 + i2) + i3]);
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        matrix = null;
        score = null;
        int pos_start = Integer.parseInt(rb.getString("pos_start"));
        int pos_size = Integer.parseInt(rb.getString("pos_size"));
        int di = 0;
        int offset = 0;
        ArrayList<PairObject> dicList = new ArrayList<PairObject>();
        log.info((Object)"(4/7): reading morpheme information ... ");
        try {
            String t;
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rb.getString("pos_file")), rb.getString("sen.charset")));
            BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rb.getString("text_dic_file")), rb.getString("dic.charset")));
            int line = 0;
            StringBuffer key_b = new StringBuffer();
            StringBuffer pos_b = new StringBuffer();
            while ((t = is.readLine()) != null) {
                String[] csv = DictionaryMaker.csv2strings(t);
                if (csv.length < pos_size + pos_start) {
                    throw new RuntimeException("format error:" + line);
                }
                key_b.setLength(0);
                pos_b.setLength(0);
                int i2 = pos_start;
                while (i2 < pos_start + pos_size - 1) {
                    key_b.append(csv[i2]);
                    key_b.append(',');
                    ++i2;
                }
                key_b.append(csv[pos_start + pos_size - 1]);
                pos_b.append(key_b);
                pos_b.append(',');
                i2 = pos_start + pos_size;
                while (i2 < csv.length - 1) {
                    pos_b.append(csv[i2]);
                    pos_b.append(',');
                    ++i2;
                }
                pos_b.append(csv[csv.length - 1]);
                token = new CToken();
                token.rcAttr2 = (short)dm1.getDicId(key_b.toString());
                token.rcAttr1 = (short)dm2.getDicId(key_b.toString());
                token.lcAttr = (short)dm3.getDicId(key_b.toString());
                token.posid = 0;
                token.posID = offset;
                token.length = (short)csv[0].length();
                token.cost = (short)Integer.parseInt(csv[1]);
                dicList.add(new PairObject(csv[0], token));
                byte[] b = pos_b.toString().getBytes(rb.getString("sen.charset"));
                offset += b.length + 1;
                bw.write(pos_b.toString(), 0, pos_b.length());
                bw.write(0);
                if (++di % 50000 != 0) continue;
                log.info((Object)(di + "... "));
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        rule1 = null;
        rule2 = null;
        rule3 = null;
        log.info((Object)"(5/7): sorting lex... ");
        int[] value = new int[dicList.size()];
        char[][] key = new char[dicList.size()][];
        int spos = 0;
        int dsize = 0;
        int bsize = 0;
        String prev = "";
        Collections.sort(dicList);
        log.info((Object)"(6/7): writing token... ");
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(rb.getString("token_file"))));
            token = new CToken();
            token.rcAttr2 = (short)dm1.getDicId(rb.getString("bos_pos"));
            token.rcAttr1 = (short)dm2.getDicId(rb.getString("bos_pos"));
            token.lcAttr = (short)dm3.getDicId(rb.getString("bos_pos"));
            token.write(out);
            token.rcAttr2 = (short)dm1.getDicId(rb.getString("eos_pos"));
            token.rcAttr1 = (short)dm2.getDicId(rb.getString("eos_pos"));
            token.lcAttr = (short)dm3.getDicId(rb.getString("eos_pos"));
            token.write(out);
            token.rcAttr2 = (short)dm1.getDicId(rb.getString("unknown_pos"));
            token.rcAttr1 = (short)dm2.getDicId(rb.getString("unknown_pos"));
            token.lcAttr = (short)dm3.getDicId(rb.getString("unknown_pos"));
            token.posID = -1;
            token.write(out);
            log.info((Object)("key size = " + key.length));
            int i3 = 0;
            while (i3 < key.length) {
                String k = (String)((PairObject)dicList.get((int)i3)).key;
                if (!prev.equals(k) && i3 != 0) {
                    key[dsize] = ((String)((PairObject)dicList.get((int)spos)).key).toCharArray();
                    value[dsize] = bsize + (spos << 8);
                    ++dsize;
                    bsize = 1;
                    spos = i3;
                } else {
                    ++bsize;
                }
                prev = (String)((PairObject)dicList.get((int)i3)).key;
                ((CToken)((PairObject)dicList.get((int)i3)).value).write(out);
                ++i3;
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        key[dsize] = ((String)((PairObject)dicList.get((int)spos)).key).toCharArray();
        value[dsize] = bsize + (spos << 8);
        ++dsize;
        System.err.println(" done!");
        dm1 = null;
        dm2 = null;
        dm3 = null;
        dicList = null;
        log.info((Object)("(7/7): building Double-Array (size = " + dsize + ") ..."));
        DoubleArrayTrie da = new DoubleArrayTrie();
        da.build(key, null, value, dsize);
        try {
            da.save(rb.getString("double_array_file"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info((Object)("total time = " + (System.currentTimeMillis() - start) / 1000L + "[ms]"));
    }

    private static short[] resize(short[] s) {
        short[] newbuf = new short[(int)((double)s.length * 1.5)];
        int i = 0;
        while (i < s.length) {
            newbuf[i] = s[i];
            ++i;
        }
        return newbuf;
    }
}

